<?php

if (class_exists('WPBakeryShortCodesContainer')) {
    class WPBakeryShortCode_tek_testimonials extends WPBakeryShortCodesContainer {
    }
}

if (class_exists('WPBakeryShortCode')) {
    class WPBakeryShortCode_tek_testimonials_single extends WPBakeryShortCode {
    }
}

if (!class_exists('tek_testimonials')) {
    class tek_testimonials extends KEYDESIGN_ADDON_CLASS
    {
        function __construct() {
            add_action('init', array($this, 'kd_testimonials_init'));
            add_shortcode('tek_testimonials', array($this, 'kd_testimonials_container'));
            add_shortcode('tek_testimonials_single', array($this, 'kd_testimonials_single'));
        }
        // Element configuration in admin

        function kd_testimonials_init() {
            // Container element configuration
            if (function_exists('vc_map')) {
                vc_map(array(
                    "name" => esc_html__("Testimonial slider", "keydesign"),
                    "description" => esc_html__("Sliding testimonials with author image.", "keydesign"),
                    "base" => "tek_testimonials",
                    "class" => "kd-outer-controls",
                    "show_settings_on_create" => true,
                    "content_element" => true,
                    "as_parent" => array('only' => 'tek_testimonials_single'),
                    "icon" => plugins_url('assets/element_icons/testimonials.png', dirname(__FILE__)),
                    "category" => esc_html("KeyDesign Elements", "keydesign"),
                    "params" => array(
                        array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__("Testimonials layout","keydesign"),
                            "param_name" => "tt_image_layout",
                            "value" =>  array(
                                "Small image" => "without-image",
                                "Large image" => "with-image",
                            ),
                            "save_always" => true,
                        ),

                        array(
                            "type" =>  "dropdown",
                            "class" =>  "",
                            "heading" =>  esc_html__("Navigation style","keydesign"),
                            "param_name" =>  "tt_nav_style",
                            "value" =>  array(
                                "Arrows" => "nav-arrows",
                                "Dots" => "nav-dots",
                                "Arrows and dots" => "nav-arrows-dots",
                            ),
                            "save_always" => true,
                            "description"   =>  esc_html__("Select navigation style.", "keydesign")
                        ),

                        array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__("Navigation color", "keydesign"),
                            "param_name" => "tt_navigation_color",
                            "value" => array(
                                "Black" => "black-navigation",
                                "White" => "white-navigation",
                            ),
                            "save_always" => true,
                            "description" => esc_html__("Select the navigation color.", "keydesign"),
                         ),

                         array(
                             "type"          =>  "dropdown",
                             "class"         =>  "",
                             "heading"       =>  esc_html__("Enable loop","keydesign"),
                             "param_name"    =>  "tt_loop",
                             "value"         =>  array(
                                     "Off" => "loop_off",
                                     "On" => "loop_on",
                                 ),
                             "save_always" => true,
                             "description"   =>  esc_html__("Infinity loop. Duplicate last and first items to get loop illusion.", "keydesign")
                         ),

                        array(
                            "type"          =>  "dropdown",
                            "class"         =>  "",
                            "heading"       =>  esc_html__("Enable autoplay","keydesign"),
                            "param_name"    =>  "tt_autoplay",
                            "value"         =>  array(
                                    "Off"   => "auto_off",
                                    "On"    => "auto_on"
                                ),
                            "save_always" => true,
                            "description"   =>  esc_html__("Carousel autoplay settings.", "keydesign")
                        ),

                        array(
                            "type"          =>  "dropdown",
                            "class"         =>  "",
                            "heading"       =>  esc_html__("Autoplay speed","keydesign"),
                            "param_name"    =>  "tt_autoplay_speed",
                            "value"         =>  array(
                                    "10s"   => "10000",
                                    "9s"   => "9000",
                                    "8s"   => "8000",
                                    "7s"   => "7000",
                                    "6s"   => "6000",
                                    "5s"   => "5000",
                                    "4s"   => "4000",
                                    "3s"   => "3000",
                                ),
                            "save_always" => true,
                            "dependency" =>	array(
                                "element" => "tt_autoplay",
                                "value" => array("auto_on")
                            ),
                            "description"   =>  esc_html__("Carousel autoplay speed.", "keydesign")
                        ),

                        array(
                            "type"          =>  "dropdown",
                            "class"         =>  "",
                            "heading"       =>  esc_html__("Stop on hover","keydesign"),
                            "param_name"    =>  "tt_stoponhover",
                            "value"         =>  array(
                                    "Off"   => "hover_off",
                                    "On"    => "hover_on"
                                ),
                            "save_always" => true,
                            "dependency" =>	array(
                                "element" => "tt_autoplay",
                                "value" => array("auto_on")
                            ),
                            "description"   =>  esc_html__("Stop sliding carousel on mouse over.", "keydesign")
                        ),

                        array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__("CSS Animation", "keydesign"),
                            "param_name" => "css_animation",
                            "value" => array(
                                "None" => "",
                                "Fade In" => "kd-animated fadeIn",
                                "Fade In Down" => "kd-animated fadeInDown",
                                "Fade In Left" => "kd-animated fadeInLeft",
                                "Fade In Right" => "kd-animated fadeInRight",
                                "Fade In Up" => "kd-animated fadeInUp",
                                "Zoom In" => "kd-animated zoomIn",
                            ),
                            "save_always" => true,
                            "admin_label" => true,
                            "description" => esc_html__("Select type of animation for element to be animated when it enters the browsers viewport (Note: works only in modern browsers).", "keydesign"),
                            "group" => esc_html__( "Extras", "keydesign" ),
                        ),

                        array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__("Animation delay", "keydesign"),
                            "param_name" => "tt_animation_delay",
                            "value" => array(
                                "0 ms" => "",
                                "200 ms" => "200",
                                "400 ms" => "400",
                                "600 ms" => "600",
                                "800 ms" => "800",
                                "1 s" => "1000",
                            ),
                            "save_always" => true,
                            "admin_label" => true,
                            "dependency" =>	array(
                                "element" => "css_animation",
                                "value" => array("kd-animated fadeIn", "kd-animated fadeInDown", "kd-animated fadeInLeft", "kd-animated fadeInRight", "kd-animated fadeInUp", "kd-animated zoomIn")
                            ),
                            "description" => esc_html__("Enter animation delay in ms.", "keydesign"),
                            "group" => esc_html__( "Extras", "keydesign" ),
                        ),

                        array(
                            "type" => "textfield",
                            "class" => "",
                            "heading" => esc_html__("Extra class name", "keydesign"),
                            "param_name" => "tt_extra_class",
                            "value" => "",
                            "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "keydesign"),
                            "group" => esc_html__( "Extras", "keydesign" ),
                        ),

                    ),
                    "js_view" => 'VcColumnView'
                ));

                // Shortcode configuration

                vc_map(array(
                    "name" => esc_html__("Testimonial slide", "keydesign"),
                    "base" => "tek_testimonials_single",
                    "content_element" => true,
                    "as_child" => array('only' => 'tek_testimonials'),
                    "icon" => plugins_url('assets/element_icons/testimonials.png', dirname(__FILE__)),
                    "params" => array(
                        array(
                            "type" => "textfield",
                            "heading" => esc_html__("Testimonial title", "keydesign"),
                            "param_name" => "tt_heading",
                            "description" => esc_html__("Testimonial title. Visible only with the large image layout.", "keydesign"),
                        ),

                        array(
                          "type" => "dropdown",
                          "class" => "",
                          "heading" => esc_html__("Title HTML tag", "keydesign"),
                          "param_name" => "tt_heading_tag",
                          "value" => array(
                              "Default" => "",
                              "h1" => "h1",
                              "h2" => "h2",
                              "h3" => "h3",
                              "h4" => "h4",
                              "h5" => "h5",
                              "h6" => "h6",
                              "div" => "div",
                              "span" => "span",
                              "p" => "p",
                          ),
                          "save_always" => true,
                          "description" => esc_html__("Select title HTML tag. The default is h5.", "keydesign")
                        ),

                        array(
                            "type" => "textarea",
                            "heading" => esc_html__("Testimonial quote", "keydesign"),
                            "param_name" => "tt_quote",
                        ),

                        array(
                          "type" => "dropdown",
                          "class" => "",
                          "heading" => esc_html__("Quote HTML tag", "keydesign"),
                          "param_name" => "tt_quote_tag",
                          "value" => array(
                              "Default" => "",
                              "h1" => "h1",
                              "h2" => "h2",
                              "h3" => "h3",
                              "h4" => "h4",
                              "h5" => "h5",
                              "h6" => "h6",
                              "div" => "div",
                              "span" => "span",
                              "p" => "p",
                          ),
                          "save_always" => true,
                          "description" => esc_html__("Select quote HTML tag. The default is h6.", "keydesign")
                        ),

                        array(
                            "type" => "textfield",
                            "heading" => esc_html__("Author name", "keydesign"),
                            "param_name" => "tt_title",
                            "admin_label" => true,
                            "description" => esc_html__("Testimonial author name.", "keydesign")
                        ),

                        array(
                          "type" => "checkbox",
                          "heading" => esc_html__( "Enable link on author name text?", "keydesign" ),
                          "param_name" => "author_name_link",
                          "value" => array( esc_html__( "Yes", "keydesign" ) => "yes" ),
                        ),

                        array(
                            "type" => "href",
                            "class" => "",
                            "heading" => esc_html__("Link URL", "keydesign"),
                            "param_name" => "author_link_url",
                            "value" => "",
                            "dependency" => array(
                               "element" => "author_name_link",
                               "value"	=> array( "yes" ),
                           ),
                        ),

                        array(
                            'type' => 'dropdown',
                            'heading' => __( 'Link target', 'keydesign' ),
                            'param_name' => 'author_link_target',
                            "value" => array(
                              esc_html__( 'Same window', 'keydesign' ) => '_self',
                              esc_html__( 'New window', 'keydesign' ) => '_blank',
                            ),
                            "save_always" => true,
                            "dependency" => array(
                               "element" => "author_name_link",
                               "value"	=> array( "yes" ),
                           ),
                        ),

                        array(
                            "type" => "textfield",
                            "heading" => esc_html__("Author description", "keydesign"),
                            "param_name" => "tt_position",
                            "description" => esc_html__("Testimonial author description.", "keydesign")
                        ),

                        array(
                            "type" => "textfield",
                            "class" => "",
                            "heading" => esc_html__("Text font size", "keydesign"),
                            "param_name" => "tt_text_size",
                            "value" => "",
                            "description" => esc_html__("Enter text font size. (In px - E.g. 24px)", "keydesign"),
                        ),

                        array(
                            "type" => "colorpicker",
                            "class" => "",
                            "heading" => esc_html__("Text color", "keydesign"),
                            "param_name" => "tt_text_color",
                            "value" => "",
                            "description" => esc_html__("Select text color.", "keydesign")
                        ),

                        array(
                            "type" => "colorpicker",
                            "class" => "",
                            "heading" => esc_html__("Box background color", "keydesign"),
                            "param_name" => "tt_bg_color",
                            "value" => "",
                            "description" => esc_html__("Select box background color.", "keydesign")
                        ),

                        array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__("Author image source", "keydesign"),
                            "param_name" => "image_source",
                            "value" => array(
                                "Media library" => "media_library",
                                "External link" => "external_link",
                            ),
                            "description" => esc_html__("Select image source.", "keydesign"),
                            "save_always" => true,
                        ),

                        array(
                            "type" => "attach_image",
                            "heading" => esc_html__("Author image", "keydesign"),
                            "param_name" => "tt_image",
                            "description" => esc_html__("Display testimonial author image.", "keydesign"),
                            "dependency" =>	array(
                                "element" => "image_source",
                                "value" => array("media_library")
                            ),
                        ),

                        array(
                            "type" => "textfield",
                            "class" => "",
                            "heading" => esc_html__("Image external source", "keydesign"),
                            "param_name" => "ext_image",
                            "value" => "",
                            "description" => esc_html__("Enter image external link.", "keydesign"),
                            "dependency" =>	array(
                                "element" => "image_source",
                                "value" => array("external_link")
                            ),
                        ),
                        array(
                            "type" => "textfield",
                            "class" => "",
                            "heading" => esc_html__("Image size", "keydesign"),
                            "param_name" => "ext_image_size",
                            "value" => "",
                            "description" => esc_html__("Enter image size in pixels. Example: 1000x500 (Width x Height).", "keydesign"),
                            "dependency" =>	array(
                                "element" => "image_source",
                                "value" => array("external_link")
                            ),
                        ),

                        array(
                            "type" => "textfield",
                            "class" => "",
                            "heading" => esc_html__("Extra class name", "keydesign"),
                            "param_name" => "ttc_extra_class",
                            "value" => "",
                            "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "keydesign"),
                            "group" => esc_html__( "Extras", "keydesign" ),
                        ),
                    )
                ));
            }
        }



        public function kd_testimonials_container($atts, $content = null) {
            global $global_image_layout;
            extract(shortcode_atts(array(
                'tt_image_layout' => '',
                'tt_nav_style' => '',
                'tt_navigation_color' => '',
                'tt_loop' => '',
                'tt_autoplay' => '',
                'tt_autoplay_speed' => '',
                'tt_stoponhover' => '',
                'css_animation' => '',
                'tt_animation_delay' => '',
                'tt_extra_class' => '',
              ), $atts));

            $output = $animation_delay = $wrapper_class = '';

            $global_image_layout = $tt_image_layout;

            // Animation delay
            if ($tt_animation_delay) {
                $animation_delay = 'data-animation-delay='.$tt_animation_delay;
            }

            $kd_ttunique_id = "kd-testimonial-".uniqid();

            $wrapper_class = implode(' ', array('slider', 'testimonials', $tt_navigation_color, $kd_ttunique_id, $tt_loop, $tt_extra_class, $tt_image_layout, $css_animation));

            $output .= '<div class="'.trim($wrapper_class).'" '.$animation_delay.'>'.do_shortcode($content).'</div>';

            $output .= '<script>
              jQuery(document).ready(function($){
                if ($(".slider.testimonials.'.$kd_ttunique_id.'").length) {
                  $(".slider.testimonials.'.$kd_ttunique_id.'").owlCarousel({
                    stageClass: "owl-wrapper",
                    stageOuterClass: "owl-wrapper-outer",
                    loadedClass: "owl-carousel",';
                    if (is_rtl()) {
                      $output .= 'rtl: true,';
                    }
                    $output .= 'responsive:{
                        0:{
                            dots: false,
                            nav: true,
                            navSpeed: 500,
                        },
                        1366:{';
                          if ( vc_is_inline() ) {
                            $output .= 'dots: false, nav: false,';
                          } else {
                            if ( $tt_nav_style == "nav-arrows" ) {
                              $output .= 'nav: true,
                              navSpeed: 500,
                              dots: false,';
                            } elseif ( $tt_nav_style == "nav-dots" ) {
                              $output .='dots: true,
                              nav: false,
                              dotsSpeed: 500,';
                            } elseif ( $tt_nav_style == "nav-arrows-dots" ) {
                              $output .= "\n".'nav: true,
                              navSpeed: 500,
                              dots: true,
                              dotsSpeed: 500,
                              dotsEach: true,';
                            }
                          }
                        $output .= '}
                    },
                    items: 1,';

                    if ( $tt_loop != "loop_off" && ! vc_is_inline() ) {
                      $output .= 'loop: true, rewind: true,';
                    } else {
                      $output .= 'loop: false, rewind: false, margin: 1,';
                    }

                    if($tt_autoplay == "auto_on") {
                      $output .= 'autoplay: true,';
                    } else {
                      $output .= 'autoplay: false,';
                    }

                    if($tt_autoplay_speed !== "") {
                      $output .= 'autoplayTimeout: '.$tt_autoplay_speed.',';
                    }

                    if($tt_autoplay == "auto_on" && $tt_stoponhover == "hover_on") {
                      $output .= 'autoplayHoverPause: true,';
                    } else {
                      $output .= 'autoplayHoverPause: false,';
                    }


                    $output .='
                  });
                }
              });
            </script>';

            return $output;
        }



        public function kd_testimonials_single($atts, $content = null) {

            extract(shortcode_atts(array(
                'tt_heading' => '',
                'tt_heading_tag' => 'h5',
                'tt_title' => '',
                'author_name_link' => '',
                'author_link_url' => '',
                'author_link_target' => '',
                'tt_quote' => '',
                'tt_quote_tag' => 'h6',
                'tt_position' => '',
                'tt_text_size' => '',
                'tt_text_color' => '',
                'tt_bg_color' => '',
                'image_source' => '',
                'tt_image' => '',
                'ext_image' => '',
                'ext_image_size' => '',
                'ttc_extra_class' => '',
            ), $atts));

            $content_image = $default_src = $dimensions = $hwstring = $tt_bg_style = $tt_text_style = '';
            $link_before = $link_after = '';

            $image  = wpb_getImageBySize($params = array(
                'post_id' => NULL,
                'attach_id' => $tt_image,
                'thumb_size' => 'full',
                'class' => ""
            ));

            if ($image_source == 'external_link') {
              if (!$ext_image) {
                $content_image ='<img src="'.$default_src.'" alt="" class="vc_img-placeholder" />';
              } else {
                $content_image ='<img src="'.$ext_image.'" alt="" '.$hwstring.' />';
              }
            } else {
              $image = wpb_getImageBySize ( $params = array( 'post_id' => NULL, 'attach_id' => $tt_image, 'thumb_size' => 'full', 'class' => "" ) );
      				$content_image = $image['thumbnail'];
            }


            if ( $tt_text_size !== '' ) {
              $tt_text_style .= 'font-size:'.$tt_text_size.';';
            }

            if ( $tt_text_color !== '' ) {
              $tt_text_style .= 'color:'.$tt_text_color.';';
            }

            if ($tt_bg_color !== '') {
              $tt_bg_style = 'background-color:'.$tt_bg_color.';';
            }

            // Author name link settings
            if ( !empty( $author_name_link ) && $author_link_url != '' ) {
                $link_before = '<a href="' . $author_link_url . '" target="' . $author_link_target . '">';
                $link_after = '</a>';
            }

            $output = '<div class="tt-content '.$ttc_extra_class.'">
              <div class="tt-content-inner">';
                if ( $GLOBALS['global_image_layout'] == 'without-image' && ( '' != $tt_image || '' != $ext_image ) ) {
                  $output .= '<div class="tt-image">'.$content_image.'</div>';
                }
                $output .= '<div class="tt-container" '.(!empty($tt_bg_style) ? 'style="'.$tt_bg_style.'"' : '').'>';
                    if ( $GLOBALS['global_image_layout'] == 'without-image' ) {
                      if ( $tt_quote ) {
                        if ( $tt_quote_tag != '' ) {
                          $output .= '<'.esc_attr( $tt_quote_tag ) . ' class="testimonial-quote" ' . ( !empty( $tt_text_style ) ? 'style="'.$tt_text_style.'"' : '') . '>' . $tt_quote . '</'.esc_attr( $tt_quote_tag ).'>';
                        } else {
                          $output .= '<h6 class="testimonial-quote" '.(!empty($tt_text_style) ? 'style="'.$tt_text_style.'"' : '').'>'.$tt_quote.'</h6>';
                        }
                      }
                    } elseif ( $GLOBALS['global_image_layout'] == 'with-image' ) {
                      if ( $tt_heading ) {
                        if ( $tt_heading_tag != '' ) {
                          $output .= '<'.esc_attr( $tt_heading_tag ) . ' class="testimonial-title" ' . ( !empty( $tt_text_style ) ? 'style="'.$tt_text_style.'"' : '') . '>' . $tt_heading . '</'.esc_attr( $tt_heading_tag ).'>';
                        } else {
                          $output .= '<h5 class="testimonial-title" '.( !empty( $tt_text_style ) ? 'style="'.$tt_text_style.'"' : '').'>' . $tt_heading . '</h5>';
                        }
                      }
                      if ( $tt_quote ) {
                        $output .= '<p '.(!empty($tt_text_style) ? 'style="'.$tt_text_style.'"' : '').'>'.$tt_quote.'</p>';
                      }
                    }
                    $output .= '<span class="author" '.(!empty($tt_text_color) ? 'style="color: ' . $tt_text_color . ';"' : '').'>';
                    if ( '' != $tt_title ) {
                        $output .= $link_before;
                        $output .= '<span class="author-name">'.$tt_title.'</span>';
                        $output .= $link_after;
                    }
                    $output .= '<span class="content" '.(!empty($tt_text_color) ? 'style="color: ' . $tt_text_color . ';"' : '').'>'.$tt_position.'</span>
                    </span>
                </div>';
                if ( $GLOBALS['global_image_layout'] == 'with-image' && ( '' != $tt_image || '' != $ext_image ) ) {
                  $output .= '<div class="tt-image">'.$content_image.'</div>';
                }

                $output .= '</div>
            </div>';

            return $output;
        }
    }
}

if (class_exists('tek_testimonials')) {
    $tek_testimonials = new tek_testimonials;
}

?>
