<div class="jet-abaf-setup">
	<div class="jet-container">
		<div class="jet-header">
			<div class="jet-header__heading">
				<svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 48 48" fill="none">
					<path d="M0 6C0 2.68629 2.68629 0 6 0H42C45.3137 0 48 2.68629 48 6V42C48 45.3137 45.3137 48 42 48H6C2.68629 48 0 45.3137 0 42V6Z" fill="#506EF8"></path>
					<path fill-rule="evenodd" clip-rule="evenodd" d="M41.5139 13.0012C42.0764 12.9665 42.3973 13.698 42.0236 14.1629L38.6968 18.3017C38.3072 18.7863 37.5812 18.4765 37.5888 17.8288L37.6086 16.1496C37.6112 15.9296 37.5197 15.721 37.3617 15.5867L36.1556 14.5617C35.6904 14.1664 35.9207 13.3462 36.5071 13.31L41.5139 13.0012ZM15.0432 23.8698C15.0432 27.8345 11.8023 31.0473 7.80863 31.0473C6.80792 31.0473 6 30.2406 6 29.2517C6 28.2628 6.80792 27.4608 7.80863 27.4608C9.80547 27.4608 11.4259 25.8521 11.4259 23.8698V18.4878C11.4259 17.4944 12.2338 16.6923 13.2345 16.6923C14.2352 16.6923 15.0432 17.4944 15.0432 18.4878V23.8698ZM34.5433 23.8698C34.5433 25.8521 36.1638 27.4608 38.1606 27.4608C39.1613 27.4608 39.9692 28.2583 39.9692 29.2517C39.9692 30.2452 39.1613 31.0473 38.1606 31.0473C34.1669 31.0473 30.9261 27.8345 30.9261 23.8698V18.4878C30.9261 17.4944 31.734 16.6923 32.7347 16.6923C33.7354 16.6923 34.5433 17.4989 34.5433 18.4878V20.0965H35.9801C36.9809 20.0965 37.7934 20.9031 37.7934 21.8965C37.7934 22.89 36.9809 23.6966 35.9801 23.6966H34.5433V23.8698ZM29.8887 21.3543C29.8933 21.3497 29.8979 21.3497 29.8979 21.3497C29.3286 19.8641 28.2637 18.5608 26.7764 17.704C23.3244 15.7171 18.9175 16.8929 16.9299 20.3289C14.9376 23.7604 16.122 28.1489 19.5694 30.1313C22.1079 31.5896 25.1651 31.3344 27.3961 29.7303L27.3823 29.712C27.8964 29.3976 28.2361 28.8325 28.2361 28.19C28.2361 27.2011 27.4282 26.399 26.4321 26.399C25.9501 26.399 25.5094 26.5859 25.1881 26.8957C24.1047 27.6203 22.6633 27.7343 21.4469 27.0689L28.7319 23.7103C29.1542 23.5827 29.5306 23.3002 29.7647 22.89C30.0493 22.4024 30.0769 21.8419 29.8887 21.3543ZM24.9723 20.8074C25.1881 20.9305 25.3809 21.0717 25.5599 21.2267L19.5648 23.9837C19.551 23.3503 19.7071 22.7077 20.0468 22.1199C21.0429 20.4064 23.2463 19.8185 24.9723 20.8074Z" fill="white"></path>
				</svg>
				<h3><?php _e( '<span>JetBooking</span> / Setup Wizard', 'jet-booking' ); ?></h3>
			</div>

			<div class="jet-header__logo">
				<svg xmlns="http://www.w3.org/2000/svg" width="173" height="24" viewBox="0 0 173 24" fill="none">
					<g opacity="0.4">
						<path d="M12.8554 5.95868C14.5004 5.95868 15.8339 4.62505 15.8339 2.98015C15.8339 1.33525 14.5004 0.00161132 12.8554 0.00161132C12.8526 0.00161132 12.8501 0.00200061 12.8474 0.00200061C6.27127 0.00628319 0.941406 5.33849 0.941406 11.9158C0.941406 18.4957 6.27556 23.8297 12.8554 23.8297C14.5004 23.8297 15.8339 22.4961 15.8339 20.8512C15.8339 19.2063 14.5004 17.8726 12.8554 17.8726C12.8544 17.8726 12.8536 17.8728 12.8526 17.8728C9.56399 17.8713 6.89828 15.2048 6.89828 11.9158C6.89828 8.62576 9.56536 5.95868 12.8554 5.95868Z" fill="white"></path>
						<path d="M71.5964 6.12878C71.5972 6.12878 71.5981 6.12897 71.5989 6.12897C73.244 6.12897 74.5774 4.79553 74.5774 3.15044C74.5774 1.50534 73.244 0.1719 71.5989 0.1719C65.0189 0.1719 59.685 5.50605 59.685 12.0858C59.685 18.6631 65.0148 23.9953 71.5909 23.9996C71.5937 23.9996 71.5962 24 71.5989 24C73.244 24 74.5774 22.6664 74.5774 21.0215C74.5774 19.3766 73.244 18.0429 71.5989 18.0429C68.3089 18.0429 65.6418 15.3758 65.6418 12.0858C65.6418 8.79663 68.3075 6.13014 71.5964 6.12878Z" fill="white"></path>
						<path d="M29.4439 0C22.8639 0 17.5298 5.33415 17.5298 11.9141V20.8497C17.5298 22.4946 18.8632 23.8283 20.5083 23.8283C22.1534 23.8283 23.4869 22.4948 23.4869 20.8497V11.9141C23.4869 8.62414 26.1539 5.95707 29.4439 5.95707C31.089 5.95707 32.4225 4.62363 32.4225 2.97854C32.4225 1.33344 31.089 0 29.4439 0Z" fill="white"></path>
						<path d="M46.0384 0.0033691C39.4584 0.0033691 34.1244 5.33752 34.1244 11.9173C34.1244 18.4541 39.3895 23.7588 45.9101 23.8281C47.5552 23.8281 48.8886 22.4947 48.8886 20.8496C48.8886 19.2045 47.5552 17.8711 45.9101 17.8711C42.6797 17.8026 40.0815 15.1643 40.0815 11.9173C40.0815 8.62732 42.7486 5.96025 46.0386 5.96025C49.3286 5.96025 51.9956 8.62732 51.9956 11.9173C51.9956 13.265 51.5454 14.5057 50.7905 15.5036C50.2935 16.0358 49.9869 16.7483 49.9869 17.5339C49.9869 19.1788 51.3204 20.5125 52.9655 20.5125C53.8984 20.5125 54.7299 20.0828 55.2761 19.4114C55.2785 19.4085 55.2829 19.4048 55.2831 19.4087C55.2834 19.4126 55.2887 19.4194 55.2912 19.4163C56.9536 17.3684 57.9527 14.7606 57.9527 11.9173C57.9525 5.33752 52.6184 0.0033691 46.0384 0.0033691Z" fill="white"></path>
						<path d="M88.1934 0.173438C81.6134 0.173438 76.2794 5.50759 76.2794 12.0874C76.2794 18.6242 81.5445 23.9289 88.0651 23.9982C89.7102 23.9982 91.0436 22.6648 91.0436 21.0197C91.0436 19.3746 89.71 18.0411 88.0651 18.0411C88.0645 18.0411 88.0637 18.0411 88.0631 18.0411C84.8337 17.9717 82.2365 15.3338 82.2365 12.0876C82.2365 8.79758 84.9036 6.13051 88.1936 6.13051C91.4836 6.13051 94.1506 8.79758 94.1506 12.0876C94.1506 13.4352 93.7004 14.676 92.9455 15.6739C92.4485 16.2061 92.1419 16.9185 92.1419 17.7042C92.1419 19.3491 93.4753 20.6827 95.1204 20.6827C96.0534 20.6827 96.8849 20.2531 97.4311 19.5817C97.4335 19.5787 97.4379 19.5751 97.4381 19.5789C97.4384 19.5829 97.4437 19.5896 97.4462 19.5866C99.1086 17.5387 100.108 14.9308 100.108 12.0876C100.108 5.50759 94.7734 0.173438 88.1934 0.173438Z" fill="white"></path>
					</g>
					<path fill-rule="evenodd" clip-rule="evenodd" d="M113.018 6.94031C110.234 6.94031 107.762 8.27745 106.21 10.3442V0.849314H106.21C106.209 0.379982 105.828 0 105.359 0C104.889 0 104.509 0.380177 104.508 0.849314H104.508V15.4504C104.508 20.1503 108.318 23.9605 113.018 23.9605C117.718 23.9605 121.528 20.1503 121.528 15.4504C121.528 10.7504 117.718 6.94031 113.018 6.94031ZM113.018 22.2583C109.258 22.2583 106.21 19.2103 106.21 15.4504C106.21 11.6905 109.258 8.64244 113.018 8.64244C116.778 8.64244 119.826 11.6905 119.826 15.4504C119.826 19.2103 116.778 22.2583 113.018 22.2583ZM125.862 0.983377C125.861 0.514045 125.48 0.134063 125.011 0.134063C124.541 0.134063 124.161 0.51424 124.16 0.983377H124.16V23.1093C124.16 23.5792 124.541 23.9604 125.011 23.9604C125.481 23.9604 125.862 23.5794 125.862 23.1093L125.862 0.983377ZM128.222 15.4504C128.222 10.7505 132.033 6.94034 136.733 6.94034C141.432 6.94034 145.242 10.7505 145.243 15.4504C145.243 20.1504 141.432 23.9605 136.733 23.9605C132.033 23.9605 128.222 20.1504 128.222 15.4504ZM129.925 15.4504C129.925 19.2103 132.973 22.2584 136.733 22.2584C140.492 22.2584 143.54 19.2103 143.54 15.4504C143.54 11.6905 140.492 8.64248 136.733 8.64248C132.973 8.64248 129.925 11.6905 129.925 15.4504ZM156.136 22.2584C152.376 22.2584 149.328 19.2103 149.328 15.4504C149.328 11.6905 152.376 8.64248 156.136 8.64248C156.605 8.64248 156.987 8.26152 156.987 7.79141C156.987 7.3213 156.606 6.94034 156.136 6.94034C151.436 6.94034 147.626 10.7505 147.626 15.4504C147.626 20.1504 151.436 23.9605 156.136 23.9605C156.605 23.9605 156.987 23.5795 156.987 23.1094C156.987 22.6393 156.605 22.2584 156.136 22.2584ZM167.263 13.8991L172.866 22.6519C173.118 23.0476 173.003 23.5728 172.607 23.8261C172.212 24.0793 171.686 23.9643 171.433 23.5695H171.433L166.031 15.1313L162.512 18.6504V23.1093C162.512 23.5794 162.131 23.9604 161.661 23.9604C161.191 23.9604 160.81 23.5792 160.81 23.1093V0.983377H160.81C160.811 0.51424 161.191 0.134063 161.661 0.134063C162.13 0.134063 162.511 0.514045 162.512 0.983377H162.512V16.2432L171.548 7.20713L171.548 7.20733C171.88 6.87601 172.418 6.8764 172.75 7.2083C173.082 7.5402 173.082 8.07806 172.751 8.41054L172.751 8.41073L167.263 13.8991Z" fill="white"></path>
				</svg>
			</div>
		</div>

		<div class="jet-content">
			<template v-if="! isSet || isReset">
				<template v-if="! currentStep">
					<div class="jet-content__title">
						<h1><?php _e( 'Welcome to JetBooking Setup Wizard', 'jet-booking' ); ?></h1>
					</div>

					<div class="jet-content__heading">
						<h2><?php _e( 'Choose Booking Mode', 'jet-booking' ); ?></h2>
					</div>

					<div class="jet-content__body">
						<div
							:class="[ 'jet-radio-item',  { 'active': 'plain' === setupData.booking_mode } ]"
							@click="setupData.booking_mode = 'plain'"
						>
							<cx-vui-radio
								:options-list="[ {
									value: 'plain',
									label: '<?php _e( 'Plain mode', 'jet-booking' ); ?>',
								} ]"
								v-model="setupData.booking_mode"
							/>

							<div class="cx-vui-component__desc">
								<?php _e( 'A flexible booking setup. It uses separate CPTs for bookings and orders (both JetEngine-built and not), a customizable booking form, and doesn\'t require additional plugins.', 'jet-booking' ); ?>
							</div>
						</div>

						<div>
							<div
								:class="[ 'jet-radio-item',  { 'active': 'wc_based' === setupData.booking_mode, 'disabled': ! hasWoocommerce } ]"
								@click="setupData.booking_mode = 'wc_based'"
							>
								<cx-vui-radio
									:options-list="[ {
											value: 'wc_based',
											label: '<?php _e( 'WooCommerce-based mode', 'jet-booking' ); ?>',
										} ]"
									v-model="setupData.booking_mode"
								/>

								<div class="cx-vui-component__desc">
									<?php _e( 'Creates a deep WooCommerce integration and configures everything from Products CPT to checkout and payments. Easy setup compared to Plain mode.', 'jet-booking' ); ?>
								</div>
							</div>

							<div v-if="! hasWoocommerce" class="jet-setup-notice jet-setup-notice-warning">
								<?php printf(
									__( 'WooCommerce plugin isn\'t installed. To activate the mode, you need to <a href="%s" target="_blank">install the plugin</a> and refresh the page.', 'jet-booking' ),
									add_query_arg( [ 's' => 'woocommerce', 'tab' => 'search', 'type' => 'term' ], esc_url( admin_url( 'plugin-install.php' ) ) )
								); ?>
							</div>
						</div>
					</div>

					<div class="jet-content__actions">
						<cx-vui-button button-style="accent" :loading="loading" @click="nextStep">
							<template slot="label">
								<?php _e( 'Start setup', 'jet-booking' ); ?>
							</template>
						</cx-vui-button>
					</div>
				</template>

				<template v-if="1 === currentStep">
					<div class="jet-content__heading">
						<h2><?php _e( 'Set Up Booking Instance ', 'jet-booking' ); ?></h2>
						<p class="jet-content__heading-desc">
							<?php _e( 'Select a Custom Post Type (CPT) for the booking instance. For instance, the "Apartments" Post Type is for apartment bookings and the "Cars" CPT is for car bookings.', 'jet-booking' ); ?>
						</p>
					</div>

					<div class="jet-content__body">
						<div class="cx-vui-component cx-vui-component--equalwidth">
							<div class="cx-vui-component__meta">
								<label class="cx-vui-component__label">
									<?php _e( 'Booking Post Type', 'jet-booking' ); ?>
								</label>
							</div>

							<div class="cx-vui-component__control jet-advanced-select">
								<?php if ( class_exists( 'Jet_Engine' ) ) : ?>
									<cx-vui-button
										tag-name="a"
										button-style="link-accent"
										url="<?php  echo add_query_arg( [ 'page' => 'jet-engine-cpt', 'cpt_action' => 'add' ], esc_url( admin_url( 'admin.php' ) ) ); ?>"
										target="_blank"
									>
										<template slot="label">
											<?php _e( 'Create new post type', 'jet-booking' ); ?>

											<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
												<path d="M3.2513 9.99967C3.2513 8.57467 4.40964 7.41634 5.83464 7.41634H9.16797V5.83301H5.83464C3.53464 5.83301 1.66797 7.69967 1.66797 9.99967C1.66797 12.2997 3.53464 14.1663 5.83464 14.1663H9.16797V12.583H5.83464C4.40964 12.583 3.2513 11.4247 3.2513 9.99967ZM6.66797 10.833H13.3346V9.16634H6.66797V10.833ZM14.168 5.83301H10.8346V7.41634H14.168C15.593 7.41634 16.7513 8.57467 16.7513 9.99967C16.7513 11.4247 15.593 12.583 14.168 12.583H10.8346V14.1663H14.168C16.468 14.1663 18.3346 12.2997 18.3346 9.99967C18.3346 7.69967 16.468 5.83301 14.168 5.83301Z" fill="#0D88BF"></path>
											</svg>
										</template>
									</cx-vui-button>
								<?php endif; ?>

								<cx-vui-select
									class="inner-component"
									label="<?php _e( 'OR', 'jet-booking' ); ?>"
									placeholder="<?php _e( 'Select post type', 'jet-booking' ); ?>"
									:options-list="postTypes"
									size="fullwidth"
									v-model="setupData.apartment_post_type"
								></cx-vui-select>
							</div>
						</div>
					</div>
				</template>

				<template v-if="2 === currentStep">
					<div class="jet-content__heading">
						<h2><?php _e( 'Set Up Orders', 'jet-booking' ); ?></h2>

						<p class="jet-content__heading-desc">
							<?php _e( 'Choose a Custom Post Type (CPT) for storing booking orders. Orders will be available in the WordPress dashboard and the default WooCommerce Orders CPT. <i>If you enable WooCommerce basic integration, it will be impossible to select the CPT</i>.', 'jet-booking' ); ?>
						</p>
					</div>

					<div class="jet-content__body">
						<div :class="[ 'cx-vui-component', 'cx-vui-component--equalwidth', {'disabled': setupData.wc_integration } ]">
							<div class="cx-vui-component__meta">
								<label class="cx-vui-component__label">
									<?php _e( 'Order Post Type', 'jet-booking' ); ?>
								</label>

								<p class="cx-vui-component__desc">
									<?php _e( 'Select a Custom Post Type where booking orders will be stored.', 'jet-booking' ); ?>
								</p>
							</div>

							<div class="cx-vui-component__control">
								<?php
								$label = '';

								if ( class_exists( 'Jet_Engine' ) ) :
								$label = __( 'OR', 'jet-booking' );
								?>
									<cx-vui-button
										button-style="link-accent"
										tag-name="a"
										target="_blank"
										url="<?php  echo add_query_arg( [ 'page' => 'jet-engine-cpt', 'cpt_action' => 'add' ], esc_url( admin_url( 'admin.php' ) ) ); ?>"
									>
										<template slot="label">
											<?php _e( 'Create new post type', 'jet-booking' ); ?>
											<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
												<path d="M3.2513 9.99967C3.2513 8.57467 4.40964 7.41634 5.83464 7.41634H9.16797V5.83301H5.83464C3.53464 5.83301 1.66797 7.69967 1.66797 9.99967C1.66797 12.2997 3.53464 14.1663 5.83464 14.1663H9.16797V12.583H5.83464C4.40964 12.583 3.2513 11.4247 3.2513 9.99967ZM6.66797 10.833H13.3346V9.16634H6.66797V10.833ZM14.168 5.83301H10.8346V7.41634H14.168C15.593 7.41634 16.7513 8.57467 16.7513 9.99967C16.7513 11.4247 15.593 12.583 14.168 12.583H10.8346V14.1663H14.168C16.468 14.1663 18.3346 12.2997 18.3346 9.99967C18.3346 7.69967 16.468 5.83301 14.168 5.83301Z" fill="#0D88BF"></path>
											</svg>
										</template>
									</cx-vui-button>
								<?php endif; ?>

								<cx-vui-select
									class="inner-component"
									label="<?php echo $label; ?>"
									placeholder="<?php _e( 'Select post type', 'jet-booking' ); ?>"
									:options-list="postTypes"
									size="fullwidth"
									v-model="setupData.related_post_type"
								></cx-vui-select>
							</div>
						</div>

						<hr>

						<cx-vui-switcher
							:class="[ {'disabled': ! hasWoocommerce } ]"
							label="<?php _e( 'WooCommerce basic integration', 'jet-booking' ); ?>"
							description="<?php _e( 'Enable the toggle if you want to integrate booking orders with WooCommerce.', 'jet-booking' ); ?>"
							:wrapper-css="[ 'equalwidth' ]"
							v-model="setupData.wc_integration"
						></cx-vui-switcher>

						<div v-if="! hasWoocommerce" class="jet-setup-notice jet-setup-notice-warning">
							<?php printf(
								__( 'WooCommerce plugin isn\'t installed. To enable the integration, you need to <a href="%s" target="_blank">install the plugin</a> and refresh the page.', 'jet-booking' ),
								add_query_arg( [ 's' => 'woocommerce', 'tab' => 'search', 'type' => 'term' ], esc_url( admin_url( 'plugin-install.php' ) ) )
							); ?>
						</div>

						<hr>

						<cx-vui-switcher
							:class="[ {'disabled': ! setupData.wc_integration } ]"
							label="<?php _e( 'Two-way WooCommerce orders sync', 'jet-appointments-booking' ); ?>"
							description="<?php _e( 'Enable this toggle to update WooCommerce order status on the booking status change (by default, the booking status change doesn\'t affect the related order).', 'jet-booking' ); ?>"
							:wrapper-css="[ 'equalwidth' ]"
							v-model="setupData.wc_sync_orders"
						></cx-vui-switcher>
					</div>
				</template>

				<template v-if="3 === currentStep">
					<div class="jet-content__heading">
						<h2><?php _e( 'Set Up Database Tables', 'jet-booking' ); ?></h2>
						<p class="jet-content__heading-desc">
							<?php _e( 'Generate default and add custom database columns for storing booking details. All columns will appear in the plugin Settings Tools tab, and their data will be stored in the associated database.', 'jet-booking' ); ?>
						</p>
					</div>

					<div class="jet-content__body">
						<div class="cx-vui-component cx-vui-component--equalwidth">
							<div class="cx-vui-component__meta">
								<label class="cx-vui-component__label">
									<?php _e( 'Default database columns', 'jet-booking' ); ?>
								</label>

								<div class="cx-vui-component__desc">
									<?php _e( 'These are default database columns created for you automatically.', 'jet-booking' ); ?>
								</div>
							</div>
							<div class="cx-vui-component__control">
								<ul class="jet-abaf-setup__db-columns">
									<li v-for="field in dbFields">{{ field }}</li>
								</ul>
							</div>
						</div>

						<div class="cx-vui-component cx-vui-component--equalwidth">
							<div class="cx-vui-component__meta">
								<label class="cx-vui-component__label">
									<?php _e( 'Custom database columns', 'jet-booking' ); ?>
								</label>
								<div class="cx-vui-component__desc">
									<?php _e( 'Add more database columns if needed. Spaces will be converted to "_" .', 'jet-booking' ); ?>
								</div>
							</div>
							<div class="cx-vui-component__control">
								<ul v-if="additionalDBColumns.length" class="jet-abaf-setup__custom_db-columns">
									<li
										class="jet-abaf-setup__custom_db-column"
										v-for="( column, columnIndex ) in additionalDBColumns"
										:key="'column' + columnIndex"
									>
										<cx-vui-input
											size="fullwidth"
											:value="additionalDBColumns[ columnIndex ].column"
											@input="setColumnProp( columnIndex, 'column', $event )"
											placeholder="<?php _e( 'Enter column name', 'jet-booking' ) ?>"
										></cx-vui-input>

										<div class="jet-abaf-setup__custom_db-column-actions">
											<div class="jet-abaf-setup__custom_db-column-actions-info">
												<cx-vui-button class="copy" button-style="link-accent" @click="cloneColumn( columnIndex )">
													<template slot="label">
														<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
															<path d="M13.3346 0.833496H3.33464C2.41797 0.833496 1.66797 1.5835 1.66797 2.50016V14.1668H3.33464V2.50016H13.3346V0.833496ZM12.5013 4.16683L17.5013 9.16683V17.5002C17.5013 18.4168 16.7513 19.1668 15.8346 19.1668H6.65964C5.74297 19.1668 5.0013 18.4168 5.0013 17.5002L5.00964 5.8335C5.00964 4.91683 5.7513 4.16683 6.66797 4.16683H12.5013ZM11.668 10.0002H16.2513L11.668 5.41683V10.0002Z" fill="#0E6A95"></path>
														</svg>
													</template>
												</cx-vui-button>

												<div class="cx-vui-tooltip"><?php _e( 'Copy column', 'jet-booking' ); ?></div>
											</div>

											<div class="jet-abaf-setup__custom_db-column-actions-info">
												<cx-vui-button class="delete" button-style="link-accent" @click="deleteColumn( columnIndex )">
													<template slot="label">
														<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
															<path d="M5.0013 15.8333C5.0013 16.75 5.7513 17.5 6.66797 17.5H13.3346C14.2513 17.5 15.0013 16.75 15.0013 15.8333V5.83333H5.0013V15.8333ZM15.8346 3.33333H12.918L12.0846 2.5H7.91797L7.08464 3.33333H4.16797V5H15.8346V3.33333Z" fill="white"></path>
														</svg>
													</template>
												</cx-vui-button>

												<div class="cx-vui-tooltip"><?php _e( 'Delete column', 'jet-booking' ); ?></div>
											</div>
										</div>
									</li>
								</ul>

								<cx-vui-button button-style="link-accent" @click="addNewColumn">
									<template slot="label">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
											<path d="M15.8346 10.8332H10.8346V15.8332H9.16797V10.8332H4.16797V9.1665H9.16797V4.1665H10.8346V9.1665H15.8346V10.8332Z" fill="#0D88BF"></path>
										</svg>
										<?php _e( 'Add new column', 'jet-booking' ); ?>
									</template>
								</cx-vui-button>
							</div>
						</div>
					</div>
				</template>

				<template v-if="4 === currentStep">
					<div class="jet-content__heading">
						<h2><?php _e( 'Booking Form Settings', 'jet-booking' ); ?></h2>

						<p class="jet-content__heading-desc">
							<?php _e( 'Generate a standard booking form and add it to the booking instance single page. The form will appear in the <b>JetFormBuilder > Forms tab</b>.', 'jet-booking' ); ?>
						</p>
					</div>

					<div class="jet-content__body">
						<cx-vui-switcher
							label="<?php _e( 'Create Booking Form', 'jet-booking' ); ?>"
							description="<?php _e( 'Enable to generate a single page booking form.', 'jet-booking' ); ?>"
							:wrapper-css="[ 'equalwidth' ]"
							v-model="setupData.create_single_form"
						></cx-vui-switcher>

						<div v-if="setupData.create_single_form" class="jet-setup-notice">
							<?php _e( 'For form creation purposes, a free JetFormBuilder plugin will be installed and activated.', 'jet-booking' ); ?>
						</div>
					</div>
				</template>

				<template v-if="4 < currentStep">
					<div class="jet-content__title">
						<h1><?php _e( 'Finish Setup', 'jet-booking' ); ?></h1>
					</div>

					<div class="jet-content__heading">
						<h2><?php _e( 'Congrats, you finished the setup', 'jet-booking' ); ?></h2>

						<p class="jet-content__heading-desc">
							<?php _e( 'These are all settings you configured during the setup. You can adjust them in the Booking Settings if needed. Please remember you can disable Setup Wizard in the <b>Booking Settings</b> > <b>Advanced tab</b>.', 'jet-booking' ); ?>
						</p>
					</div>

					<div class="jet-content__body wide">
						<div class="main">
							<template v-if="'plain' === setupData.booking_mode">
								<div class="cx-vui-component cx-vui-component--equalwidth">
									<div class="cx-vui-component__meta">
										<label class="cx-vui-component__label">
											<?php _e( 'Custom post type settings', 'jet-booking' ); ?>
										</label>

										<div class="cx-vui-component__desc">
											<?php _e( 'Selected custom post types.', 'jet-booking' ); ?>
										</div>
									</div>

									<div class="cx-vui-component__control actions-list">
										<cx-vui-button
											button-style="link-accent"
											tag-name="a"
											target="_blank"
											:url="log.instances_page"
										>
											<template slot="label">
												<?php _e( 'Manage bookings', 'jet-booking' ); ?>
												<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
													<path d="M3.2513 9.99967C3.2513 8.57467 4.40964 7.41634 5.83464 7.41634H9.16797V5.83301H5.83464C3.53464 5.83301 1.66797 7.69967 1.66797 9.99967C1.66797 12.2997 3.53464 14.1663 5.83464 14.1663H9.16797V12.583H5.83464C4.40964 12.583 3.2513 11.4247 3.2513 9.99967ZM6.66797 10.833H13.3346V9.16634H6.66797V10.833ZM14.168 5.83301H10.8346V7.41634H14.168C15.593 7.41634 16.7513 8.57467 16.7513 9.99967C16.7513 11.4247 15.593 12.583 14.168 12.583H10.8346V14.1663H14.168C16.468 14.1663 18.3346 12.2997 18.3346 9.99967C18.3346 7.69967 16.468 5.83301 14.168 5.83301Z" fill="#0D88BF"></path>
												</svg>
											</template>
										</cx-vui-button>

										<cx-vui-button
											v-if="! log.wc_integration.enabled && log.orders_page"
											button-style="link-accent"
											tag-name="a"
											target="_blank"
											:url="log.orders_page"
										>
											<template slot="label">
												<?php _e( 'Manage orders', 'jet-booking' ); ?>
												<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
													<path d="M3.2513 9.99967C3.2513 8.57467 4.40964 7.41634 5.83464 7.41634H9.16797V5.83301H5.83464C3.53464 5.83301 1.66797 7.69967 1.66797 9.99967C1.66797 12.2997 3.53464 14.1663 5.83464 14.1663H9.16797V12.583H5.83464C4.40964 12.583 3.2513 11.4247 3.2513 9.99967ZM6.66797 10.833H13.3346V9.16634H6.66797V10.833ZM14.168 5.83301H10.8346V7.41634H14.168C15.593 7.41634 16.7513 8.57467 16.7513 9.99967C16.7513 11.4247 15.593 12.583 14.168 12.583H10.8346V14.1663H14.168C16.468 14.1663 18.3346 12.2997 18.3346 9.99967C18.3346 7.69967 16.468 5.83301 14.168 5.83301Z" fill="#0D88BF"></path>
												</svg>
											</template>
										</cx-vui-button>
									</div>
								</div>

								<template v-if="log.wc_integration.enabled">
									<hr>

									<div class="cx-vui-component cx-vui-component--equalwidth">
										<div class="cx-vui-component__meta">
											<label class="cx-vui-component__label">
												<?php _e( 'WooCommerce integration', 'jet-booking' ); ?>
											</label>

											<div class="cx-vui-component__desc">
												<?php _e( 'Proceed to manage related product and booking orders.', 'jet-booking' ); ?>
											</div>
										</div>

										<div class="cx-vui-component__control actions-list">
											<cx-vui-button
												button-style="link-accent"
												tag-name="a"
												target="_blank"
												:url="log.wc_integration.product_link"
											>
												<template slot="label">
													<?php _e( 'Related product', 'jet-booking' ); ?>
													<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
														<path d="M3.2513 9.99967C3.2513 8.57467 4.40964 7.41634 5.83464 7.41634H9.16797V5.83301H5.83464C3.53464 5.83301 1.66797 7.69967 1.66797 9.99967C1.66797 12.2997 3.53464 14.1663 5.83464 14.1663H9.16797V12.583H5.83464C4.40964 12.583 3.2513 11.4247 3.2513 9.99967ZM6.66797 10.833H13.3346V9.16634H6.66797V10.833ZM14.168 5.83301H10.8346V7.41634H14.168C15.593 7.41634 16.7513 8.57467 16.7513 9.99967C16.7513 11.4247 15.593 12.583 14.168 12.583H10.8346V14.1663H14.168C16.468 14.1663 18.3346 12.2997 18.3346 9.99967C18.3346 7.69967 16.468 5.83301 14.168 5.83301Z" fill="#0D88BF"></path>
													</svg>
												</template>
											</cx-vui-button>

											<cx-vui-button
												button-style="link-accent"
												tag-name="a"
												target="_blank"
												:url="log.wc_integration.orders_page"
											>
												<template slot="label">
													<?php _e( 'Manage orders', 'jet-booking' ); ?>
													<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
														<path d="M3.2513 9.99967C3.2513 8.57467 4.40964 7.41634 5.83464 7.41634H9.16797V5.83301H5.83464C3.53464 5.83301 1.66797 7.69967 1.66797 9.99967C1.66797 12.2997 3.53464 14.1663 5.83464 14.1663H9.16797V12.583H5.83464C4.40964 12.583 3.2513 11.4247 3.2513 9.99967ZM6.66797 10.833H13.3346V9.16634H6.66797V10.833ZM14.168 5.83301H10.8346V7.41634H14.168C15.593 7.41634 16.7513 8.57467 16.7513 9.99967C16.7513 11.4247 15.593 12.583 14.168 12.583H10.8346V14.1663H14.168C16.468 14.1663 18.3346 12.2997 18.3346 9.99967C18.3346 7.69967 16.468 5.83301 14.168 5.83301Z" fill="#0D88BF"></path>
													</svg>
												</template>
											</cx-vui-button>
										</div>
									</div>
								</template>

								<template v-if="log.form.hasOwnProperty( 'link' )">
									<hr>

									<div class="cx-vui-component cx-vui-component--equalwidth">
										<div class="cx-vui-component__meta">
											<label class="cx-vui-component__label">
												<?php _e( 'Form settings', 'jet-booking' ); ?>
											</label>

											<div class="cx-vui-component__desc">
												<?php _e( 'Proceed to customize the form.', 'jet-booking' ); ?>
											</div>
										</div>

										<div class="cx-vui-component__control actions-list">
											<cx-vui-button
												button-style="link-accent"
												tag-name="a"
												target="_blank"
												:url="log.form.link"
											>
												<template slot="label">
													<?php _e( 'Link to created form', 'jet-booking' ); ?>
													<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
														<path d="M3.2513 9.99967C3.2513 8.57467 4.40964 7.41634 5.83464 7.41634H9.16797V5.83301H5.83464C3.53464 5.83301 1.66797 7.69967 1.66797 9.99967C1.66797 12.2997 3.53464 14.1663 5.83464 14.1663H9.16797V12.583H5.83464C4.40964 12.583 3.2513 11.4247 3.2513 9.99967ZM6.66797 10.833H13.3346V9.16634H6.66797V10.833ZM14.168 5.83301H10.8346V7.41634H14.168C15.593 7.41634 16.7513 8.57467 16.7513 9.99967C16.7513 11.4247 15.593 12.583 14.168 12.583H10.8346V14.1663H14.168C16.468 14.1663 18.3346 12.2997 18.3346 9.99967C18.3346 7.69967 16.468 5.83301 14.168 5.83301Z" fill="#0D88BF"></path>
													</svg>
												</template>
											</cx-vui-button>
										</div>
									</div>
								</template>
							</template>

							<template v-else>
								<div class="cx-vui-component cx-vui-component--equalwidth">
									<div class="cx-vui-component__meta">
										<label class="cx-vui-component__label">
											<?php _e( 'WooCommerce mode settings', 'jet-booking' ); ?>
										</label>

										<div class="cx-vui-component__desc">
											<?php _e( 'Set additional WooCommerce mode settings.', 'jet-booking' ); ?>
										</div>
									</div>

									<div class="cx-vui-component__control actions-list">
										<cx-vui-button
											button-style="link-accent"
											tag-name="a"
											target="_blank"
											:url="log.product_link"
										>
											<template slot="label">
												<?php esc_html_e( 'Create first booking product', 'jet-booking' ); ?>
												<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
													<path d="M3.2513 9.99967C3.2513 8.57467 4.40964 7.41634 5.83464 7.41634H9.16797V5.83301H5.83464C3.53464 5.83301 1.66797 7.69967 1.66797 9.99967C1.66797 12.2997 3.53464 14.1663 5.83464 14.1663H9.16797V12.583H5.83464C4.40964 12.583 3.2513 11.4247 3.2513 9.99967ZM6.66797 10.833H13.3346V9.16634H6.66797V10.833ZM14.168 5.83301H10.8346V7.41634H14.168C15.593 7.41634 16.7513 8.57467 16.7513 9.99967C16.7513 11.4247 15.593 12.583 14.168 12.583H10.8346V14.1663H14.168C16.468 14.1663 18.3346 12.2997 18.3346 9.99967C18.3346 7.69967 16.468 5.83301 14.168 5.83301Z" fill="#0D88BF"></path>
												</svg>
											</template>
										</cx-vui-button>

										<cx-vui-button
											button-style="link-accent"
											tag-name="a"
											target="_blank"
											:url="log.bookings_page"
										>
											<template slot="label">
												<?php _e( 'Manage all bookings', 'jet-booking' ); ?>
												<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
													<path d="M3.2513 9.99967C3.2513 8.57467 4.40964 7.41634 5.83464 7.41634H9.16797V5.83301H5.83464C3.53464 5.83301 1.66797 7.69967 1.66797 9.99967C1.66797 12.2997 3.53464 14.1663 5.83464 14.1663H9.16797V12.583H5.83464C4.40964 12.583 3.2513 11.4247 3.2513 9.99967ZM6.66797 10.833H13.3346V9.16634H6.66797V10.833ZM14.168 5.83301H10.8346V7.41634H14.168C15.593 7.41634 16.7513 8.57467 16.7513 9.99967C16.7513 11.4247 15.593 12.583 14.168 12.583H10.8346V14.1663H14.168C16.468 14.1663 18.3346 12.2997 18.3346 9.99967C18.3346 7.69967 16.468 5.83301 14.168 5.83301Z" fill="#0D88BF"></path>
												</svg>
											</template>
										</cx-vui-button>
									</div>
								</div>
							</template>
						</div>

						<div class="sidebar">
							<h3><?php _e( 'What\'s Next', 'jet-booking' ); ?></h3>
							
							<ul>
								<li>
									<cx-vui-button
										button-style="link-accent"
										tag-name="a"
										target="_blank"
										url="https://crocoblock.com/knowledge-base/plugins/jetbooking/"
									>
										<template slot="label">
											<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
												<path d="M15.8333 2.5H4.16667C3.25 2.5 2.5 3.25 2.5 4.16667V15.8333C2.5 16.75 3.25 17.5 4.16667 17.5H15.8333C16.75 17.5 17.5 16.75 17.5 15.8333V4.16667C17.5 3.25 16.75 2.5 15.8333 2.5ZM11.6667 14.1667H5.83333V12.5H11.6667V14.1667ZM14.1667 10.8333H5.83333V9.16667H14.1667V10.8333ZM14.1667 7.5H5.83333V5.83333H14.1667V7.5Z" fill="#0D88BF"></path>
											</svg>
											<?php _e( 'Tutorial category', 'jet-booking' ); ?>
										</template>
									</cx-vui-button>
								</li>

								<li>
									<cx-vui-button
										button-style="link-accent"
										tag-name="a"
										target="_blank"
										url="https://support.crocoblock.com/support/home"
									>
										<template slot="label">
											<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
												<path d="M10 2.5C5.86 2.5 2.5 5.86 2.5 10C2.5 14.14 5.86 17.5 10 17.5C14.14 17.5 17.5 14.14 17.5 10C17.5 5.86 14.14 2.5 10 2.5ZM15.595 7.84L13.51 8.7025C13.1275 7.6825 12.325 6.8725 11.2975 6.4975L12.16 4.4125C13.735 5.0125 14.9875 6.265 15.595 7.84ZM10 12.25C8.755 12.25 7.75 11.245 7.75 10C7.75 8.755 8.755 7.75 10 7.75C11.245 7.75 12.25 8.755 12.25 10C12.25 11.245 11.245 12.25 10 12.25ZM7.8475 4.405L8.725 6.49C7.69 6.865 6.8725 7.6825 6.49 8.7175L4.405 7.8475C5.0125 6.265 6.265 5.0125 7.8475 4.405ZM4.405 12.1525L6.49 11.29C6.8725 12.325 7.6825 13.135 8.7175 13.51L7.84 15.595C6.265 14.9875 5.0125 13.735 4.405 12.1525ZM12.16 15.595L11.2975 13.51C12.325 13.1275 13.135 12.3175 13.51 11.2825L15.595 12.16C14.9875 13.735 13.735 14.9875 12.16 15.595Z" fill="#0D88BF"></path>
											</svg>
											<?php _e( 'Support link', 'jet-booking' ); ?>
										</template>
									</cx-vui-button>
								</li>

								<li>
									<cx-vui-button
										button-style="link-accent"
										tag-name="a"
										target="_blank"
										url="https://youtube.com/playlist?list=PL26jaHWVtLFxGvB9YyfJ6VbYXIRd9dFM4&si=zydILD_1UPwbD39y"
									>
										<template slot="label">
											<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
												<path d="M18.3848 5.7832C18.2851 5.41218 18.0898 5.07384 17.8184 4.80202C17.5469 4.53021 17.2088 4.33446 16.8379 4.23438C15.4727 3.86719 10 3.86719 10 3.86719C10 3.86719 4.52734 3.86719 3.16211 4.23242C2.79106 4.33219 2.45278 4.52782 2.18126 4.79969C1.90974 5.07155 1.71453 5.41007 1.61523 5.78125C1.25 7.14844 1.25 10 1.25 10C1.25 10 1.25 12.8516 1.61523 14.2168C1.81641 14.9707 2.41016 15.5645 3.16211 15.7656C4.52734 16.1328 10 16.1328 10 16.1328C10 16.1328 15.4727 16.1328 16.8379 15.7656C17.5918 15.5645 18.1836 14.9707 18.3848 14.2168C18.75 12.8516 18.75 10 18.75 10C18.75 10 18.75 7.14844 18.3848 5.7832ZM8.26172 12.6172V7.38281L12.793 9.98047L8.26172 12.6172Z" fill="#0D88BF"></path>
											</svg>
											<?php _e( 'YouTube playlist', 'jet-booking' ); ?>
										</template>
									</cx-vui-button>
								</li>
							</ul>
						</div>
					</div>

					<div class="jet-content__actions">
						<cx-vui-button
							button-style="accent"
							tag-name="a"
							target="_blank"
							:url="log.settings_url"
						>
							<template slot="label">
								<?php _e( 'Go to Booking Settings', 'jet-booking' ); ?>
							</template>
						</cx-vui-button>
					</div>
				</template>

				<div v-if="currentStep && currentStep <= lastStep" class="jet-content__actions">
					<cx-vui-button v-if="currentStep" button-style="accent-border" @click="prevStep">
						<template slot="label">
							<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
								<path d="M12.843 6.175L11.668 5L6.66797 10L11.668 15L12.843 13.825L9.0263 10L12.843 6.175Z" fill="#0D88BF"></path>
							</svg>
							<?php _e( 'Back', 'jet-booking' ); ?>
						</template>
					</cx-vui-button>

					<cx-vui-button
						button-style="accent"
						:disabled="1 === currentStep && ! setupData.apartment_post_type"
						:loading="loading"
						@click="nextStep"
					>
						<template slot="label">
							<template v-if="currentStep === lastStep">
								<?php _e( 'Finish setup', 'jet-booking' ); ?>
							</template>

							<template v-else>
								<?php _e( 'Next step', 'jet-booking' ); ?>
							</template>

							<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
								<path d="M8.33516 5L7.16016 6.175L10.9768 10L7.16016 13.825L8.33516 15L13.3352 10L8.33516 5Z" fill="white"></path>
							</svg>
						</template>
					</cx-vui-button>
				</div>
			</template>

			<template v-else>
				<div class="jet-content__heading">
					<h2><?php _e( 'The booking system is already configured', 'jet-booking' ); ?></h2>
				</div>

				<div class="jet-content__body">
					<div class="cx-vui-component cx-vui-component--equalwidth">
						<div class="cx-vui-component__meta">
							<label class="cx-vui-component__label">
								<?php _e( 'Reset all the current settings', 'jet-booking' ); ?>
							</label>

							<p class="cx-vui-component__desc">
								<?php _e( 'If you choose to reset, all existing booking settings will be lost.', 'jet-booking' ); ?>
							</p>
						</div>

						<div class="cx-vui-component__control">
							<cx-vui-button button-style="accent-error" @click="resetDialog = true">
								<template slot="label">
									<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
										<path d="M5.0013 15.8333C5.0013 16.75 5.7513 17.5 6.66797 17.5H13.3346C14.2513 17.5 15.0013 16.75 15.0013 15.8333V5.83333H5.0013V15.8333ZM15.8346 3.33333H12.918L12.0846 2.5H7.91797L7.08464 3.33333H4.16797V5H15.8346V3.33333Z" fill="white"></path>
									</svg>
									<?php _e( 'Reset data', 'jet-booking' ); ?>
								</template>
							</cx-vui-button>
						</div>
					</div>

					<div class="cx-vui-component cx-vui-component--equalwidth">
						<div class="cx-vui-component__meta">
							<label class="cx-vui-component__label">
								<?php _e( 'Keep data and set up manually', 'jet-booking' ); ?>
							</label>

							<p class="cx-vui-component__desc">
								<?php _e( 'All the previously configured settings will not be changed, and you can edit them manually.', 'jet-booking' ); ?>
							</p>
						</div>

						<div class="cx-vui-component__control">
							<cx-vui-button
								button-style="accent-border"
								tag-name="a"
								target="_blank"
								url="<?php  echo add_query_arg( [ 'page' => 'jet-abaf-settings' ], esc_url( admin_url( 'admin.php' ) ) ); ?>"
							>
								<template slot="label">
									<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
										<path d="M15.9504 10.7833C15.9837 10.5333 16.0004 10.275 16.0004 10C16.0004 9.73333 15.9837 9.46667 15.9421 9.21667L17.6337 7.9C17.7837 7.78333 17.8254 7.55833 17.7338 7.39167L16.1338 4.625C16.0338 4.44167 15.8254 4.38333 15.6421 4.44167L13.6504 5.24167C13.2337 4.925 12.7921 4.65833 12.3004 4.45833L12.0004 2.34167C11.9671 2.14167 11.8004 2 11.6004 2H8.40042C8.20042 2 8.04208 2.14167 8.00875 2.34167L7.70875 4.45833C7.21708 4.65833 6.76708 4.93333 6.35875 5.24167L4.36708 4.44167C4.18375 4.375 3.97542 4.44167 3.87542 4.625L2.28375 7.39167C2.18375 7.56667 2.21708 7.78333 2.38375 7.9L4.07542 9.21667C4.03375 9.46667 4.00042 9.74167 4.00042 10C4.00042 10.2583 4.01708 10.5333 4.05875 10.7833L2.36708 12.1C2.21708 12.2167 2.17542 12.4417 2.26708 12.6083L3.86708 15.375C3.96708 15.5583 4.17542 15.6167 4.35875 15.5583L6.35042 14.7583C6.76708 15.075 7.20875 15.3417 7.70042 15.5417L8.00042 17.6583C8.04208 17.8583 8.20042 18 8.40042 18H11.6004C11.8004 18 11.9671 17.8583 11.9921 17.6583L12.2921 15.5417C12.7837 15.3417 13.2337 15.075 13.6421 14.7583L15.6337 15.5583C15.8171 15.625 16.0254 15.5583 16.1254 15.375L17.7254 12.6083C17.8254 12.425 17.7837 12.2167 17.6254 12.1L15.9504 10.7833ZM10.0004 13C8.35042 13 7.00042 11.65 7.00042 10C7.00042 8.35 8.35042 7 10.0004 7C11.6504 7 13.0004 8.35 13.0004 10C13.0004 11.65 11.6504 13 10.0004 13Z" fill="#0D88BF"></path>
									</svg>
									<?php _e( 'Go to settings', 'jet-booking' ); ?>
								</template>
							</cx-vui-button>
						</div>
					</div>
				</div>
			</template>
		</div>

		<cx-vui-popup
			class="jet-abaf-popup jet-abaf-popup-reset"
			body-width="520px"
			v-model="resetDialog"
			:header="false"
			:footer="false"
		>
			<template slot="content">
				<div class="jet-abaf-popup__content">
					<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40" fill="none">
						<path d="M19.9987 36.6663C10.7937 36.6663 3.33203 29.2047 3.33203 19.9997C3.33203 10.7947 10.7937 3.33301 19.9987 3.33301C29.2037 3.33301 36.6654 10.7947 36.6654 19.9997C36.6654 29.2047 29.2037 36.6663 19.9987 36.6663ZM18.332 24.9997V28.333H21.6654V24.9997H18.332ZM18.332 11.6663V21.6663H21.6654V11.6663H18.332Z" fill="#FFA2C5"></path>
					</svg>
					<h3><?php _e( 'Are you sure you want to delete all data?', 'jet-booking' ); ?></h3>
					<div><?php _e( 'After you confirm to "Delete all data", all settings, booking instances, units, and columns will be removed from the database. You won\'t be able to restore them.', 'jet-booking' ); ?></div>
				</div>

				<div class="jet-abaf-popup__actions">
					<cx-vui-button class="compact" button-style="accent-border" @click="resetDialog = false">
						<template slot="label">
							<?php _e( 'Cancel', 'jet-booking' ); ?>
						</template>
					</cx-vui-button>

					<cx-vui-button class="compact" button-style="accent-error" @click="goToReset">
						<template slot="label">
							<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
								<path d="M5.0013 15.8333C5.0013 16.75 5.7513 17.5 6.66797 17.5H13.3346C14.2513 17.5 15.0013 16.75 15.0013 15.8333V5.83333H5.0013V15.8333ZM15.8346 3.33333H12.918L12.0846 2.5H7.91797L7.08464 3.33333H4.16797V5H15.8346V3.33333Z" fill="white"></path>
							</svg>
							<?php _e( 'Delete all data', 'jet-booking' ); ?>
						</template>
					</cx-vui-button>
				</div>
			</template>
		</cx-vui-popup>
	</div>
</div>