<?php

BoldThemes_Customize_Default::$data['body_font'] = 'Nunito Sans';
BoldThemes_Customize_Default::$data['heading_supertitle_font'] = 'Roboto Condensed';
BoldThemes_Customize_Default::$data['heading_font'] = 'Roboto';
BoldThemes_Customize_Default::$data['heading_subtitle_font'] = 'Nunito Sans';
BoldThemes_Customize_Default::$data['menu_font'] = 'Roboto';

BoldThemes_Customize_Default::$data['accent_color'] = '#f71c52';
BoldThemes_Customize_Default::$data['alternate_color'] = '#b40d4a';
BoldThemes_Customize_Default::$data['logo_height'] = '100';

BoldThemes_Customize_Default::$data['template_skin'] = false;
BoldThemes_Customize_Default::$data['heading_style'] = 'default';

// CUSTOMIZATION: OVERLAY LINES
BoldThemes_Customize_Default::$data['heading_style'] = 'default';
if ( ! function_exists( 'boldthemes_customize_heading_style' ) ) {
	function boldthemes_customize_heading_style( $wp_customize ) {
		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[heading_style]', array(
			'default'           => BoldThemes_Customize_Default::$data['heading_style'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field'
		));
		$wp_customize->add_control( 'heading_style', array(
			'label'     => esc_html( 'Heading Style', 'celeste' ),
			'section'   => BoldThemesFramework::$pfx . '_typography_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[heading_style]',
			'priority'  => 95,
			'type'      => 'select',
			'choices'   => array(
				'default' => esc_html( 'Default', 'celeste' ),
				'compact' => esc_html( 'Compact (small line height + bold)', 'celeste' )
			)
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_heading_style' );



// SECTION - LAYOUT, OVERLAY, NEGATIVE MARGIN, HIGHLIGHTED
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( "bt_bb_section", 'layout' );
	bt_bb_remove_params( "bt_bb_section", 'background_overlay' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_section', array(
		array( 'param_name' => 'layout', 'type' => 'dropdown', 'default' => 'boxed_1200', 'heading' => esc_html__( 'Layout', 'celeste' ), 'group' => esc_html__( 'General', 'celeste' ), 'weight' => 0, 'preview' => true, 'value' => array(
				esc_html__( 'Boxed (800px)', 'celeste' ) => 'boxed_800',
				esc_html__( 'Boxed (900px)', 'celeste' ) => 'boxed_900',
				esc_html__( 'Boxed (1000px)', 'celeste' ) => 'boxed_1000',
				esc_html__( 'Boxed (1100px)', 'celeste' ) => 'boxed_1100',
				esc_html__( 'Boxed (1200px)', 'celeste' ) => 'boxed_1200',
				esc_html__( 'Boxed (1300px)', 'celeste' ) => 'boxed_1300',
				esc_html__( 'Boxed (1400px)', 'celeste' ) => 'boxed_1400',
				esc_html__( 'Boxed (1500px)', 'celeste' ) => 'boxed_1500',
				esc_html__( 'Boxed (1600px)', 'celeste' ) => 'boxed_1600',
				esc_html__( 'Boxed right (1200px)', 'celeste' ) => 'boxed_right_1200',
				esc_html__( 'Boxed left (1200px)', 'celeste' ) => 'boxed_left_1200',
				esc_html__( 'Boxed left and right (1200px)', 'celeste' ) => 'boxed_left_right_1200',
				esc_html__( 'Wide', 'celeste' ) => 'wide'
			)
		),

		array( 'param_name' => 'background_overlay', 'type' => 'dropdown', 'heading' => esc_html__( 'Background overlay', 'celeste' ), 'group' => esc_html__( 'Design', 'celeste' ), 'weight' => 4, 'value' => array(
				esc_html__( 'No overlay', 'celeste' )    => '',
				esc_html__( 'Light stripes', 'celeste' ) => 'light_stripes',
				esc_html__( 'Dark stripes', 'celeste' )  => 'dark_stripes',
				esc_html__( 'Light solid', 'celeste' )	  => 'light_solid',
				esc_html__( 'Dark solid', 'celeste' )	  => 'dark_solid',
				esc_html__( 'Light gradient', 'celeste' )	  => 'light_gradient',
				esc_html__( 'Dark gradient', 'celeste' )	  => 'dark_gradient',
				esc_html__( 'Accent gradient', 'celeste' )	  => 'accent_gradient',
				esc_html__( 'Alternate gradient', 'celeste' )	  => 'alternate_gradient'
			)
		),

		array( 'param_name' => 'top_negative_margin', 'type' => 'dropdown', 'heading' => esc_html__( 'Top negative margin', 'celeste' ), 'preview' => true,
			'value' => array(
				esc_html__( 'No margin', 'celeste' ) => '',
				esc_html__( 'Extra small', 'celeste' ) => 'extra_small',
				esc_html__( 'Small', 'celeste' ) => 'small',		
				esc_html__( 'Normal', 'celeste' ) => 'normal',
				esc_html__( 'Medium', 'celeste' ) => 'medium',
				esc_html__( 'Large', 'celeste' ) => 'large',
				esc_html__( 'Extra large', 'celeste' ) => 'extra_large'
			)
		),

		array( 'param_name' => 'bottom_negative_margin', 'type' => 'dropdown', 'heading' => esc_html__( 'Bottom negative margin', 'celeste' ), 'preview' => true,
			'value' => array(
				esc_html__( 'No margin', 'celeste' ) => '',
				esc_html__( 'Extra small', 'celeste' ) => 'extra_small',
				esc_html__( 'Small', 'celeste' ) => 'small',		
				esc_html__( 'Normal', 'celeste' ) => 'normal',
				esc_html__( 'Medium', 'celeste' ) => 'medium',
				esc_html__( 'Large', 'celeste' ) => 'large',
				esc_html__( 'Extra large', 'celeste' ) => 'extra_large'
			)
		),

		array( 'param_name' => 'highlighted', 'type' => 'dropdown', 'heading' => esc_html__( 'Highlighted section', 'celeste' ), 'group' => esc_html__( 'Design', 'celeste' ), 'preview' => true,
			'value' => array(
				esc_html__( 'No', 'celeste' ) => 'no',
				esc_html__( 'Outline', 'celeste' ) => 'outline'
			)
		)
	) );
}

function load_and_go_bt_bb_section_class( $class, $atts ) {
	if ( isset( $atts['top_negative_margin'] ) && $atts['top_negative_margin'] != '' ) {
		$class[] = 'bt_bb_top_negative_margin' . '_' . $atts['top_negative_margin'];
	}
	
	if ( isset( $atts['bottom_negative_margin'] ) && $atts['bottom_negative_margin'] != '' ) {
		$class[] = 'bt_bb_bottom_negative_margin' . '_' . $atts['bottom_negative_margin'];
	}

	if ( isset( $atts['highlighted'] ) && $atts['highlighted'] != '' ) {
		$class[] = 'bt_bb_highlighted' . '_' . $atts['highlighted'];
	}

	return $class;
}
add_filter( 'bt_bb_section_class', 'load_and_go_bt_bb_section_class', 10, 2 );


// COUNTER - WEIGHT
if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_counter', array(
		array( 
			'param_name' => 'font_weight', 'type' => 'dropdown',  'default' => 'normal',  'heading' => esc_html__( 'Weight', 'celeste' ),  'group' 	=> esc_html__( 'General', 'celeste' ),  'weight' => 3, 'preview' => true, 'value' 	=> array(
				esc_html__( 'Light', 'celeste' ) => 'light',
				esc_html__( 'Normal', 'celeste' ) => 'normal',
				esc_html__( 'Bold', 'celeste' ) => 'bold',
			)
		)
	) );
}

function load_and_go_bt_bb_counter_class( $class, $atts ) {
	if ( isset( $atts['font_weight'] ) && $atts['font_weight'] != '' ) {
		$class[] = 'bt_bb_font_weight_' . $atts['font_weight'];
	}
	return $class;
}
add_filter( 'bt_bb_counter_class', 'load_and_go_bt_bb_counter_class', 10, 2 );



// COLUMN - HIGHLIGHT
if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_column', array(
		array( 'param_name' => 'highlighted', 'type' => 'dropdown', 'heading' => esc_html__( 'Highlighted column', 'celeste' ), 'group' => esc_html__( 'Design', 'celeste' ), 'preview' => true, 'value' => array(
				esc_html__( 'No', 'celeste' ) => 'no',
				esc_html__( 'Outline', 'celeste' ) => 'outline',
				esc_html__( 'Shadow', 'celeste' ) => 'shadow'
			)
		)
	) );
}

function load_and_go_bt_bb_column_class( $class, $atts ) {
	if ( isset( $atts['highlighted'] ) && $atts['highlighted'] != '' ) {
		$class[] = 'bt_bb_highlighted' . '_' . $atts['highlighted'];
	}
	return $class;
}
add_filter( 'bt_bb_column_class', 'load_and_go_bt_bb_column_class', 10, 2 );


// COLUMN INNER - HIGHLIGHT
if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_column_inner', array(
		array( 'param_name' => 'highlighted', 'type' => 'dropdown', 'heading' => esc_html__( 'Highlighted column', 'celeste' ), 'group' => esc_html__( 'Design', 'celeste' ), 'preview' => true, 'value' => array(
				esc_html__( 'No', 'celeste' ) => 'no',
				esc_html__( 'Yes', 'celeste' ) => 'outline'
			)
		)
	) );
}

function load_and_go_bt_bb_column_inner_class( $class, $atts ) {
	if ( isset( $atts['highlighted'] ) && $atts['highlighted'] != '' ) {
		$class[] = 'bt_bb_highlighted' . '_' . $atts['highlighted'];
	}
	return $class;
}
add_filter( 'bt_bb_column_inner_class', 'load_and_go_bt_bb_column_inner_class', 10, 2 );


// CONTENT SLIDER ITEM - HIGHLIGHT
if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_content_slider_item', array(
		array( 'param_name' => 'highlighted', 'type' => 'dropdown', 'heading' => esc_html__( 'Highlighted slider item', 'celeste' ), 'group' => esc_html__( 'General', 'celeste' ), 'preview' => true, 'value' => array(
				esc_html__( 'No', 'celeste' ) => 'no',
				esc_html__( 'Outline', 'celeste' ) => 'outline'
			)
		)
	) );
}

function load_and_go_bt_bb_content_slider_item_class( $class, $atts ) {
	if ( isset( $atts['highlighted'] ) && $atts['highlighted'] != '' ) {
		$class[] = 'bt_bb_highlighted' . '_' . $atts['highlighted'];
	}
	return $class;
}
add_filter( 'bt_bb_content_slider_item_class', 'load_and_go_bt_bb_content_slider_item_class', 10, 2 );


// ICON - SIZE
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_icon', 'size' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_icon', array(
		array( 'param_name' => 'size',  'type' => 'dropdown',  'heading' => esc_html__( 'Size', 'celeste' ),  'preview' => true, 'responsive_override' => true, 'value' => array(
				esc_html__( 'Extra small', 'celeste' ) 	=> 'xsmall',
				esc_html__( 'Small', 'celeste' ) 		=> 'small',
				esc_html__( 'Normal', 'celeste' ) 		=> 'normal',
				esc_html__( 'Large', 'celeste' ) 		=> 'large',
				esc_html__( 'Extra large', 'celeste' ) 	=> 'xlarge',
				esc_html__( 'Huge', 'celeste' ) 		=> 'huge'
			)
		),
	) );
}



/* FRONT END 
---------------------------------------------------------- */

/* OLD ELEMENTS */
function bt_bb_fe_new_params( $elements_array) {

	$elements_array[ 'bt_bb_section' ][ 'params' ][ 'top_negative_margin' ] = array( 'ajax_filter' => array( 'class' ) );
	$elements_array[ 'bt_bb_section' ][ 'params' ][ 'bottom_negative_margin' ] = array( 'ajax_filter' => array( 'class' ) );
	$elements_array[ 'bt_bb_section' ][ 'params' ][ 'highlighted' ] = array( 'ajax_filter' => array( 'class' ) );

	$elements_array[ 'bt_bb_counter' ][ 'params' ][ 'font_weight' ] = array( 'ajax_filter' => array( 'class' ) );

	return $elements_array;
}
add_filter( 'bt_bb_fe_elements', 'bt_bb_fe_new_params' );


/* NEW ELEMENTS */
function celeste_bt_bb_fe( $elements ) {
	$elements[ 'bt_bb_progress_bar_advanced' ] = array(
		'edit_box_selector' => '',
		'ajax_trigger_scroll' => true,
		'params' => array(
			'type'        				=> array(),
			'percentage'        		=> array(),
			'duration'     	   			=> array(),
			'easing'       	 			=> array(),
			'text'        				=> array( 'js_handler' => array( 'target_selector' => '.bt_bb_progress_bar_advanced_text', 'type' => 'inner_html' ) ),
			'icon'						=> array(),
			'url'						=> array( 'js_handler' => array( 'target_selector' => 'a', 'type' => 'attr', 'attr' => 'href' ) ),
			'target' 					=> array( 'js_handler' => array( 'target_selector' => 'a', 'type' => 'attr', 'attr' => 'target' ) ),
		),
	);

	$elements[ 'bt_bb_working_hours' ] = array(
		'edit_box_selector' => '',
		'params' => array( 
			'wh_content'    => array(),
		),
	);

	return $elements;
}
add_filter( 'bt_bb_fe_elements', 'celeste_bt_bb_fe' );