<?php
if ( class_exists( 'BoldThemesFramework' ) && isset( BoldThemesFramework::$crush_vars ) ) {
	$boldthemes_crush_vars = BoldThemesFramework::$crush_vars;
}
if ( class_exists( 'BoldThemesFramework' ) && isset( BoldThemesFramework::$crush_vars_def ) ) {
	$boldthemes_crush_vars_def = BoldThemesFramework::$crush_vars_def;
}
if ( isset( $boldthemes_crush_vars['accentColor'] ) ) {
	$accentColor = $boldthemes_crush_vars['accentColor'];
} else {
	$accentColor = "#f71c52";
}
if ( isset( $boldthemes_crush_vars['alternateColor'] ) ) {
	$alternateColor = $boldthemes_crush_vars['alternateColor'];
} else {
	$alternateColor = "#b40d4a";
}
if ( isset( $boldthemes_crush_vars['bodyFont'] ) ) {
	$bodyFont = $boldthemes_crush_vars['bodyFont'];
} else {
	$bodyFont = "Nunito Sans";
}
if ( isset( $boldthemes_crush_vars['menuFont'] ) ) {
	$menuFont = $boldthemes_crush_vars['menuFont'];
} else {
	$menuFont = "Roboto";
}
if ( isset( $boldthemes_crush_vars['headingFont'] ) ) {
	$headingFont = $boldthemes_crush_vars['headingFont'];
} else {
	$headingFont = "Roboto";
}
if ( isset( $boldthemes_crush_vars['headingSuperTitleFont'] ) ) {
	$headingSuperTitleFont = $boldthemes_crush_vars['headingSuperTitleFont'];
} else {
	$headingSuperTitleFont = "Roboto Condensed";
}
if ( isset( $boldthemes_crush_vars['headingSubTitleFont'] ) ) {
	$headingSubTitleFont = $boldthemes_crush_vars['headingSubTitleFont'];
} else {
	$headingSubTitleFont = "Nunito Sans";
}
if ( isset( $boldthemes_crush_vars['logoHeight'] ) ) {
	$logoHeight = $boldthemes_crush_vars['logoHeight'];
} else {
	$logoHeight = "100";
}
$accentColorDark = CssCrush\fn__l_adjust( $accentColor." -15" );$accentColorVeryDark = CssCrush\fn__l_adjust( $accentColor." -35" );$accentColorVeryVeryDark = CssCrush\fn__l_adjust( $accentColor." -42" );$accentColorLight = CssCrush\fn__a_adjust( $accentColor." -30" );$alternateColorDark = CssCrush\fn__l_adjust( $alternateColor." -15" );$alternateColorVeryDark = CssCrush\fn__l_adjust( $alternateColor." -25" );$alternateColorLight = CssCrush\fn__a_adjust( $alternateColor." -40" );$css_override = sanitize_text_field("select,
input{font-family: \"{$bodyFont}\";}
input:not([type='checkbox']):not([type='radio']):not([type='submit']):focus,
textarea:focus,
.fancy-select .trigger.open{-webkit-box-shadow: 0 2px 5px 0 rgba(0,0,0,.3),0 -2px 0 0 {$accentColor} inset;
    box-shadow: 0 2px 5px 0 rgba(0,0,0,.3),0 -2px 0 0 {$accentColor} inset;}
.single-post .btContent a,
.single-portfolio .btContent a{color: {$accentColor};}
a:hover{
    color: {$accentColor};}
.btText a{color: {$accentColor};}
body{font-family: \"{$bodyFont}\",Arial,sans-serif;}
h1,
h2,
h3,
h4,
h5,
h6{font-family: \"{$headingFont}\";}
.btContentHolder table thead th{
    background-color: {$accentColor};}
.btAccentDarkHeader .btPreloader .animation > div:first-child,
.btLightAccentHeader .btPreloader .animation > div:first-child,
.btTransparentLightHeader .btPreloader .animation > div:first-child{
    background-color: {$accentColor};}
.btPreloader .animation .preloaderLogo{height: {$logoHeight}px;}
.btLoader{
    border-top: 2px solid {$accentColor} !important;
    border-right: 2px solid {$accentColor} !important;}
.btLoader:before,
.btLoader:after{
    border-top: 2px solid {$accentColor} !important;
    border-right: 2px solid {$accentColor} !important;}
.btErrorPage .bt_bb_port .bt_bb_headline .bt_bb_headline_subheadline a{background: {$accentColor};
    font-family: {$bodyFont};}
.btErrorPage .bt_bb_port .bt_bb_headline .bt_bb_headline_subheadline a:hover{background: {$accentColorDark};}
.mainHeader{
    font-family: \"{$menuFont}\";}
.mainHeader a:hover{color: {$accentColor};}
.menuPort{font-family: \"{$menuFont}\";}
.menuPort nav > ul > li > a:after{
    background: {$accentColor};}
.menuPort nav > ul > li > a{line-height: {$logoHeight}px;}
.btTextLogo{font-family: \"{$menuFont}\";
    line-height: {$logoHeight}px;}
.btLogoArea .logo img{height: {$logoHeight}px;}
.btTransparentDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:before,
.btTransparentLightHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:before,
.btAccentLightHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:before,
.btAccentDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:before,
.btLightDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:before,
.btHasAltLogo.btStickyHeaderActive .btHorizontalMenuTrigger:hover .bt_bb_icon:before,
.btTransparentDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:after,
.btTransparentLightHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:after,
.btAccentLightHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:after,
.btAccentDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:after,
.btLightDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon:after,
.btHasAltLogo.btStickyHeaderActive .btHorizontalMenuTrigger:hover .bt_bb_icon:after{border-top-color: {$accentColor};}
.btTransparentDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btTransparentLightHeader .btHorizontalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btAccentLightHeader .btHorizontalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btAccentDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btLightDarkHeader .btHorizontalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btHasAltLogo.btStickyHeaderActive .btHorizontalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before{border-top-color: {$accentColor};}
.btMenuHorizontal .menuPort nav > ul > li.current-menu-ancestor li.current-menu-ancestor > a,
.btMenuHorizontal .menuPort nav > ul > li.current-menu-ancestor li.current-menu-item > a,
.btMenuHorizontal .menuPort nav > ul > li.current-menu-item li.current-menu-ancestor > a,
.btMenuHorizontal .menuPort nav > ul > li.current-menu-item li.current-menu-item > a{color: {$accentColor};}
.btMenuHorizontal .menuPort ul ul li a:hover{color: {$accentColor};}
body.btMenuHorizontal .subToggler{
    line-height: {$logoHeight}px;}
.btMenuHorizontal .menuPort > nav > ul > li > ul li a:before{
    background: {$accentColor};}
html:not(.touch) body.btMenuHorizontal .menuPort > nav > ul > li.btMenuWideDropdown > ul > li > a:after{
    background: {$accentColor};}
.btMenuHorizontal .topBar{
    font-family: {$bodyFont};}
.btMenuHorizontal .topBarInMenu{
    height: {$logoHeight}px;
    font-family: {$bodyFont};}
.btMenuHorizontal .topBarInMenu .topBarInMenuCell{line-height: -webkit-calc({$logoHeight}px / 2);
    line-height: -moz-calc({$logoHeight}px / 2);
    line-height: calc({$logoHeight}px / 2);}
.btAccentLightHeader .btBelowLogoArea,
.btAccentLightHeader .topBar{background-color: {$accentColor};}
.btAccentLightHeader .btBelowLogoArea .menuPort nav > ul > li.current-menu-ancestor.on a:after,
.btAccentLightHeader .btBelowLogoArea .menuPort nav > ul > li.current-menu-item.on a:after{background: {$accentColor};}
.btAccentDarkHeader .btBelowLogoArea,
.btAccentDarkHeader .topBar{background-color: {$accentColor};}
.btAccentDarkHeader .btBelowLogoArea .menuPort nav > ul > li.current-menu-ancestor.on a:after,
.btAccentDarkHeader .btBelowLogoArea .menuPort nav > ul > li.current-menu-item.on a:after{background: {$accentColor};}
.btAccentGradientHeader .btLogoArea,
.btAccentGradientHeader .btVerticalHeaderTop{background-color: {$accentColor} !important;}
.btAccentGradientHeader .btLogoArea{
    -webkit-box-shadow: 0 -5px 0 0 {$alternateColor} inset;
    box-shadow: 0 -5px 0 0 {$alternateColor} inset;}
.btAccentGradientHeader .btLogoArea:before{
    background: -webkit-linear-gradient(left,{$accentColor} 0%,transparent 100%);
    background: -moz-linear-gradient(left,{$accentColor} 0%,transparent 100%);
    background: linear-gradient(to right,{$accentColor} 0%,transparent 100%);}
.btAccentGradientHeader .btLogoArea a:hover,
.btAccentGradientHeader .btLogoArea a.btIconWidget:hover{color: {$alternateColor};}
.btAccentGradientHeader .btLogoArea .btAccentIconWidget.btIconWidget .btIconWidgetIcon{color: {$alternateColor};}
.btAccentGradientHeader .btLogoArea .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon:hover{color: {$alternateColor};}
.btAccentGradientHeader .btLogoArea .topBarInLogoArea .btIconWidget .btIconWidgetContent .btIconWidgetTitle{color: {$alternateColor};}
.btAccentGradientHeader .btLogoArea .topBarInLogoArea a.btIconWidget:hover .btIconWidgetText{color: {$alternateColor};}
.btAccentGradientHeader .btLogoArea .menuPort nav > ul > li.current-menu-ancestor > a:after,
.btAccentGradientHeader .btLogoArea .menuPort nav > ul > li.current-menu-item > a:after{background: {$alternateColor};}
.btAccentGradientHeader .btLogoArea .menuPort nav > ul > li.current-menu-ancestor.on a:after,
.btAccentGradientHeader .btLogoArea .menuPort nav > ul > li.current-menu-item.on a:after{background: {$accentColor};}
.btAccentGradientHeader.btMenuHorizontal.btBelowMenu .mainHeader .btLogoArea{background-color: {$accentColor};}
.btAlternateGradientHeader .btLogoArea,
.btAlternateGradientHeader .btVerticalHeaderTop{background-color: {$alternateColor} !important;}
.btAlternateGradientHeader .btLogoArea{
    -webkit-box-shadow: 0 -5px 0 0 {$accentColor} inset;
    box-shadow: 0 -5px 0 0 {$accentColor} inset;}
.btAlternateGradientHeader .btLogoArea:before{
    background: -webkit-linear-gradient(left,{$alternateColor} 0%,transparent 100%);
    background: -moz-linear-gradient(left,{$alternateColor} 0%,transparent 100%);
    background: linear-gradient(to right,{$alternateColor} 0%,transparent 100%);}
.btAlternateGradientHeader .btLogoArea a:hover,
.btAlternateGradientHeader .btLogoArea a.btIconWidget:hover{color: {$accentColor};}
.btAlternateGradientHeader .btLogoArea .btAccentIconWidget.btIconWidget .btIconWidgetIcon{color: {$accentColor};}
.btAlternateGradientHeader .btLogoArea .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon:hover{color: {$accentColor};}
.btAlternateGradientHeader .btLogoArea .topBarInLogoArea .btIconWidget .btIconWidgetContent .btIconWidgetTitle{color: {$accentColor};
    font-family: {$headingFont};}
.btAlternateGradientHeader .btLogoArea .topBarInLogoArea a.btIconWidget:hover .btIconWidgetText{color: {$accentColor};}
.btAlternateGradientHeader .btLogoArea .menuPort nav > ul > li.current-menu-ancestor > a:after,
.btAlternateGradientHeader .btLogoArea .menuPort nav > ul > li.current-menu-item > a:after{background: {$accentColor};}
.btAlternateGradientHeader .btLogoArea .menuPort nav > ul > li.current-menu-ancestor.on a:after,
.btAlternateGradientHeader .btLogoArea .menuPort nav > ul > li.current-menu-item.on a:after{background: {$accentColor};}
.btAlternateGradientHeader.btMenuHorizontal.btBelowMenu .mainHeader .btLogoArea{background-color: {$accentColor};}
.btLightAccentHeader .btLogoArea,
.btLightAccentHeader .btVerticalHeaderTop{background-color: {$accentColor};}
.btLightAccentHeader .btLogoArea .menuPort nav > ul > li.current-menu-ancestor.on a:after,
.btLightAccentHeader .btLogoArea .menuPort nav > ul > li.current-menu-item.on a:after{background: {$accentColor};}
.btLightAccentHeader.btMenuHorizontal.btBelowMenu .mainHeader .btLogoArea{background-color: {$accentColor};}
.btStickyHeaderActive.btMenuHorizontal .mainHeader .btLogoArea .logo img{height: -webkit-calc({$logoHeight}px*0.8);
    height: -moz-calc({$logoHeight}px*0.8);
    height: calc({$logoHeight}px*0.8);}
.btStickyHeaderActive.btMenuHorizontal .mainHeader .btLogoArea .btTextLogo{
    line-height: -webkit-calc({$logoHeight}px*0.8);
    line-height: -moz-calc({$logoHeight}px*0.8);
    line-height: calc({$logoHeight}px*0.8);}
.btStickyHeaderActive.btMenuHorizontal .mainHeader .btLogoArea .menuPort nav > ul > li > a,
.btStickyHeaderActive.btMenuHorizontal .mainHeader .btLogoArea .menuPort nav > ul > li > .subToggler{line-height: -webkit-calc({$logoHeight}px*0.8);
    line-height: -moz-calc({$logoHeight}px*0.8);
    line-height: calc({$logoHeight}px*0.8);}
.btStickyHeaderActive.btMenuHorizontal .mainHeader .btLogoArea .topBarInMenu{height: -webkit-calc({$logoHeight}px*0.8);
    height: -moz-calc({$logoHeight}px*0.8);
    height: calc({$logoHeight}px*0.8);}
.btTransparentDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon:before,
.btTransparentLightHeader .btVerticalMenuTrigger:hover .bt_bb_icon:before,
.btAccentLightHeader .btVerticalMenuTrigger:hover .bt_bb_icon:before,
.btAccentDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon:before,
.btLightDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon:before,
.btHasAltLogo.btStickyHeaderActive .btVerticalMenuTrigger:hover .bt_bb_icon:before,
.btTransparentDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon:after,
.btTransparentLightHeader .btVerticalMenuTrigger:hover .bt_bb_icon:after,
.btAccentLightHeader .btVerticalMenuTrigger:hover .bt_bb_icon:after,
.btAccentDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon:after,
.btLightDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon:after,
.btHasAltLogo.btStickyHeaderActive .btVerticalMenuTrigger:hover .bt_bb_icon:after{border-top-color: {$accentColor};}
.btTransparentDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btTransparentLightHeader .btVerticalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btAccentLightHeader .btVerticalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btAccentDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btLightDarkHeader .btVerticalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before,
.btHasAltLogo.btStickyHeaderActive .btVerticalMenuTrigger:hover .bt_bb_icon .bt_bb_icon_holder:before{border-top-color: {$accentColor};}
.btMenuVertical .mainHeader .btCloseVertical:before:hover{color: {$accentColor};}
.btMenuHorizontal .topBarInLogoArea{
    height: {$logoHeight}px;}
.btMenuHorizontal .topBarInLogoArea .topBarInLogoAreaCell{border: 0 solid {$accentColor};}
.btSiteFooter .bt_bb_custom_menu li a:hover{color: {$accentColor};}
.btSiteFooter .btLightSkin .bt_bb_icon a.bt_bb_icon_holder:hover{color: {$accentColor};}
.btSiteFooter .btDarkSkin .bt_bb_icon a.bt_bb_icon_holder:hover{color: {$accentColor};}
.btSiteFooter .bt_bb_color_scheme_6 .bt_bb_icon a.bt_bb_icon_holder:hover{color: {$alternateColor};}
.btSiteFooter .bt_bb_color_scheme_6 .bt_bb_custom_menu li a:hover{color: {$alternateColor};}
.btSiteFooter .bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_content .bt_bb_latest_posts_item_title{
    font-family: {$bodyFont};}
.btSiteFooter .btlightSkin .bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_content .bt_bb_latest_posts_item_title a:hover{color: {$accentColor};}
.btSiteFooter .btDarkSkin .bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_content .bt_bb_latest_posts_item_title a:hover{color: {$accentColor};}
.btSiteFooter .bt_bb_color_scheme_6 .bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_content .bt_bb_latest_posts_item_title a:hover{color: {$alternateColor};}
.btDarkSkin .btSiteFooterCopyMenu .port:before,
.btLightSkin .btDarkSkin .btSiteFooterCopyMenu .port:before,
.btDarkSkin.btLightSkin .btDarkSkin .btSiteFooterCopyMenu .port:before{background-color: {$accentColor};}
.btPostSingleItemStandard .btArticleShareEtc > div.btReadMoreColumn .bt_bb_button a{
    background: {$accentColor};}
.btMediaBox.btQuote:before,
.btMediaBox.btLink:before{
    background-color: {$accentColor};}
.btMediaBox.btQuote p,
.btMediaBox.btLink p{
    font-family: {$headingFont};}
.btMediaBox.btQuote cite,
.btMediaBox.btLink cite{
    font-family: {$headingSuperTitleFont};}
.articleSideGutter .date{
    font-family: {$headingSuperTitleFont};}
.sticky.btArticleListItem .btArticleHeadline h1 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h2 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h3 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h4 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h5 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h6 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h7 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h8 .bt_bb_headline_content span a:after{
    color: {$accentColor};}
.post-password-form p:nth-child(2) input[type=\"submit\"]{
    background: {$accentColor};}
.btPagination .paging a{
    background: {$accentColor};}
section.btPrevNextNav .btPrevNext .btPrevNextImage{
    -webkit-box-shadow: 0 0 0 0 {$accentColor},0 0 0 0 rgba(0,0,0,.3);
    box-shadow: 0 0 0 0 {$accentColor},0 0 0 0 rgba(0,0,0,.3);}
section.btPrevNextNav .btPrevNext .btPrevNextItem .btPrevNextTitle{font-family: \"{$headingFont}\";}
section.btPrevNextNav .btPrevNext .btPrevNextItem .btPrevNextDir{
    font-family: {$headingSuperTitleFont};}
section.btPrevNextNav .btPrevNext:hover .btPrevNextTitle{color: {$accentColor};}
section.btPrevNextNav .btPrevNext:hover .btPrevNextImage{-webkit-box-shadow: 0 0 0 3px {$accentColor},0 2px 10px 4px rgba(0,0,0,.3);
    box-shadow: 0 0 0 3px {$accentColor},0 2px 10px 4px rgba(0,0,0,.3);}
.btLinkPages ul a{
    background: {$accentColor};}
.btLinkPages ul a:hover{background: {$alternateColor};}
.btArticleCategories a:hover{color: {$accentColor};}
.btArticleDate,
.btArticleAuthor,
.btArticleComments,
.btArticleCategories{font-family: {$headingSuperTitleFont};}
.btArticleDate:before,
.btArticleAuthor:before,
.btArticleComments:before,
.btArticleCategories:before{
    color: {$accentColor};}
.btLightSkin .btArticleAuthor:hover,
.btLightSkin .btArticleComments:hover,
.btDarkSkin .btLightSkin .btArticleAuthor:hover,
.btDarkSkin .btLightSkin .btArticleComments:hover,
.btLightSkin .btDarkSkin .btLightSkin .btArticleAuthor:hover,
.btLightSkin .btDarkSkin .btLightSkin .btArticleComments:hover{color: {$accentColor};}
.btDarkSkin .btArticleAuthor:hover,
.btDarkSkin .btArticleComments:hover,
.btLightSkin .btDarkSkin .btArticleAuthor:hover,
.btLightSkin .btDarkSkin .btArticleComments:hover,
.btDarkSkin.btLightSkin .btDarkSkin .btArticleAuthor:hover,
.btDarkSkin.btLightSkin .btDarkSkin .btArticleComments:hover{color: {$accentColor};}
.bt-comments-box ul.comments li.pingback .edit-link a{
    font-family: {$headingSuperTitleFont};}
.bt-comments-box ul.comments li.pingback .edit-link a:before{
    color: {$accentColor};}
.bt-comments-box .vcard .posted{
    font-family: {$headingSuperTitleFont};}
.bt-comments-box .vcard .posted:before{
    color: {$accentColor};}
.bt-comments-box .commentTxt p.edit-link,
.bt-comments-box .commentTxt p.reply{
    font-family: {$headingSuperTitleFont};}
.bt-comments-box .commentTxt p.edit-link a:before,
.bt-comments-box .commentTxt p.reply a:before{
    color: {$accentColor};}
.comment-awaiting-moderation{color: {$accentColor};}
a#cancel-comment-reply-link{
    color: {$accentColor};
    font-family: {$bodyFont};
    font-family: {$headingSuperTitleFont};}
a#cancel-comment-reply-link:before{
    color: {$accentColor};}
.btCommentSubmit{
    font-family: {$bodyFont};
    background: {$accentColor};}
.no-comments{
    font-family: {$headingFont};}
.btBox ul li a:after{background: {$accentColor};}
body:not(.btNoDashInSidebar) .btBox > h4:after,
body:not(.btNoDashInSidebar) .btCustomMenu > h4:after,
body:not(.btNoDashInSidebar) .btTopBox > h4:after{
    border-bottom: 2px solid {$accentColor};}
.btBox ul li.current-menu-item > a,
.btCustomMenu ul li.current-menu-item > a,
.btTopBox ul li.current-menu-item > a{color: {$accentColor};}
.widget_calendar table caption{background: {$accentColor};
    background: {$accentColor};
    font-family: \"{$headingFont}\";}
.widget_rss li a.rsswidget{font-family: \"{$headingFont}\";}
.fancy-select ul.options li:hover{
    color: {$accentColor};}
.widget_shopping_cart .total{
    font-family: \"{$headingFont}\";}
.widget_shopping_cart .buttons .button{
    background: {$accentColor};}
.widget_shopping_cart .widget_shopping_cart_content .mini_cart_item .ppRemove a.remove{
    background-color: {$accentColor};}
.widget_shopping_cart .widget_shopping_cart_content .mini_cart_item .ppRemove a.remove:hover{background-color: {$alternateColor};}
.menuPort .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon:hover,
.topTools .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon:hover,
.topBarInLogoArea .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon:hover{color: {$accentColor};}
.btMenuVertical .menuPort .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetInnerContent .verticalMenuCartToggler,
.btMenuVertical .topTools .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetInnerContent .verticalMenuCartToggler,
.btMenuVertical .topBarInLogoArea .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetInnerContent .verticalMenuCartToggler{
    color: {$accentColor};}
.btMenuHorizontal.btStickyHeaderActive .topBarInMenu .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetInnerContent{top: -webkit-calc({$logoHeight}px/2 + ({$logoHeight}px*.8 - {$logoHeight}px/2)/2);
    top: -moz-calc({$logoHeight}px/2 + ({$logoHeight}px*.8 - {$logoHeight}px/2)/2);
    top: calc({$logoHeight}px/2 + ({$logoHeight}px*.8 - {$logoHeight}px/2)/2);}
.widget_recent_reviews{font-family: \"{$headingFont}\";}
.widget_price_filter .price_slider_wrapper .ui-slider .ui-slider-handle{
    background-color: {$accentColor};}
.btBox .tagcloud a,
.btTags ul a{
    background: {$accentColor};}
.topTools a.btIconWidget:hover,
.topBarInMenu a.btIconWidget:hover{color: {$accentColor};}
.btSidebar .btIconWidget .btIconWidgetContent .btIconWidgetTitle,
footer .btIconWidget .btIconWidgetContent .btIconWidgetTitle,
.topBarInLogoArea .btIconWidget .btIconWidgetContent .btIconWidgetTitle{
    color: {$accentColor};}
.btSidebar a.btIconWidget:hover .btIconWidgetText,
footer a.btIconWidget:hover .btIconWidgetText,
.topBarInLogoArea a.btIconWidget:hover .btIconWidgetText{color: {$accentColor};}
.btAccentIconWidget.btIconWidget .btIconWidgetIcon{color: {$accentColor};}
.btLightSkin .btSiteFooterWidgets .btSearch button:hover,
.btDarkSkin .btLightSkin .btSiteFooterWidgets .btSearch button:hover,
.btLightSkin .btDarkSkin .btLightSkin .btSiteFooterWidgets .btSearch button:hover,
.btDarkSkin .btSiteFooterWidgets .btSearch button:hover,
.btLightSkin .btDarkSkin .btSiteFooterWidgets .btSearch button:hover,
.btDarkSkin.btLightSkin .btDarkSkin .btSiteFooterWidgets .btSearch button:hover,
.btLightSkin .btSidebar .btSearch button:hover,
.btDarkSkin .btLightSkin .btSidebar .btSearch button:hover,
.btLightSkin .btDarkSkin .btLightSkin .btSidebar .btSearch button:hover,
.btDarkSkin .btSidebar .btSearch button:hover,
.btLightSkin .btDarkSkin .btSidebar .btSearch button:hover,
.btDarkSkin.btLightSkin .btDarkSkin .btSidebar .btSearch button:hover,
.btLightSkin .btSidebar .widget_product_search button:hover,
.btDarkSkin .btLightSkin .btSidebar .widget_product_search button:hover,
.btLightSkin .btDarkSkin .btLightSkin .btSidebar .widget_product_search button:hover,
.btDarkSkin .btSidebar .widget_product_search button:hover,
.btLightSkin .btDarkSkin .btSidebar .widget_product_search button:hover,
.btDarkSkin.btLightSkin .btDarkSkin .btSidebar .widget_product_search button:hover{background: {$accentColor} !important;
    border-color: {$accentColor} !important;}
.btSearchInner.btFromTopBox .btSearchInnerClose .bt_bb_icon a.bt_bb_icon_holder{color: {$accentColor};}
.btSearchInner.btFromTopBox .btSearchInnerClose .bt_bb_icon:hover a.bt_bb_icon_holder{color: {$accentColorDark};}
.btSearchInner.btFromTopBox input[type=\"text\"]{
    font-family: {$headingFont};}
.btSearchInner.btFromTopBox input[type=\"text\"]:focus{
    -webkit-box-shadow: 0 2px 5px 0 rgba(0,0,0,.3),0 -2px 0 0 {$accentColor} inset;
    box-shadow: 0 2px 5px 0 rgba(0,0,0,.3),0 -2px 0 0 {$accentColor} inset;}
.btSearchInner.btFromTopBox button:hover:before{color: {$accentColor};}
.bt_bb_headline .bt_bb_headline_superheadline{
    font-family: \"{$headingSuperTitleFont}\";}
.bt_bb_headline.bt_bb_subheadline .bt_bb_headline_subheadline{font-family: \"{$headingSubTitleFont}\";}
.bt_bb_headline .bt_bb_headline_content a:hover{color: {$accentColor};}
.bt_bb_dash_bottom.bt_bb_headline h1 .bt_bb_headline_content:after,
.bt_bb_dash_top_bottom.bt_bb_headline h1 .bt_bb_headline_content:after,
.bt_bb_dash_bottom.bt_bb_headline h2 .bt_bb_headline_content:after,
.bt_bb_dash_top_bottom.bt_bb_headline h2 .bt_bb_headline_content:after,
.bt_bb_dash_bottom.bt_bb_headline h3 .bt_bb_headline_content:after,
.bt_bb_dash_top_bottom.bt_bb_headline h3 .bt_bb_headline_content:after,
.bt_bb_dash_bottom.bt_bb_headline h4 .bt_bb_headline_content:after,
.bt_bb_dash_top_bottom.bt_bb_headline h4 .bt_bb_headline_content:after,
.bt_bb_dash_bottom.bt_bb_headline h5 .bt_bb_headline_content:after,
.bt_bb_dash_top_bottom.bt_bb_headline h5 .bt_bb_headline_content:after,
.bt_bb_dash_bottom.bt_bb_headline h6 .bt_bb_headline_content:after,
.bt_bb_dash_top_bottom.bt_bb_headline h6 .bt_bb_headline_content:after{
    border-color: {$accentColor};}
.bt_bb_headline h1 strong,
.bt_bb_headline h2 strong,
.bt_bb_headline h3 strong,
.bt_bb_headline h4 strong,
.bt_bb_headline h5 strong,
.bt_bb_headline h6 strong{
    color: {$accentColor};}
.bt_bb_headline h1 u,
.bt_bb_headline h2 u,
.bt_bb_headline h3 u,
.bt_bb_headline h4 u,
.bt_bb_headline h5 u,
.bt_bb_headline h6 u{
    color: {$alternateColor};}
section.btPageHeadline .bt_bb_column:not(.bt_bb_align_center):not(.bt_bb_align_right) .bt_bb_headline.bt_bb_dash_top .bt_bb_headline_content:before,
body.btHideHeadline .btContentWrap .bt_bb_wrapper > section.bt_bb_section:first-of-type .bt_bb_column:not(.bt_bb_align_center):not(.bt_bb_align_right) .bt_bb_headline.bt_bb_dash_top .bt_bb_headline_content:before,
body.btHideHeadline .btContentWrap .bt_bb_wrapper > .bt_bb_fe_wrap:first-of-type > section .bt_bb_column:not(.bt_bb_align_center):not(.bt_bb_align_right) .bt_bb_headline.bt_bb_dash_top .bt_bb_headline_content:before{
    border-top: 2px solid {$accentColor};}
.bt_bb_progress_bar .bt_bb_progress_bar_inner .bt_bb_progress_bar_text{font-family: {$headingSuperTitleFont};}
button.mfp-close:before{color: {$accentColor};}
button.mfp-close:hover:before{
    color: {$alternateColor};}
.bt_bb_latest_posts_item .bt_bb_latest_posts_item_date{font-family: \"{$headingSuperTitleFont}\";}
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_image:before{
    background: {$accentColor};
    font-family: {$headingFont};}
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_image:after{
    background: {$accentColor};}
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_title{
    font-family: {$headingFont};}
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_title a{color: {$accentColor};}
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_meta{font-family: {$headingSuperTitleFont};}
.btLightSkin .bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_meta > span a:hover,
.btDarkSkin .btLightSkin .bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_meta > span a:hover,
.btLightSkin .btDarkSkin .btLightSkin .bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_meta > span a:hover{color: {$accentColor};}
.btDarkSkin .bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_meta > span a:hover,
.btLightSkin .btDarkSkin .bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_meta > span a:hover,
.btDarkSkin.btLightSkin .btDarkSkin .bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_meta > span a:hover,
.bt_bb_color_scheme_1 .bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_meta > span a:hover{color: {$accentColor};}
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_meta > span:before{color: {$accentColor};}
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_category{
    font-family: {$headingSuperTitleFont};}
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_category .post-categories:before{color: {$accentColor};}
.btLightSkin .bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_category .post-categories li a:hover,
.btDarkSkin .btLightSkin .bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_category .post-categories li a:hover,
.btLightSkin .btDarkSkin .btLightSkin .bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_category .post-categories li a:hover{color: {$accentColor};}
.btDarkSkin .bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_category .post-categories li a:hover,
.btLightSkin .btDarkSkin .bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_category .post-categories li a:hover,
.btDarkSkin.btLightSkin .btDarkSkin .bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_category .post-categories li a:hover,
.bt_bb_color_scheme_1 .bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_category .post-categories li a:hover{color: {$accentColor};}
.bt_bb_post_grid_filter{font-family: {$menuFont};}
.bt_bb_post_grid_filter .bt_bb_post_grid_filter_item:after{
    background: {$accentColor};}
.bt_bb_masonry_post_grid .bt_bb_grid_item_post_thumbnail a:before,
.bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_thumbnail a:before{
    font-family: {$headingFont};}
.bt_bb_masonry_post_grid .bt_bb_grid_item_post_thumbnail a:after,
.bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_thumbnail a:after{
    background: {$accentColor};}
.bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_post_title,
.bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_post_title{
    font-family: {$headingFont};}
.bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_post_title a,
.bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_post_title a{color: {$accentColor};}
.bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta,
.bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta{font-family: {$headingSuperTitleFont} !important;}
.btLightSkin .bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta > span a:hover,
.btDarkSkin .btLightSkin .bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta > span a:hover,
.btLightSkin .btDarkSkin .btLightSkin .bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta > span a:hover,
.btLightSkin .bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta > span a:hover,
.btDarkSkin .btLightSkin .bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta > span a:hover,
.btLightSkin .btDarkSkin .btLightSkin .bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta > span a:hover{color: {$accentColor};}
.btDarkSkin .bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta > span a:hover,
.btLightSkin .btDarkSkin .bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta > span a:hover,
.btDarkSkin.btLightSkin .btDarkSkin .bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta > span a:hover,
.bt_bb_color_scheme_1 .bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta > span a:hover,
.btDarkSkin .bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta > span a:hover,
.btLightSkin .btDarkSkin .bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta > span a:hover,
.btDarkSkin.btLightSkin .btDarkSkin .bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta > span a:hover,
.bt_bb_color_scheme_1 .bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta > span a:hover{color: {$accentColor};}
.bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta > span:before,
.bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta > span:before{color: {$accentColor};}
.bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category,
.bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category{
    font-family: {$headingSuperTitleFont};}
.btLightSkin .bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category a:hover,
.btDarkSkin .btLightSkin .bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category a:hover,
.btLightSkin .btDarkSkin .btLightSkin .bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category a:hover,
.btLightSkin .bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category a:hover,
.btDarkSkin .btLightSkin .bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category a:hover,
.btLightSkin .btDarkSkin .btLightSkin .bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category a:hover{color: {$accentColor};}
.btDarkSkin .bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category a:hover,
.btLightSkin .btDarkSkin .bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category a:hover,
.btDarkSkin.btLightSkin .btDarkSkin .bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category a:hover,
.bt_bb_color_scheme_1 .bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category a:hover,
.btDarkSkin .bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category a:hover,
.btLightSkin .btDarkSkin .bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category a:hover,
.btDarkSkin.btLightSkin .btDarkSkin .bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category a:hover,
.bt_bb_color_scheme_1 .bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category a:hover{color: {$accentColor};}
.bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category > a:first-child:before,
.bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category ul li:first-child a:before,
.bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category > a:first-child:before,
.bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category ul li:first-child a:before{color: {$accentColor};}
.bt_bb_post_grid_loader{
    border-top: 2px solid {$accentColor} !important;
    border-right: 2px solid {$accentColor} !important;}
.bt_bb_post_grid_loader:before,
.bt_bb_post_grid_loader:after{
    border-top: 2px solid {$accentColor} !important;
    border-right: 2px solid {$accentColor} !important;}
.bt_bb_service .bt_bb_service_content .bt_bb_service_content_title{
    font-family: {$headingFont};}
.bt_bb_service .bt_bb_service_content .bt_bb_service_content_title:after{
    background: {$accentColor};}
.bt_bb_service:hover .bt_bb_service_content_title a{color: {$accentColor};}
.slick-slider .slick-dots li:hover:before{color: {$accentColor};}
.bt_bb_tabs .bt_bb_tabs_header{font-family: {$headingFont};}
.bt_bb_tabs.bt_bb_style_simple ul.bt_bb_tabs_header li.on{border-color: {$accentColor};}
.bt_bb_tabs.bt_bb_style_simple ul.bt_bb_tabs_header li:after{
    background: {$accentColor};}
.bt_bb_accordion .bt_bb_accordion_item .bt_bb_accordion_item_title{font-family: {$headingFont};}
.bt_bb_style_simple.bt_bb_accordion .bt_bb_accordion_item .bt_bb_accordion_item_title:after{
    background: {$accentColor};}
.bt_bb_counter_holder{
    font-family: {$headingFont};}
.bt_bb_price_list .bt_bb_price_list_title{
    font-family: {$headingFont};}
.bt_bb_price_list .bt_bb_price_list_title:after{
    background: {$accentColor};}
.bt_bb_price_list .bt_bb_price_list_price .bt_bb_price_list_currency{
    font-family: {$headingFont};}
.bt_bb_price_list .bt_bb_price_list_price .bt_bb_price_list_amount{
    font-family: {$headingFont};}
.wpcf7-form input:not([type='checkbox']):not([type='radio']).wpcf7-submit{
    font-family: {$bodyFont};
    background: {$accentColor};}
div.wpcf7 .btSubscribe p input[type='submit']{
    background: {$accentColor} !important;}
div.wpcf7 .btAlternateSubmit input[type='submit']{
    background: {$alternateColor} !important;}
div.wpcf7 .btNotify input[type='submit']{background: {$accentColor} !important;}
div.wpcf7 .btNotify input[type='submit']:hover{background: {$accentColorDark} !important;}
.bt_bb_masonry_image_grid .bt_bb_grid_item_inner > .bt_bb_grid_item_inner_image:before{
    background: {$accentColor};}
.bt_bb_working_hours_inner_row .bt_bb_working_hours_inner_wrapper .bt_bb_working_hours_inner_link a{background-color: {$accentColor};}
.btCounterHolder{
    font-family: {$headingFont};}
.btCounterHolder .btCountdownHolder span[class$=\"_text\"]{
    font-family: {$bodyFont};}
.bold_timeline_item .bold_timeline_item_inner .bold_timeline_item_header .bold_timeline_item_header_title a:hover{
    color: {$accentColor};}
.bold_timeline_item .bold_timeline_item_inner .bold_timeline_item_header .bold_timeline_item_header_supertitle,
.bold_timeline_item .bold_timeline_item_inner .bold_timeline_item_header .bold_timeline_item_header_subtitle{font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;}
.bold_timeline_item .bold_timeline_item_inner .bold_timeline_item_header .bold_timeline_item_header_supertitle .bold_timeline_item_posts_supertitle_date:before,
.bold_timeline_item .bold_timeline_item_inner .bold_timeline_item_header .bold_timeline_item_header_supertitle .bold_timeline_item_posts_subtitle_date:before,
.bold_timeline_item .bold_timeline_item_inner .bold_timeline_item_header .bold_timeline_item_header_subtitle .bold_timeline_item_posts_supertitle_date:before,
.bold_timeline_item .bold_timeline_item_inner .bold_timeline_item_header .bold_timeline_item_header_subtitle .bold_timeline_item_posts_subtitle_date:before{
    color: {$accentColor};}
.bold_timeline_item .bold_timeline_item_inner .bold_timeline_item_header .bold_timeline_item_header_supertitle .bold_timeline_item_posts_supertitle_date a:hover,
.bold_timeline_item .bold_timeline_item_inner .bold_timeline_item_header .bold_timeline_item_header_supertitle .bold_timeline_item_posts_subtitle_date a:hover,
.bold_timeline_item .bold_timeline_item_inner .bold_timeline_item_header .bold_timeline_item_header_subtitle .bold_timeline_item_posts_supertitle_date a:hover,
.bold_timeline_item .bold_timeline_item_inner .bold_timeline_item_header .bold_timeline_item_header_subtitle .bold_timeline_item_posts_subtitle_date a:hover{
    color: {$accentColor};}
.bold_timeline_item .bold_timeline_item_inner .bold_timeline_item_header .bold_timeline_item_header_supertitle .bold_timeline_item_posts_supertitle_cats:before,
.bold_timeline_item .bold_timeline_item_inner .bold_timeline_item_header .bold_timeline_item_header_supertitle .bold_timeline_item_posts_subtitle_cats:before,
.bold_timeline_item .bold_timeline_item_inner .bold_timeline_item_header .bold_timeline_item_header_subtitle .bold_timeline_item_posts_supertitle_cats:before,
.bold_timeline_item .bold_timeline_item_inner .bold_timeline_item_header .bold_timeline_item_header_subtitle .bold_timeline_item_posts_subtitle_cats:before{
    color: {$accentColor};}
.bold_timeline_item .bold_timeline_item_inner .bold_timeline_item_header .bold_timeline_item_header_supertitle .bold_timeline_item_posts_supertitle_comments:before,
.bold_timeline_item .bold_timeline_item_inner .bold_timeline_item_header .bold_timeline_item_header_supertitle .bold_timeline_item_posts_subtitle_comments:before,
.bold_timeline_item .bold_timeline_item_inner .bold_timeline_item_header .bold_timeline_item_header_subtitle .bold_timeline_item_posts_supertitle_comments:before,
.bold_timeline_item .bold_timeline_item_inner .bold_timeline_item_header .bold_timeline_item_header_subtitle .bold_timeline_item_posts_subtitle_comments:before{
    color: {$accentColor};}
.bold_timeline_item .bold_timeline_item_inner .bold_timeline_item_header .bold_timeline_item_header_supertitle a:hover,
.bold_timeline_item .bold_timeline_item_inner .bold_timeline_item_header .bold_timeline_item_header_subtitle a:hover{
    color: {$accentColor};}
.bold_timeline_item_button{font-family: \"{$bodyFont}\",Arial,Helvetica,sans-serif;}
.products ul li.product .btWooShopLoopItemInner .bt_bb_image:before,
ul.products li.product .btWooShopLoopItemInner .bt_bb_image:before{
    font-family: {$headingFont};}
.products ul li.product .btWooShopLoopItemInner .bt_bb_image:after,
ul.products li.product .btWooShopLoopItemInner .bt_bb_image:after{
    background: {$accentColor};}
.products ul li.product .btWooShopLoopItemInner .bt_bb_headline .bt_bb_headline_content a,
ul.products li.product .btWooShopLoopItemInner .bt_bb_headline .bt_bb_headline_content a{color: {$accentColor};}
.products ul li.product .btWooShopLoopItemInner .price,
ul.products li.product .btWooShopLoopItemInner .price{
    font-family: {$headingFont};}
.products ul li.product .btWooShopLoopItemInner .added:after,
.products ul li.product .btWooShopLoopItemInner .loading:after,
ul.products li.product .btWooShopLoopItemInner .added:after,
ul.products li.product .btWooShopLoopItemInner .loading:after{
    background-color: {$accentColor};}
.products ul li.product .btWooShopLoopItemInner .loading:after,
ul.products li.product .btWooShopLoopItemInner .loading:after{
    background: {$alternateColor};}
.products ul li.product .btWooShopLoopItemInner .added:after,
ul.products li.product .btWooShopLoopItemInner .added:after{
    background: {$alternateColor};}
.products ul li.product .btWooShopLoopItemInner .added_to_cart,
ul.products li.product .btWooShopLoopItemInner .added_to_cart{
    color: {$accentColor};}
.products ul li.product .onsale,
ul.products li.product .onsale{
    background: {$alternateColor};
    font-family: {$headingSuperTitleFont};}
nav.woocommerce-pagination ul li a.next,
nav.woocommerce-pagination ul li a.prev{background: {$accentColor};}
div.product .onsale{
    background: {$alternateColor};
    font-family: {$headingSuperTitleFont};}
div.product div.images .woocommerce-product-gallery__trigger:after{
    background: {$accentColor};}
div.product div.summary .price{
    font-family: {$headingFont};}
table.shop_table .coupon .input-text{
    color: {$accentColor};}
table.shop_table td.product-remove a.remove{
    color: {$accentColor};
    border: 1px solid {$accentColor};}
table.shop_table td.product-remove a.remove:hover{background-color: {$accentColor};}
ul.wc_payment_methods li .about_paypal{
    color: {$accentColor};}
.woocommerce-MyAccount-navigation ul{
    font-family: \"{$menuFont}\";}
.woocommerce-MyAccount-navigation ul li a:after{
    background: {$accentColor};}
form fieldset legend{
    font-family: {$headingFont};}
form .form-row .select2-container.select2-container--open .select2-selection--single{-webkit-box-shadow: 0 2px 5px 0 rgba(0,0,0,.3),0 -2px 0 0 {$accentColor} inset;
    box-shadow: 0 2px 5px 0 rgba(0,0,0,.3),0 -2px 0 0 {$accentColor} inset;}
form .form-row .required{color: {$accentColor};}
.woocommerce-info a:not(.button),
.woocommerce-message a:not(.button){color: {$accentColor};}
.woocommerce-message:before,
.woocommerce-info:before{
    color: {$accentColor};}
.woocommerce .btSidebar a.button,
.woocommerce .btContent a.button,
.woocommerce-page .btSidebar a.button,
.woocommerce-page .btContent a.button,
.woocommerce .btSidebar input[type=\"submit\"],
.woocommerce .btContent input[type=\"submit\"],
.woocommerce-page .btSidebar input[type=\"submit\"],
.woocommerce-page .btContent input[type=\"submit\"],
.woocommerce .btSidebar :not(.widget_product_search) button[type=\"submit\"],
.woocommerce .btContent :not(.widget_product_search) button[type=\"submit\"],
.woocommerce-page .btSidebar :not(.widget_product_search) button[type=\"submit\"],
.woocommerce-page .btContent :not(.widget_product_search) button[type=\"submit\"],
.woocommerce .btSidebar input.button,
.woocommerce .btContent input.button,
.woocommerce-page .btSidebar input.button,
.woocommerce-page .btContent input.button,
div.woocommerce a.button,
div.woocommerce input[type=\"submit\"],
div.woocommerce :not(.widget_product_search) button[type=\"submit\"],
div.woocommerce input.button{
    font-family: {$bodyFont};
    background: {$accentColor};}
.woocommerce .btSidebar input.alt,
.woocommerce .btContent input.alt,
.woocommerce-page .btSidebar input.alt,
.woocommerce-page .btContent input.alt,
.woocommerce .btSidebar a.button.alt,
.woocommerce .btContent a.button.alt,
.woocommerce-page .btSidebar a.button.alt,
.woocommerce-page .btContent a.button.alt,
.woocommerce .btSidebar .button.alt,
.woocommerce .btContent .button.alt,
.woocommerce-page .btSidebar .button.alt,
.woocommerce-page .btContent .button.alt,
.woocommerce .btSidebar button.alt,
.woocommerce .btContent button.alt,
.woocommerce-page .btSidebar button.alt,
.woocommerce-page .btContent button.alt,
div.woocommerce input.alt,
div.woocommerce a.button.alt,
div.woocommerce .button.alt,
div.woocommerce button.alt{
    font-family: {$bodyFont};
    color: {$accentColor};
    -webkit-box-shadow: 0 0 0 2px {$accentColor} inset,0 0 0 rgba(0,0,0,.3);
    box-shadow: 0 0 0 2px {$accentColor} inset,0 0 0 rgba(0,0,0,.3);}
.woocommerce .btSidebar input.alt:hover,
.woocommerce .btContent input.alt:hover,
.woocommerce-page .btSidebar input.alt:hover,
.woocommerce-page .btContent input.alt:hover,
.woocommerce .btSidebar a.button.alt:hover,
.woocommerce .btContent a.button.alt:hover,
.woocommerce-page .btSidebar a.button.alt:hover,
.woocommerce-page .btContent a.button.alt:hover,
.woocommerce .btSidebar .button.alt:hover,
.woocommerce .btContent .button.alt:hover,
.woocommerce-page .btSidebar .button.alt:hover,
.woocommerce-page .btContent .button.alt:hover,
.woocommerce .btSidebar button.alt:hover,
.woocommerce .btContent button.alt:hover,
.woocommerce-page .btSidebar button.alt:hover,
.woocommerce-page .btContent button.alt:hover,
div.woocommerce input.alt:hover,
div.woocommerce a.button.alt:hover,
div.woocommerce .button.alt:hover,
div.woocommerce button.alt:hover{-webkit-box-shadow: 0 0 0 2px {$accentColor} inset,0 2px 5px rgba(0,0,0,.3);
    box-shadow: 0 0 0 2px {$accentColor} inset,0 2px 5px rgba(0,0,0,.3);}
.woocommerce .btSidebar a.edit,
.woocommerce .btContent a.edit,
.woocommerce-page .btSidebar a.edit,
.woocommerce-page .btContent a.edit,
div.woocommerce a.edit{
    font-family: {$headingSuperTitleFont};}
.woocommerce .btSidebar a.edit:before,
.woocommerce .btContent a.edit:before,
.woocommerce-page .btSidebar a.edit:before,
.woocommerce-page .btContent a.edit:before,
div.woocommerce a.edit:before{
    color: {$accentColor};}
.star-rating span:before{
    color: {$accentColor};}
p.stars a[class^=\"star-\"].active:after,
p.stars a[class^=\"star-\"]:hover:after{color: {$accentColor};}
.btQuoteBooking .btContactNext{
    background: {$accentColor};}
.btQuoteBooking .btContactNext:focus,
.btQuoteBooking .btContactNext:hover{-webkit-box-shadow: 0 0 0 2em {$accentColor} inset;
    box-shadow: 0 0 0 2em {$accentColor} inset;}
.btQuoteBooking .btQuoteSwitch.on .btQuoteSwitchInner{
    background: {$accentColor};}
.btQuoteBooking input[type=\"text\"]:focus,
.btQuoteBooking input[type=\"email\"]:focus,
.btQuoteBooking input[type=\"password\"]:focus,
.btQuoteBooking textarea:focus,
.btQuoteBooking .fancy-select .trigger:focus,
.btQuoteBooking .ddcommon.borderRadius .ddTitleText:focus,
.btQuoteBooking .ddcommon.borderRadiusTp .ddTitleText:focus{-webkit-box-shadow: 0 0 4px 0 {$accentColor};
    box-shadow: 0 0 4px 0 {$accentColor};}
.btLightSkin .btQuoteBooking input[type=\"text\"]:focus,
.btDarkSkin .btLightSkin .btQuoteBooking input[type=\"text\"]:focus,
.btLightSkin .btDarkSkin .btLightSkin .btQuoteBooking input[type=\"text\"]:focus,
.btLightSkin .btQuoteBooking input[type=\"email\"]:focus,
.btDarkSkin .btLightSkin .btQuoteBooking input[type=\"email\"]:focus,
.btLightSkin .btDarkSkin .btLightSkin .btQuoteBooking input[type=\"email\"]:focus,
.btLightSkin .btQuoteBooking input[type=\"password\"]:focus,
.btDarkSkin .btLightSkin .btQuoteBooking input[type=\"password\"]:focus,
.btLightSkin .btDarkSkin .btLightSkin .btQuoteBooking input[type=\"password\"]:focus,
.btLightSkin .btQuoteBooking textarea:focus,
.btDarkSkin .btLightSkin .btQuoteBooking textarea:focus,
.btLightSkin .btDarkSkin .btLightSkin .btQuoteBooking textarea:focus,
.btLightSkin .btQuoteBooking .fancy-select .trigger:focus,
.btDarkSkin .btLightSkin .btQuoteBooking .fancy-select .trigger:focus,
.btLightSkin .btDarkSkin .btLightSkin .btQuoteBooking .fancy-select .trigger:focus,
.btLightSkin .btQuoteBooking .ddcommon.borderRadius .ddTitleText:focus,
.btDarkSkin .btLightSkin .btQuoteBooking .ddcommon.borderRadius .ddTitleText:focus,
.btLightSkin .btDarkSkin .btLightSkin .btQuoteBooking .ddcommon.borderRadius .ddTitleText:focus,
.btLightSkin .btQuoteBooking .ddcommon.borderRadiusTp .ddTitleText:focus,
.btDarkSkin .btLightSkin .btQuoteBooking .ddcommon.borderRadiusTp .ddTitleText:focus,
.btLightSkin .btDarkSkin .btLightSkin .btQuoteBooking .ddcommon.borderRadiusTp .ddTitleText:focus{
    -webkit-box-shadow: 0 2px 5px 0 rgba(0,0,0,.3),0 -2px 0 0 {$accentColor} inset;
    box-shadow: 0 2px 5px 0 rgba(0,0,0,.3),0 -2px 0 0 {$accentColor} inset;}
.btDarkSkin .btQuoteBooking input[type=\"text\"]:focus,
.btLightSkin .btDarkSkin .btQuoteBooking input[type=\"text\"]:focus,
.btDarkSkin.btLightSkin .btDarkSkin .btQuoteBooking input[type=\"text\"]:focus,
.bt_bb_color_scheme_1 .btQuoteBooking input[type=\"text\"]:focus,
.bt_bb_color_scheme_3 .btQuoteBooking input[type=\"text\"]:focus,
.btDarkSkin .btQuoteBooking input[type=\"email\"]:focus,
.btLightSkin .btDarkSkin .btQuoteBooking input[type=\"email\"]:focus,
.btDarkSkin.btLightSkin .btDarkSkin .btQuoteBooking input[type=\"email\"]:focus,
.bt_bb_color_scheme_1 .btQuoteBooking input[type=\"email\"]:focus,
.bt_bb_color_scheme_3 .btQuoteBooking input[type=\"email\"]:focus,
.btDarkSkin .btQuoteBooking input[type=\"password\"]:focus,
.btLightSkin .btDarkSkin .btQuoteBooking input[type=\"password\"]:focus,
.btDarkSkin.btLightSkin .btDarkSkin .btQuoteBooking input[type=\"password\"]:focus,
.bt_bb_color_scheme_1 .btQuoteBooking input[type=\"password\"]:focus,
.bt_bb_color_scheme_3 .btQuoteBooking input[type=\"password\"]:focus,
.btDarkSkin .btQuoteBooking textarea:focus,
.btLightSkin .btDarkSkin .btQuoteBooking textarea:focus,
.btDarkSkin.btLightSkin .btDarkSkin .btQuoteBooking textarea:focus,
.bt_bb_color_scheme_1 .btQuoteBooking textarea:focus,
.bt_bb_color_scheme_3 .btQuoteBooking textarea:focus,
.btDarkSkin .btQuoteBooking .fancy-select .trigger:focus,
.btLightSkin .btDarkSkin .btQuoteBooking .fancy-select .trigger:focus,
.btDarkSkin.btLightSkin .btDarkSkin .btQuoteBooking .fancy-select .trigger:focus,
.bt_bb_color_scheme_1 .btQuoteBooking .fancy-select .trigger:focus,
.bt_bb_color_scheme_3 .btQuoteBooking .fancy-select .trigger:focus,
.btDarkSkin .btQuoteBooking .ddcommon.borderRadius .ddTitleText:focus,
.btLightSkin .btDarkSkin .btQuoteBooking .ddcommon.borderRadius .ddTitleText:focus,
.btDarkSkin.btLightSkin .btDarkSkin .btQuoteBooking .ddcommon.borderRadius .ddTitleText:focus,
.bt_bb_color_scheme_1 .btQuoteBooking .ddcommon.borderRadius .ddTitleText:focus,
.bt_bb_color_scheme_3 .btQuoteBooking .ddcommon.borderRadius .ddTitleText:focus,
.btDarkSkin .btQuoteBooking .ddcommon.borderRadiusTp .ddTitleText:focus,
.btLightSkin .btDarkSkin .btQuoteBooking .ddcommon.borderRadiusTp .ddTitleText:focus,
.btDarkSkin.btLightSkin .btDarkSkin .btQuoteBooking .ddcommon.borderRadiusTp .ddTitleText:focus,
.bt_bb_color_scheme_1 .btQuoteBooking .ddcommon.borderRadiusTp .ddTitleText:focus,
.bt_bb_color_scheme_3 .btQuoteBooking .ddcommon.borderRadiusTp .ddTitleText:focus{
    -webkit-box-shadow: 0 2px 5px 0 rgba(0,0,0,.3),0 -2px 0 0 {$accentColor} inset;
    box-shadow: 0 2px 5px 0 rgba(0,0,0,.3),0 -2px 0 0 {$accentColor} inset;}
.btQuoteBooking .dd.ddcommon.borderRadiusTp .ddTitleText,
.btQuoteBooking .dd.ddcommon.borderRadiusBtm .ddTitleText{
    -webkit-box-shadow: 5px 0 0 {$accentColor} inset,0 2px 10px rgba(0,0,0,.2);
    box-shadow: 5px 0 0 {$accentColor} inset,0 2px 10px rgba(0,0,0,.2);}
.btQuoteBooking .ui-slider .ui-slider-handle{
    background: {$accentColor};}
.btQuoteBooking .btQuoteBookingForm .btQuoteTotal{
    background: {$accentColor};}
.btQuoteBooking .btQuoteTotalCurrency{
    font-family: {$headingFont};}
.btQuoteBooking .btQuoteTotalCalc{
    font-family: {$headingFont};}
.btQuoteBooking .btContactFieldMandatory.btContactFieldError input,
.btQuoteBooking .btContactFieldMandatory.btContactFieldError textarea{-webkit-box-shadow: 0 0 0 1px {$accentColor} inset;
    box-shadow: 0 0 0 1px {$accentColor} inset;
    border-color: {$accentColor};}
.btQuoteBooking .btContactFieldMandatory.btContactFieldError .dd.ddcommon.borderRadius .ddTitleText{-webkit-box-shadow: 0 0 0 2px {$accentColor} inset;
    box-shadow: 0 0 0 2px {$accentColor} inset;}
.btQuoteBooking .btSubmitMessage{color: {$accentColor};}
.btDatePicker .ui-datepicker-header{
    background-color: {$accentColor};}
.btQuoteBooking .ddChild ul li:hover,
.btQuoteBooking .ddChild ul li.selected:hover{color: {$accentColor};}
.btQuoteBooking .dd.ddcommon.borderRadiusTp .ddTitleText,
.btQuoteBooking .dd.ddcommon.borderRadiusBtm .ddTitleText{
    -webkit-box-shadow: 0 2px 5px 0 rgba(0,0,0,.3),0 -2px 0 0 {$accentColor} inset;
    box-shadow: 0 2px 5px 0 rgba(0,0,0,.3),0 -2px 0 0 {$accentColor} inset;}
.btQuoteBooking .btContactSubmit{
    background: {$accentColor};}
.btQuoteBooking .btContactSubmit:focus,
.btQuoteBooking .btContactSubmit:hover{-webkit-box-shadow: 0 0 0 2em {$accentColor} inset;
    box-shadow: 0 0 0 2em {$accentColor} inset;}
.btPayPalButton:hover{-webkit-box-shadow: 0 0 0 {$accentColor} inset,0 1px 5px rgba(0,0,0,.2);
    box-shadow: 0 0 0 {$accentColor} inset,0 1px 5px rgba(0,0,0,.2);}
.bt_cc_email_confirmation_container [type=\"checkbox\"]:checked + label:before{border-color: {$accentColor};
    background: {$accentColor};}
.wp-block-button__link:hover{color: {$accentColor} !important;}
", array() );