<?php

class bt_bb_headline extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'ai_prompt'     => '',
			'headline'      => '',
			'html_tag'      => '',
			'font'          => '',
			'font_subset'   => '',
			'size'     		=> '',
			'font_size'     => '',
			'font_weight'   => '',
			'color_scheme'  => '',
			'color'         => '',
			'supertitle_position'   => '',
			'dash'          => '',
			'align'         => '',
			'url'           => '',
			'target'        => '',
			'superheadline' => '',
			'subheadline'   => ''
		) ), $atts, $this->shortcode ) );

		$superheadline = html_entity_decode( $superheadline, ENT_QUOTES, 'UTF-8' );
		$subheadline = html_entity_decode( $subheadline, ENT_QUOTES, 'UTF-8' );
		$headline = html_entity_decode( $headline, ENT_QUOTES, 'UTF-8' );

		if ( $font != '' && $font != 'inherit' ) {
			require_once( dirname(__FILE__) . '/../../../../../plugins/bold-page-builder/content_elements_misc/misc.php' );
			bt_bb_enqueue_google_font( $font, $font_subset );
		}

		$class = array( $this->shortcode );
		
		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}
		
		$html_tag_style = "";
		if ( $font != '' && $font != 'inherit' ) {
			$el_style = $el_style . ';' . 'font-family:\'' . urldecode( $font ) . '\'';
			$html_tag_style .= ';font-family:\'' . urldecode( $font ) . '\'';
		}
		if ( $font_size != '' ) {
			$html_tag_style .= ' ' . ';font-size:' . $font_size ;
		}
		if ( $html_tag_style != "" ) {
			$html_tag_style = " style=\"" . $html_tag_style . "\"";
		}
		
		if ( $font_weight != '' ) {
			$class[] = $this->prefix . 'font_weight_' . $font_weight ;
		}
		
		$color_scheme_id = NULL;
		if ( is_numeric ( $color_scheme ) ) {
			$color_scheme_id = $color_scheme;
		} else if ( $color_scheme != '' ) {
			$color_scheme_id = bt_bb_get_color_scheme_id( $color_scheme );
		}
		$color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $color_scheme_id - 1 );
		if ( $color_scheme_colors ) $el_style .= '; --primary-color:' . $color_scheme_colors[0] . '; --secondary-color:' . $color_scheme_colors[1] . ';';
		if ( $color_scheme != '' ) $class[] = $this->prefix . 'color_scheme_' .  $color_scheme_id;

		if ( $color != '' ) {
			$el_style = $el_style . ';' . 'color:' . $color . ';border-color:' . $color . ';';
		}

		if ( $dash != '' ) {
			$class[] = $this->prefix . 'dash' . '_' . $dash;
		}
		
		if ( $target == '' ) {
			$target = '_self';
		}

		$superheadline_inside = '';
		$superheadline_outside = '';

		if ( $superheadline != '' ) {
			$class[] = $this->prefix . 'superheadline';
			if ( $supertitle_position == 'outside' ) { 
				$superheadline_outside = '<span class="' . esc_attr( $this->shortcode ) . '_superheadline">' . $superheadline . '</span>';
			} else {
				$superheadline_inside = '<span class="' . esc_attr( $this->shortcode ) . '_superheadline">' . $superheadline . '</span>';
			}
			
		}
		
		if ( $subheadline != '' ) {
			$class[] = $this->prefix . 'subheadline';
			$subheadline = '<div class="' . esc_attr( $this->shortcode . '_subheadline' ) . '">' . $subheadline . '</div>';
			$subheadline = nl2br( $subheadline );
		}
		

		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}

		$this->responsive_data_override_class(
			$class, $data_override_class,
			array(
				'prefix' => $this->prefix,
				'param' => 'size',
				'value' => $size
			)
		);

		$this->responsive_data_override_class(
			$class, $data_override_class,
			array(
				'prefix' => $this->prefix,
				'param' => 'align',
				'value' => $align
			)
		);

		$class = apply_filters( $this->shortcode . '_class', $class, $atts );
		
		if ( $headline != '' ) {
			if ( $url != '' ) {
				$url_title = strip_tags( str_replace( array("\n", "\r"), ' ', $headline ) );
				$link = bt_bb_get_url( $url );
				$headline = '<a href="' . esc_attr( $link ) . '" target="' . esc_attr( $target ) . '" title="' . esc_attr( $url_title )  . '">' . $headline . '</a>';
			}		
			$headline = '<span class="' . esc_attr( $this->shortcode . '_content' ) . '"><span>' . $headline . '</span></span>';			
		}
		
		$headline = nl2br( $headline );

		$output = '<header' . $id_attr . ' class="' . implode( ' ', $class ) . '"' . $style_attr . ' data-bt-override-class="' . htmlspecialchars( json_encode( $data_override_class, JSON_FORCE_OBJECT ), ENT_QUOTES, 'UTF-8' ) . '">';
		if ( $superheadline_outside != '' ) $output .= '<div class="' . esc_attr( $this->shortcode . '_superheadline_outside' ) . '">' . $superheadline_outside . '</div>';
		if ( $headline != '' || $superheadline_inside != '' ) $output .= '<' . $html_tag . $html_tag_style . '>' . $superheadline_inside . $headline . '</' . $html_tag . '>';
		$output .= $subheadline . '</header>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;

	}

	function map_shortcode() {

		require_once( dirname(__FILE__) . '/../../../../../plugins/bold-page-builder/content_elements_misc/fonts.php' );
		$color_scheme_arr = bt_bb_get_color_scheme_param_array();	

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Headline', 'celeste' ), 'description' => esc_html__( 'Headline with custom Google fonts (and AI help)', 'celeste' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode, 'highlight' => true,
			'params' => array(
				array(
					'param_name' => 'ai_prompt',
					'type' => 'ai_prompt',
					'target' =>
						array(
							'superheadline' => array( 'alias' => 'supertitle', 'title' => esc_html__( 'Superheadline', 'celeste' ) ),
							'headline' => array( 'alias' => 'title', 'title' => esc_html__( 'Headline', 'celeste' ) ),
							'subheadline' => array( 'alias' => 'subtitle', 'title' => esc_html__( 'Subheadline', 'celeste' ) ),
						),
					'system_prompt' => 'You are a copywriter and your goal is to help users generate website content. Based on the user prompt generate supertitle, title and subtitle for the website page.',
				),
				array( 'param_name' => 'superheadline', 'type' => 'textfield', 'heading' => esc_html__( 'Superheadline', 'celeste' ) ),
				array( 'param_name' => 'headline', 'type' => 'textarea', 'heading' => esc_html__( 'Headline', 'celeste' ), 'preview' => true, 'preview_strong' => true ),
				array( 'param_name' => 'subheadline', 'type' => 'textarea', 'heading' => esc_html__( 'Subheadline', 'celeste' ) ),
				array( 'param_name' => 'html_tag', 'type' => 'dropdown', 'heading' => esc_html__( 'HTML tag', 'celeste' ), 'preview' => true,
					'value' => array(
						esc_html__( 'h1', 'celeste' ) => 'h1',
						esc_html__( 'h2', 'celeste' ) => 'h2',
						esc_html__( 'h3', 'celeste' ) => 'h3',
						esc_html__( 'h4', 'celeste' ) => 'h4',
						esc_html__( 'h5', 'celeste' ) => 'h5',
						esc_html__( 'h6', 'celeste' ) => 'h6'
				) ),
				array( 'param_name' => 'size', 'type' => 'dropdown', 'heading' => esc_html__( 'Size', 'celeste' ), 'description' => 'Predefined heading sizes, independent of html tag', 'responsive_override' => true,
					'value' => array(
						esc_html__( 'Inherit', 'celeste' ) => 'inherit',
						esc_html__( 'Extra Small', 'celeste' ) => 'extrasmall',
						esc_html__( 'Small', 'celeste' ) => 'small',
						esc_html__( 'Medium', 'celeste' ) => 'medium',
						esc_html__( 'Normal', 'celeste' ) => 'normal',
						esc_html__( 'Large', 'celeste' ) => 'large',
						esc_html__( 'Extra large', 'celeste' ) => 'extralarge',
						esc_html__( 'Huge', 'celeste' ) => 'huge'
					)
				),				
				array( 'param_name' => 'align', 'type' => 'dropdown', 'heading' => esc_html__( 'Alignment', 'celeste' ), 'responsive_override' => true,
					'value' => array(
						esc_html__( 'Inherit', 'celeste' ) => 'inherit',
						esc_html__( 'Center', 'celeste' ) => 'center',
						esc_html__( 'Left', 'celeste' ) => 'left',
						esc_html__( 'Right', 'celeste' ) => 'right'
					)
				),
				array( 'param_name' => 'dash', 'type' => 'dropdown', 'heading' => esc_html__( 'Dash', 'celeste' ), 'group' => esc_html__( 'Design', 'celeste' ),
					'value' => array(
						esc_html__( 'None', 'celeste' ) => 'none',
						esc_html__( 'Top', 'celeste' ) => 'top',
						esc_html__( 'Bottom', 'celeste' ) => 'bottom',
						esc_html__( 'Top and bottom', 'celeste' ) => 'top_bottom'
					)
				),
				array( 'param_name' => 'color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Color scheme', 'celeste' ), 'group' => esc_html__( 'Design', 'celeste' ), 'value' => $color_scheme_arr, 'preview' => true ),
				array( 'param_name' => 'color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Color', 'celeste' ), 'group' => esc_html__( 'Design', 'celeste' ), 'preview' => true ),
				array( 'param_name' => 'supertitle_position', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'celeste' ) => 'outside' ), 'heading' => esc_html__( 'Put supertitle outside H tag', 'celeste' ), 'group' => esc_html__( 'Design', 'celeste' ), 'preview' => true ),
				array( 'param_name' => 'font', 'type' => 'dropdown', 'heading' => esc_html__( 'Font', 'celeste' ), 'group' => esc_html__( 'Font', 'celeste' ), 'preview' => true,
					'value' => array( esc_html__( 'Inherit', 'celeste' ) => 'inherit' ) + $font_arr
				),
				array( 'param_name' => 'font_subset', 'type' => 'textfield', 'heading' => esc_html__( 'Font subset', 'celeste' ), 'group' => esc_html__( 'Font', 'celeste' ), 'value' => 'latin,latin-ext', 'description' => 'E.g. latin,latin-ext,cyrillic,cyrillic-ext' ),
				array( 'param_name' => 'font_size', 'type' => 'textfield', 'heading' => esc_html__( 'Custom font size', 'celeste' ), 'group' => esc_html__( 'Font', 'celeste' ), 'description' => 'E.g. 20px or 1.5rem' ),
				array( 'param_name' => 'font_weight', 'type' => 'dropdown', 'heading' => esc_html__( 'Font weight', 'celeste' ), 'group' => esc_html__( 'Font', 'celeste' ),
					'value' => array(
						esc_html__( 'Default', 'celeste' ) => '',
						esc_html__( 'Normal', 'celeste' ) => 'normal',
						esc_html__( 'Bold', 'celeste' ) => 'bold',
						esc_html__( 'Bolder', 'celeste' ) => 'bolder',
						esc_html__( 'Lighter', 'celeste' ) => 'lighter',
						esc_html__( 'Light', 'celeste' ) => 'light',
						esc_html__( 'Thin', 'celeste' ) => 'thin'
					)
				),
				array( 'param_name' => 'url', 'type' => 'textfield', 'heading' => esc_html__( 'URL', 'celeste' ), 'group' => esc_html__( 'URL', 'celeste' ) ),
				array( 'param_name' => 'target', 'type' => 'dropdown', 'heading' => esc_html__( 'Target', 'celeste' ), 'group' => esc_html__( 'URL', 'celeste' ),
					'value' => array(
						esc_html__( 'Self (open in same tab)', 'celeste' ) => '_self',
						esc_html__( 'Blank (open in new tab)', 'celeste' ) => '_blank'
					)
				)
			)
		) );
	}
}