<?php
/**
 * Multi-currency utils.
 *
 * @since 5.3.4
 * @package WC_BOGOF
 */

defined( 'ABSPATH' ) || exit;

/**
 * WC_BOGOF_Util_Multi_Currency Trait
 */
trait WC_BOGOF_Util_Multi_Currency {

	/**
	 * Convert the amount to the shop base currency is multicurrency is enable.
	 *
	 * @since 5.1.3
	 * @param double $amount Amount to filter.
	 */
	protected function multicurrency_to_base( $amount ) {
		return class_exists( 'WC_BOGOF_Multi_Currency' ) ? WC_BOGOF_Multi_Currency::to_base( $amount ) : $amount;
	}
}
