<?php
/**
 * Functions to build a simple structure to encapsulate data.
 *
 * @since 5.1.0
 * @package WC_BOGOF
 */

defined( 'ABSPATH' ) || exit;

/**
 * WC_BOGOF_Data_Properties Trait
 */
trait WC_BOGOF_Data_Properties {

	/**
	 * Array of properties.
	 *
	 * @var array
	 */
	protected $data = [];

	/**
	 * Array of key value to map setter method with data keys.
	 *
	 * @var array
	 */
	protected $key_to_prop_setter = [];

	/**
	 * Set a collection of props in one go. Only sets using public methods.
	 *
	 * @param array $props Key value pairs to set. Key is the prop and should map to a setter function name.
	 */
	public function set_properties( $props ) {
		foreach ( $props as $prop => $value ) {
			$setter = isset( $this->key_to_prop_setter[ $prop ] ) ? $this->key_to_prop_setter[ $prop ] : "set_$prop";
			if ( method_exists( $this, $setter ) ) {
				$this->{$setter}( $value );
			}
		}
	}

	/**
	 * Sets a single property.
	 *
	 * @param string $prop Property.
	 * @param mixed  $value Value.
	 */
	protected function set_property( $prop, $value ) {
		if ( isset( $this->data[ $prop ] ) && $this->data[ $prop ] !== $value ) {
			$this->data[ $prop ] = $value;
		}
	}

	/**
	 * Gets a single property.
	 *
	 * @param string $prop Property.
	 * @return mixed
	 */
	protected function get_property( $prop ) {
		return isset( $this->data[ $prop ] ) ? $this->data[ $prop ] : null;
	}

	/**
	 * Returns all data as an array.
	 *
	 * @return array
	 */
	public function get_data() {
		return $this->data;
	}
}
