<?php
/**
 * Buy One Get One Free - Handle compatiblity issues with Smart Coupons
 *
 * @see https://woocommerce.com/products/smart-coupons/
 * @since 5.3.3
 * @package WC_BOGOF
 */

defined( 'ABSPATH' ) || exit;

/**
 * WC_BOGOF_Smart_Coupons Class
 */
class WC_BOGOF_Smart_Coupons {

	/**
	 * Init integration.
	 */
	public static function init() {
		add_action( 'wc_bogof_after_calculate_totals', [ __CLASS__, 'reset_credit' ] );
	}

	/**
	 * Checks if apply before tax is enabled.
	 *
	 * @return bool
	 */
	private static function is_apply_before_tax_enable() {
		return class_exists( 'WC_SC_Apply_Before_Tax' ) &&
			is_callable( [ 'WC_SC_Apply_Before_Tax', 'get_instance' ] ) &&
			is_callable( [ WC_SC_Apply_Before_Tax::get_instance(), 'cart_reset_credit_left' ] ) &&
			is_callable( [ WC_SC_Apply_Before_Tax::get_instance(), 'cart_calculate_discount_amount' ] );
	}

	/**
	 * Resets the WC_SC_Apply_Before_Tax vars.
	 */
	public static function reset_credit() {
		if ( ! self::is_apply_before_tax_enable() ) {
			return;
		}
		WC_SC_Apply_Before_Tax::get_instance()->cart_reset_credit_left();
		WC_SC_Apply_Before_Tax::get_instance()->cart_calculate_discount_amount();
	}
}

