<?php
/**
 * Condition customer is logged in class.
 *
 * @since 5.1.0
 * @package WC_BOGOF
 */

defined( 'ABSPATH' ) || exit;

/**
 * WC_BOGOF_Condition_Customer_Role Class
 */
class WC_BOGOF_Condition_Customer_Role extends WC_BOGOF_Abstract_Condition {
	use WC_BOGOF_Condition_Array;

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->id       = 'customer_role';
		$this->title    = sprintf(
			'%s - %s',
			__( 'Customer', 'wc-buy-one-get-one-free' ),
			__( 'User role', 'wc-buy-one-get-one-free' )
		);
		$this->supports = array( '_conditions' );
	}

	/**
	 * Returns the "options" of the metabox field.
	 *
	 * @return array
	 */
	protected function get_metabox_field_options() {
		return wp_list_pluck( get_editable_roles(), 'name' );
	}

	/**
	 * Evaluate a condition field.
	 *
	 * @param array $data   Condition field data.
	 * @param mixed $value  Value to check.
	 * @return boolean
	 */
	public function check_condition( $data, $value = null ) {
		$data  = $this->sanitize( $data );
		$roles = is_array( $data['value'] ) ? $data['value'] : [];

		return $this->validate( $this->get_user_roles(), $roles, $data['modifier'] );
	}

	/**
	 * Returns the current user roles.
	 */
	protected function get_user_roles() {
		$user = wp_get_current_user();
		return ( $user->ID ? $user->roles : [] );
	}
}

