<?php
/**
 * Condition cart item subtotal class.
 *
 * @since 5.1.0
 * @package WC_BOGOF
 */

defined( 'ABSPATH' ) || exit;

/**
 * WC_BOGOF_Condition_Cart_Subtotal Class
 */
class WC_BOGOF_Condition_Cart_Subtotal extends WC_BOGOF_Abstract_Condition {
	use WC_BOGOF_Condition_Price { get_value_metabox_field as protected _get_value_metabox_field; }

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->id       = 'cart_subtotal';
		$this->title    = sprintf(
			'%s - %s',
			__( 'Cart', 'wc-buy-one-get-one-free' ),
			__( 'Subtotal (after discount coupons)', 'wc-buy-one-get-one-free' )
		);
		$this->supports = array( '_conditions' );
	}

	/**
	 * Returns an array with the proprerties of the metabox field.
	 *
	 * @return array
	 */
	public function get_value_metabox_field() {
		$field = $this->_get_value_metabox_field();
		$field['custom_attributes']['data-info-tooltips'] = wp_json_encode(
			[
				[
					'message' => __( 'The cart subtotal after applying the discount of coupons.', 'wc-buy-one-get-one-free' ),
				],
			]
		);

		return $field;
	}

	/**
	 * Evaluate a condition field.
	 *
	 * @param array $data   Condition field data.
	 * @param mixed $value  Value to check.
	 * @return boolean
	 */
	public function check_condition( $data, $value = null ) {
		$data     = $this->sanitize( $data );
		$subtotal = WC_BOGOF_Cart_Totals::instance()->get_subtotal();

		return $this->validate( $subtotal, $data['value'], $data['modifier'] );
	}

}
