<?php
/**
 * Item Discount Data class. Encapsulate a item discount.
 *
 * @since 5.5.3
 * @package WC_BOGOF
 */

defined( 'ABSPATH' ) || exit;

/**
 * WC_BOGOF_Data_Item_Discount Class
 */
class WC_BOGOF_Data_Item_Discount {

	use WC_BOGOF_Data_Properties;

	/**
	 * Constructor.
	 *
	 * @param array $data Array of properties to set.
	 */
	public function __construct( $data = [] ) {
		$this->set_defaults();
		$this->set_properties( $data );
	}

	/**
	 * Sets defaults.
	 */
	protected function set_defaults() {
		$this->data = [
			'discount' => new WC_BOGOF_Data_Discount(),
			'quantity' => 0,
		];
	}

	/**
	 * Sets the discount.
	 *
	 * @param WC_BOGOF_Data_Discount|array $discount Discount instance or array with discount properties.
	 */
	public function set_discount( $discount ) {
		if ( is_array( $discount ) ) {
			$this->set_property( 'discount', new WC_BOGOF_Data_Discount( $discount ) );
		} elseif ( is_a( $discount, 'WC_BOGOF_Data_Discount' ) ) {
			$this->set_property( 'discount', $discount );
		}
	}

	/**
	 * Sets the quantity.
	 *
	 * @param int $quantity Quantity.
	 */
	public function set_quantity( $quantity ) {
		$this->set_property( 'quantity', absint( $quantity ) );
	}

	/**
	 * Gets the discount instance.
	 *
	 * @return WC_BOGOF_Data_Discount
	 */
	public function get_discount() {
		return $this->get_property( 'discount' );
	}

	/**
	 * Gets the quantity.
	 *
	 * @return int
	 */
	public function get_quantity() {
		return $this->get_property( 'quantity' );
	}

	/**
	 * Returns all data as an array.
	 *
	 * @return array
	 */
	public function get_data() {
		return [
			'discount' => $this->get_discount()->get_data(),
			'quantity' => $this->get_quantity(),
		];
	}
}
