import $ from "jquery"
/**
 * Class FaqTab
 */
export default class FaqTab {
  /**
   * Run when the document is ready.
   *
   * @return {void}
   */

  constructor() {
    this.cache()
  }

  cache() {
    this.bwlFaqTabs = $(".bwl-faq-tabs")
  }

  switchTabs(obj) {
    obj.parent().parent().find(".bwl-faq-tab-content").slideUp("fast")

    obj.parent().find("li").removeClass("active").removeAttr("class")

    var id = obj.find("a", 0).attr("rel")

    $("#" + id).slideDown("slow")

    obj.addClass("active")
  }

  docReady() {
    if (this.bwlFaqTabs.length === 0) return ""

    this.renderFaqTabs()
  }

  renderFaqTabs() {
    this.bwlFaqTabs.find("li").on("click", (event) => {
      event.preventDefault()
      if ($(event.currentTarget).find(".bwl-faq-link").attr("class") != "bwl-faq-link") {
        this.switchTabs($(event.currentTarget))
      }
    })
  }
}
