import $ from "jquery"
/**
 * Class AboutTab
 */
export default class AboutTab {
  /**
   * Run when the document is ready.
   *
   * @return {void}
   */

  constructor() {
    this.cache()
  }

  cache() {
    this.aboutContainer = $(".baf-about-container")
  }

  docReady() {
    if (this.aboutContainer.length === 0) return ""

    this.renderAboutTab()
  }

  renderAboutTab() {
    const $navTabWrapper = $(".nav-tab-wrapper")
    const $navTab = $navTabWrapper.find(".nav-tab")
    $(document).on("click", ".nav-tab", (event) => {
      event.preventDefault()

      $navTab.removeClass("nav-tab-active")
      $(event.currentTarget).addClass("nav-tab-active")

      let tabId = $(event.currentTarget).attr("href")
      this.aboutContainer.find(".tab-content").hide()
      $(tabId).show()
    })

    // Show the first tab by default
    $navTab.eq(0).trigger("click")
  }
}
