<div class="wrap baf-about-wrap">

    <h2>BWL Advanced FAQ Manager (<?php echo get_option( BWL_ADVANCED_FAQ_VERSION_KEY ); ?>)</h2>

    <div class="baf-about-container">
    <h2 class="nav-tab-wrapper">
        <a href="#baf-getting-started" class="nav-tab nav-tab-active">Getting Started</a>
        <a href="#baf-documentation" class="nav-tab">Documentation</a>
        <a href="#baf-support" class="nav-tab">Support</a>
    </h2>
    <div id="baf-getting-started" class="tab-content">
        <h2>Getting Started</h2>
        <ul class="tab-content__steps">

        <?php
        $steps = [
            [
				'title' => 'Add a new faq post. Repeat this steps to create your required faqs.',
				'img'   => '1_add_a_new_faq_post.jpg',
            ],
            [
				'title' => "Navigate to any page. From the top of the screen, click the (+) icon and search for 'classic' block.",
				'img'   => '2_add_classic_editor_block.png',
            ],
            [
				'title' => 'Now, you can use the classic editor block. Click the (?) icon from the editor.',
				'img'   => '3_click_shortcode_editor_button.png',
            ],
            [
				'title' => "Change the settings according to your requirement and click 'insert' button.",
				'img'   => '4_insert_shortcode.png',
            ],
            [
				'title' => 'Save or update the page.',
				'img'   => '5_save_the_post.png',
            ],
            [
				'title' => 'Congratulations! your FAQs are ready to display for the users.',
				'img'   => '6_frontend_output.png',
            ],
        ];

        foreach ( $steps as $key => $step ) {
			?>

        <li>
            <p><span class="step_tag">Step <?php echo ++$key; ?>:</span> <?php echo $step['title']; ?></p>
            <img src="<?php echo BWL_BAFM_PLUGIN_LIBS_DIR . 'plugin-info/getting-started/' . $step['img']; ?>"
            alt="<?php echo $step['title']; ?>">
        </li>

			<?php

        }
        ?>

        </ul>
        <a href="<?php echo admin_url( 'post-new.php?post_type=bwl_advanced_faq' ); ?>" class="button button-primary">Create
        your first FAQ
        post</a>
    </div>
    <div id="baf-documentation" class="tab-content" style="display:none;">
        <h2>Documentation</h2>
        <p>You can check the plugin full documentation from <a
            href="https://xenioushk.github.io/docs-wp-plugins/baf/index.html" target="_blank">here</a>.</p>
    </div>
    <div id="baf-support" class="tab-content" style="display:none;">
        <h2>Support</h2>
        <p>
        Advanced FAQ Manager WordPress Plugin offers Six (06) months of premium support directly from the developer. We
        are committed to assisting our buyers, and most of the time, it takes less than 24 hours to reply to the support
        message. If you face any particular FAQ plugin issue, the developer will assist you in fixing the problem.
        Please send your support message via
        <a href="https://codecanyon.net/item/bwl-advanced-faq-manager/5007135/support/contact" target="_blank">support
            form</a>.
        </p>
    </div>
    </div>


</div>
