<?php

/**
 * Initializes the BwlFaqManager plugin.
 *
 * @package BwlFaqManager
 */
namespace BwlFaqManager;

/**
 * Class Init
 *
 * Initializes and registers all the services for the BwlFaqManager plugin.
 *
 * @package BwlFaqManager
 */
class Init {

	/**
     * Retrieves the list of services to be registered
     *
     * @since 2.0.6
     */
	public static function get_services() {

		// List all the required classes for the plugin
		return [
			Base\AboutPluginRedirect::class,
			Controllers\Shortcodes\FaqSearchBox::class,
			Controllers\Shortcodes\FaqList::class,
			Controllers\Shortcodes\FaqAuthor::class,
			Controllers\Shortcodes\FaqSortedList::class,
			Controllers\Shortcodes\FaqExternalForm::class,
			Controllers\Shortcodes\FaqTabs::class,
			Controllers\ExternalFaqForm\FaqSubmissionHandler::class,
			Controllers\Themes\FaqCustomThemes::class,
			Controllers\Votes\FaqVotes::class,
			Controllers\DashboardWidgets\PluginDashboardWidgets::class,
			Controllers\Metainfo\BafMetaInfo::class,
			Controllers\Cpt\BafCptCustomColumns::class,
			Controllers\Cpt\BafQuickBulkEdit::class,
			Controllers\Cpt\BafCptTaxonomyFilters::class,
			Controllers\TaxonomySort\BafTaxonomySort::class,
		];
	}

	/**
	 * Registered all the classes.
	 *
	 * @since 2.0.6
	 */
	public static function register_services() {

		foreach ( self::get_services() as $service ) {

			$service = self::instantiate( $service );

			if ( method_exists( $service, 'register' ) ) {
				$service->register();
			}
		}
	}

	/**
	 * Instantiate all the registered classes.
	 *
	 * @since 2.0.6
	 * @param string $class_name The name of the class to instantiate.
	 */
	private static function instantiate( $class_name ) {
		return new $class_name();
	}
}
