<?php

/**
 * @package BwlFaqManager
 */

namespace BwlFaqManager\Helpers;

class FaqColorScheme {

	public function __construct() {
	}


	/**
	 * @Description: Custom Theme Style integrate for FAQ
	 * @Created At: 04-07-2013
	 * @Last Edited AT: 22-03-2018
	 * @Created By: Mahbub
	 * @Note: If $preset value is 1, then we're going to skip $enable_custom_theme value.
	 **/
	function baf_get_theme_color_scheme( $theme_id, $preset = 0 ) {

		$bwl_advanced_faq_options = get_option( 'bwl_advanced_faq_options' );

		$enable_custom_theme = 0;

		// Added $preset in version 1.6.7
		// This will allow us to show FAQ preset theme, although user enable_custom_theme option.
		if ( isset( $bwl_advanced_faq_options['enable_custom_theme'] ) && $bwl_advanced_faq_options['enable_custom_theme'] == 'on' && $preset == 0 ) {

			$enable_custom_theme = 1;
		}

		if ( $theme_id == 'light' && $enable_custom_theme == 0 ) {

			// LIGHT COLOR SCHEME.
			$gradient_first_color    = '#F7F7F7';
			$gradient_second_color   = '#FAFAFA';
			$active_background_color = '#F7F7F7';
			$label_text_color        = '#555555';
			$hover_background        = '#FFFFFF';
			$label_hover_text_color  = '#3a3a3a';
			$tab_top_border          = '#2C2C2C';
		} elseif ( $theme_id == 'red' && $enable_custom_theme == 0 ) {

			// RED COLOR SCHEME.

			$gradient_first_color    = '#FF3019';
			$gradient_second_color   = '#CF0404';
			$active_background_color = '#CF0404';
			$label_text_color        = '#FFFFFF';
			$hover_background        = '#FF3019';
			$label_hover_text_color  = '#FFFFFF';
			$tab_top_border          = $gradient_first_color;
		} elseif ( $theme_id == 'blue' && $enable_custom_theme == 0 ) {

			// BLUE COLOR SCHEME.

			$gradient_first_color    = '#49C0F0';
			$gradient_second_color   = '#2CAFE3';
			$active_background_color = '#2CAFE3';
			$label_text_color        = '#FFFFFF';
			$hover_background        = '#49C0F0';
			$label_hover_text_color  = '#FFFFFF';
			$tab_top_border          = $gradient_first_color;
		} elseif ( $theme_id == 'green' && $enable_custom_theme == 0 ) {

			// GREEN COLOR SCHEME.

			$gradient_first_color    = '#0EB53D';
			$gradient_second_color   = '#299A0B';
			$active_background_color = '#299A0B';
			$label_text_color        = '#FFFFFF';
			$hover_background        = '#0EB53D';
			$label_hover_text_color  = '#FFFFFF';
			$tab_top_border          = $gradient_first_color;
		} elseif ( $theme_id == 'pink' && $enable_custom_theme == 0 ) {

			// PINK COLOR SCHEME.

			$gradient_first_color    = '#FF5DB1';
			$gradient_second_color   = '#EF017C';
			$active_background_color = '#EF017C';
			$label_text_color        = '#FFFFFF';
			$hover_background        = '#FF5DB1';
			$label_hover_text_color  = '#FFFFFF';
			$tab_top_border          = $gradient_first_color;
		} elseif ( $theme_id == 'orange' && $enable_custom_theme == 0 ) {

			// ORANGE COLOR SCHEME.

			$gradient_first_color    = '#FFA84C';
			$gradient_second_color   = '#FF7B0D';
			$active_background_color = '#FF7B0D';
			$label_text_color        = '#FFFFFF';
			$hover_background        = '#FFA84C';
			$label_hover_text_color  = '#FFFFFF';
			$tab_top_border          = $gradient_first_color;
		} elseif ( $enable_custom_theme == 1 ) {

			// CUSTOM COLOR SCHEME.

			$hover_background = '#FFA84C';

			/*------ Gradient First Color Settings  ---*/

			$gradient_first_color = '#FFA84C';

			if ( isset( $bwl_advanced_faq_options['gradient_first_color'] ) ) {

				$gradient_first_color = $bwl_advanced_faq_options['gradient_first_color'];
			}

			/*------ Gradient Second Color Settings  ---*/

			$gradient_second_color = '#FF7B0D';

			if ( isset( $bwl_advanced_faq_options['gradient_second_color'] ) ) {

				$gradient_second_color = $bwl_advanced_faq_options['gradient_second_color'];
			}

			/*------ LABEL TEXT COLOR SETTINGS  ---*/

			$label_text_color = '#777777';

			if ( isset( $bwl_advanced_faq_options['label_text_color'] ) ) {

				$label_text_color = $bwl_advanced_faq_options['label_text_color'];
			}

			/*------ LABEL HOVER TEXT COLOR SETTINGS  ---*/

			$label_hover_text_color = '#777777';

			if ( isset( $bwl_advanced_faq_options['label_hover_text_color'] ) ) {

				$label_hover_text_color = $bwl_advanced_faq_options['label_hover_text_color'];
			}

			/*------ Gradient Active Background Color Settings  ---*/

			$active_background_color = '#FF7B0D';

			if ( isset( $bwl_advanced_faq_options['active_background_color'] ) ) {

				$active_background_color = $bwl_advanced_faq_options['active_background_color'];
			}

			$tab_top_border = $gradient_first_color;

			$hover_background = $gradient_first_color;
		} else {

			// DEFAULT COLOR SCHEME.

			$tab_top_border          = '#2C2C2C';
			$gradient_first_color    = '#FFFFFF';
			$gradient_second_color   = '#EAEAEA';
			$active_background_color = '#C6E1EC';
			$label_text_color        = '#777777';
			$hover_background        = '#FFFFFF';
			$label_hover_text_color  = '#777777';
		}

		return [

			'first_color'      => $gradient_first_color,
			'second_color'     => $gradient_second_color,
			'label_text_color' => $label_text_color,

		];
	}
}
