<?php


namespace BwlFaqManager\Controllers\Votes;

use BwlFaqManager\Controllers\Votes\FaqVoteStatus;


class FaqVoteContainer {


	public function __construct() {
	}


	/*
    * returns the voting interface.
	*/
	public function getVoteContainer( $post_id ) {

		$faqVoteStatus = new FaqVoteStatus();

		$nonce_field = wp_nonce_field( 'baf-vote-nonce', '_baf_vote_nonce' );

		$bwl_advanced_faq_options = get_option( 'bwl_advanced_faq_options' );

		$baf_already_voted_status = ( $faqVoteStatus->getFaqVoteStatus( $post_id ) == true ) ? 1 : 0;
		$baf_vote_count           = get_post_meta( $post_id, 'baf_votes_count', true );

		$loading_msg      = esc_html__( 'Please Wait ...', 'bwl-adv-faq' );
		$thumb_icon_class = ( isset( $bwl_advanced_faq_options['baf_like_icon'] ) && $bwl_advanced_faq_options['baf_like_icon'] != '' ) ? 'fa ' . $bwl_advanced_faq_options['baf_like_icon'] : 'fa fa-thumbs-up';
		$info_icon_class  = 'fa fa-info-circle';

		$liked_class = ( $baf_already_voted_status ) ? 'liked' : '';

		$output  = '<hr class="ultra-fancy-hr">';
		$output .= '<div class="post-like-container ' . $liked_class . '">';

		if ( $baf_already_voted_status ) :

			$output .= '<h4 class="post-like-status"><i class="fa fa-info-circle"></i> ' . esc_html__( 'You have already liked it!', 'bwl-adv-faq' ) . '</h4>';

		else :

			$custom_tags = "data-post_id='{$post_id}' data-loading_msg='{$loading_msg}' data-info_icon='{$info_icon_class}'";
			$vote_icon   = "<span class='post-like baf-vote-btn'><i class='$thumb_icon_class'></i></span>";

			$output .= "<a href='#' $custom_tags> 
                            {$vote_icon}
														{$nonce_field}
                        </a>";

		endif;

		$output .= '<span class="count">';

		if ( ! empty( $baf_vote_count ) ) {

			$displayIcon = $baf_already_voted_status ? '<i class="' . $thumb_icon_class . ' faq-liked"></i> ' : '';

			$output .= $displayIcon . $baf_vote_count . ' ' . esc_html__( 'people found this faq useful.', 'bwl-adv-faq' );
		} else {

			$output .= esc_html__( 'Be the first person to like this faq.', 'bwl-adv-faq' );
		}

		$output .= '</span>';

		$output .= '</div>';

		return $output;
	}
}
