<?php

/**
 * @package BwlFaqManager
 */

namespace BwlFaqManager\Controllers\Shortcodes;

use BwlFaqManager\Api\Shortcodes\ShortcodesApi;
use BwlFaqManager\Callbacks\Shortcodes\FaqTabsCb;

class FaqTabs {


    public $faqTabs;
    public $shortcodesApi;
    public $faqTabsCb;

    public function __construct() {
    }
    public function register() {

        // Initialize API.
        $this->shortcodesApi = new ShortcodesApi();

        // Initialize callbacks.
        $this->faqTabsCb = new FaqTabsCb();

        $shortcodes = [
            [
                'tag'      => 'bwl_faq_tab', // single tab content
                'callback' => [ $this->faqTabsCb, 'get_faq_tab' ],
            ],
            [
                'tag'      => 'bwl_faq_tabs', // all tabs
                'callback' => [ $this->faqTabsCb, 'get_faq_tabs' ],
            ],

        ];

        $this->shortcodesApi->addShortcodes( $shortcodes )->register();
    }
}
