<?php

/**
 * @package BwlFaqManager
 */

namespace BwlFaqManager\Controllers\Shortcodes;

use BwlFaqManager\Api\Shortcodes\ShortcodesApi;
use BwlFaqManager\Callbacks\Shortcodes\FaqSortedListCb;


class FaqSortedList {

    public $shortcodesApi;
    public $faqSortedListCb;
    public function __construct() {
    }

    public function register() {

        // Initialize API.
        $this->shortcodesApi = new ShortcodesApi();

        // Initialize callbacks.
        $this->faqSortedListCb = new FaqSortedListCb();

        $shortcodes = [
            [
                'tag'      => 'bwla_dsort_faq', // FAQ Dynamic sort
                'callback' => [ $this->faqSortedListCb, 'getSortedList' ],
            ],
        ];

        $this->shortcodesApi->addShortcodes( $shortcodes )->register();
    }
}
