<?php

/**
 * @package BwlFaqManager
 */

namespace BwlFaqManager\Controllers\Shortcodes;

use BwlFaqManager\Api\Shortcodes\ShortcodesApi;
use BwlFaqManager\Callbacks\Shortcodes\FaqSearchBoxCb;


class FaqSearchBox {

    public $shortcodesApi;
    public $faqSearchBoxCb;

    public function __construct() {
    }
    public function register() {

        // Initialize API.
        $this->shortcodesApi = new ShortcodesApi();

        // Initialize callbacks.
        $this->faqSearchBoxCb = new FaqSearchBoxCb();

        $shortcodes = [
            [
                'tag'      => 'baf_sbox', // FAQ search box
                'callback' => [ $this->faqSearchBoxCb, 'getFaqSearchBox' ],
            ],
        ];

        $this->shortcodesApi->addShortcodes( $shortcodes )->register();
    }
}
