<?php

namespace BwlFaqManager\Controllers\Shortcodes;

use BwlFaqManager\Api\Shortcodes\ShortcodesApi;
use BwlFaqManager\Callbacks\Shortcodes\FaqItemsCb;

/**
 * Class FaqList
 *
 * This class handles the registration of the FAQ list shortcode.
 *
 * @package BwlFaqManager
 */
class FaqList {

	public $faqItemsCb;
	public $shortcodesApi;

	public function __construct() {}
	public function register() {

		// Initialize API.
		$this->shortcodesApi = new ShortcodesApi();

		// Initialize callbacks.
		$this->faqItemsCb = new FaqItemsCb();

		$shortcodes = [
			[
				'tag'      => 'bwla_faq', // Primary FAQ Shortcode
				'callback' => [ $this->faqItemsCb, 'get_faq_items' ],
			],
		];

		$this->shortcodesApi->addShortcodes( $shortcodes )->register();
	}
}
