<?php

/**
 * @package BwlFaqManager
 */

namespace BwlFaqManager\Controllers\Shortcodes;

use BwlFaqManager\Api\Shortcodes\ShortcodesApi;
use BwlFaqManager\Callbacks\Shortcodes\FaqExternalFormCb;

class FaqExternalForm {


    public $faqTabs;
    public $shortcodesApi;
    public $faqExternalFormCb;

    public function __construct() {
    }
    public function register() {

        // Initialize API.
        $this->shortcodesApi = new ShortcodesApi();

        // Initialize callbacks.
        $this->faqExternalFormCb = new FaqExternalFormCb();

        $shortcodes = [
            [
                'tag'      => 'bwla_form', // tab search box
                'callback' => [ $this->faqExternalFormCb, 'getFaqExternalForm' ],
            ],
        ];

        $this->shortcodesApi->addShortcodes( $shortcodes )->register();
    }
}
