<?php

/**
 * @package BwlFaqManager
 */

namespace BwlFaqManager\Controllers\Shortcodes;

use BwlFaqManager\Api\Shortcodes\ShortcodesApi;
use BwlFaqManager\Callbacks\Shortcodes\FaqAuthorCb;


class FaqAuthor {


	public $faqAuthorCb;
	public $shortcodesApi;

	public function __construct() {}
	public function register() {

		// Initialize API.
		$this->shortcodesApi = new ShortcodesApi();

		// Initialize callbacks.
		$this->faqAuthorCb = new FaqAuthorCb();

		$shortcodes = [
			[
				'tag'      => 'bwla_author', // FAQ Author Information
				'callback' => [ $this->faqAuthorCb, 'getFaqAuthor' ],
			],
		];

		$this->shortcodesApi->addShortcodes( $shortcodes )->register();
	}
}
