<?php

/**
 * @package BwlFaqManager
 */

namespace BwlFaqManager\Controllers\ExternalFaqForm;

use BwlFaqManager\Api\AjaxHandlers\AjaxHandlersApi;
use BwlFaqManager\Callbacks\ExternalFaqForm\FaqSubmissionHandlerCb;

class FaqSubmissionHandler {

	public $faqSubmissionHandler;
	public $ajaxHandlersApi;
	public $faqSubmissionHandlerCb;

	public $faqSubmissionHandlerSettings = [];


	public function __construct() {
	}
	public function register() {

		// Initialize API.
		$this->ajaxHandlersApi = new AjaxHandlersApi();

		// Initialize callbacks.

		$this->faqSubmissionHandlerCb = new FaqSubmissionHandlerCb();

		// Add all the faq Submission Handler Settings here.

		$this->faqSubmissionHandlerSettings = [
			[
				'tag'      => 'bwl_advanced_faq_save_post_data',
				'callback' => [ $this->faqSubmissionHandlerCb, 'savePostData' ],
			],
		];

		$this->ajaxHandlersApi->addAjaxHandlers( $this->faqSubmissionHandlerSettings )->register();
	}
}
