<?php

/**
 * @package BwlFaqManager
 */

namespace BwlFaqManager\Controllers\DashboardWidgets;

use BwlFaqManager\Api\DashboardWidgets\DashboardWidgetsApi;
use BwlFaqManager\Callbacks\DashboardWidgets\DashboardWidgetsCb;

class PluginDashboardWidgets {

	public $dashboardWidgets;
	public $dashboardWidgetsApi;
	public $dashboardWidgetsCb;

	public $dashboardWidgetsSettings = [];
	public $dashWidgets              = [];

	public function __construct() {
		$this->register();
	}

	public function register() {

		// Initialize API.
		$this->dashboardWidgetsApi = new DashboardWidgetsApi();

		// Initialize callbacks.
		$this->dashboardWidgetsCb = new DashboardWidgetsCb();

		// Add all the dashwidgets here.
		$this->dashboardWidgetsSettings = [
			[
				'slug'  => 'baf-plugin-summary',
				'title' => 'FAQ Summary',
				'cb'    => [ $this->dashboardWidgetsCb, 'getPluginSummary' ],
			],
		];

		$this->dashboardWidgetsApi->addDashWidgets( $this->dashboardWidgetsSettings )->register();
	}
}
