<?php

/**
 * @package BwlFaqManager
 */

namespace BwlFaqManager\Controllers\Analytics;

use BwlFaqManager\Api\Db\QueryHelper;

/**
 * [Description BafAnalyticsLikeCount]
 */
class BafAnalyticsLikesCount extends BafAnalytics {


	public $dbTable;
	/**
	 * @return [array]
	 */
	public function register() {
		$this->rearrangeData();
		return $this->getFAQLikesCount();
	}



	/**
	 * @return [type]
	 */
	public function rearrangeData() {

		$likeDataRearrangeStatus = get_option( 'baf_like_data_status' );

		if ( $likeDataRearrangeStatus == 1 ) { return '';
		}

		global $wpdb;

		// echo "<pre>";
		// print_r(self::$bafLikesDataTable);
		// echo "</pre>";

		// $query = "
		// SELECT post_id, meta_key, meta_value
		// FROM {$wpdb->postmeta}
		// LIKE 'baf_voted_IP' ORDER BY `meta_id` ASC";

		$query = "SELECT * FROM {$wpdb->postmeta} WHERE `meta_key` LIKE 'baf_voted_IP' ORDER BY `meta_id` ASC ";

		$postMetaInfo = $wpdb->get_results( $query, ARRAY_A );

		if ( count( $postMetaInfo ) > 0 ) {

			// format.
			/*
			[
			'post_id'=> 1,
			'ip'=> '',
			'like_date_time'=> '2023-04-09 11:11:11' //date('Y-m-d H:i:s', $timestamp);
			]

			*/

			$voteData = [];

			foreach ( $postMetaInfo as $metaInfo ) {

				$postId    = $metaInfo['post_id'];
				$metaValue = $metaInfo['meta_value'];

				// echo "<pre>";
				// print_r($metaValue);
				// echo "</pre>";

				$decoded_data = unserialize( $metaValue );
				// echo "<pre>";
				// print_r($decoded_data);
				// echo "</pre>";

				if ( is_array( $decoded_data ) && ! empty( $decoded_data ) ) {
					foreach ( $decoded_data as $ip => $timestamp ) {
						$newVoteDataItem = [];
						$formatted_date  = date( 'Y-m-d H:i:s', $timestamp );
						// echo "IP: $ip, Date: $formatted_date<br>";
						$newVoteDataItem['post_id']        = $postId;
						$newVoteDataItem['ip']             = $ip;
						$newVoteDataItem['like_date_time'] = $formatted_date;
						if ( $likeDataRearrangeStatus != 1 ) {
							BafAnalyticsHelper::insertLikeData( $newVoteDataItem );
						}
						array_push( $voteData, $newVoteDataItem );
					}
				}

				// $formatted_date = date('Y-m-d H:i:s', $timestamp);
				// echo "IP: $ip, Date: $formatted_date<br>";

			}

			// echo "<pre>";
			// print_r($voteData);
			// echo "</pre>";

			update_option( 'baf_like_data_status', 1 );
		}
	}


	/**
	 * @return [type]
	 */
	public static function countFaqLikes() {
		global $wpdb;
		$query = "SELECT SUM(meta_value) AS total_votes
    FROM {$wpdb->postmeta}
    WHERE meta_key = 'baf_votes_count'";

		$total_votes = $wpdb->get_var( $query );
		return $total_votes;
	}

	/**
	 * @param $interval =
	 * @param int        $limit
	 *
	 * @return [type]
	 */
	public static function getRecentlyLikedFaqs( $interval = '1 month', $limit = 5 ) {

		global $wpdb;

		$query = 'SELECT post_id, COUNT(`post_id`) AS tv 
                    FROM ' . TABLE_BAF_LIKES_DATA . " 
                    WHERE 1 AND like_date_time BETWEEN now() - interval $interval AND now() GROUP BY `post_id` ORDER BY tv DESC LIMIT $limit";

		// echo $query;
		$recentlyLikedFaqs = $wpdb->get_results( $query );

		return $recentlyLikedFaqs;
	}


	/**
	 * @param $interval = 30
	 *
	 * @return
	 */
	public static function countFaqLikesDataRange( $interval = '30 day' ) {
		global $wpdb;

		$condWhere  = 'WHERE 1';
		$condWhere .= " AND like_date_time BETWEEN CURDATE() - INTERVAL {$interval} AND CURDATE()";

		$query = 'SELECT COUNT(`post_id`) AS total_likes FROM ' . TABLE_BAF_LIKES_DATA . " {$condWhere} ORDER BY total_likes DESC";

		$total_votes = $wpdb->get_results( $query, ARRAY_A );

		// echo "<pre>";
		// print_r($total_votes);
		// echo "</pre>";

		return $total_votes[0]['total_likes'] ?? 0;
	}


	/**
	 * @param $interval = 30
	 *
	 * @return
	 */
	public static function faqLikesDateRangeData( $faqId = 'all', $interval = '7 day', $startDate = '', $endData = '' ) {
		global $wpdb;
		$condWhere = 'WHERE 1';

		if ( $faqId != 'all' ) {
			$condWhere .= " AND post_id={$faqId}";
		}

		$condWhere .= " AND like_date_time BETWEEN CURDATE() - INTERVAL {$interval} AND CURDATE()";

		$query = 'SELECT DATE(like_date_time) AS like_date, COUNT(post_id) AS total_likes FROM ' . TABLE_BAF_LIKES_DATA . " {$condWhere} GROUP BY like_date ORDER BY like_date DESC;";

		$totalLikesData = $wpdb->get_results( $query, ARRAY_A );

		// echo $wpdb->last_query;

		// echo "<pre>";
		// print_r($totalLikesData);
		// echo "</pre>";

		return $totalLikesData;

		// return $total_votes[0]['totalLikes'] ?? 0;
	}


	/**
	 * @param $interval = 30
	 *
	 * @return
	 */
	public static function getAnalyticsReportData( $filterType = 'views', $faqId = 'all', $interval = '7 day', $startDate = '', $endData = '' ) {

		if ( $filterType == 'views' ) {
			$dbTable        = TABLE_BAF_VIEWS_DATA;
			$dateTimeColumn = 'views_date_time';
		} else {
			$dbTable        = TABLE_BAF_LIKES_DATA;
			$dateTimeColumn = 'like_date_time';
		}

		$dbQuery                 = new QueryHelper();
		$dbQuery->table          = $dbTable;
		$dbQuery->dateTimeColumn = $dateTimeColumn;
		$dbQuery->selectFields   = "DATE($dateTimeColumn) AS date_group, COUNT(post_id) AS total_counts";
		$dbQuery->groupByString  = ' GROUP BY date_group';
		$dbQuery->orderByString  = ' ORDER BY date_group DESC';
		$totalData               = $dbQuery->getData();

		return $totalData;
	}

	/**
	 * @return [type]
	 */
	public function getFAQLikesCount() {

		$todaysCount    = $this->countFaqLikesDataRange( '1 day' );
		$lastThirtyDays = $this->countFaqLikesDataRange();
		$totalLikes     = $this->countFaqLikes();

		return [
			'todays'         => $todaysCount,
			'lastThirtyDays' => $lastThirtyDays,
			'totalLikes'     => $totalLikes,
		];
	}
}
