<?php

/**
 * @package BwlFaqManager
 */

namespace BwlFaqManager\Callbacks\Shortcodes;

use BwlFaqManager\Callbacks\Shortcodes\FaqOutputCb;

class FaqSortedListCb {

	public function __construct() {}

	function getSortedList( $atts ) {

		extract(shortcode_atts([
			'post_type'         => BWL_BAF_CPT,
			'meta_key'          => '',
			'orderby'           => 'ID',
			'order'             => 'ASC',
			'limit'             => -1,
			'faq_category'      => '',
			'faq_topics'        => '',
			'baf_sort_filter'   => 'category',
			'baf_term_id'       => 0,
			'paginate'          => 0,
			'pag_limit'         => 5,
			'sbox'              => 0,
			'sbox_class'        => 0,
			'search_only_title' => 0,
			'sc_excerpt'        => 0,
			'schema'            => 0,
		], $atts));

		$args = [
			'post_status'    => 'publish',
			'post_type'      => $post_type,
			'posts_per_page' => -1,
		];

		if ( $baf_sort_filter == 'topics' ) {

			$baf_sort_prefix             = PREFIX_BAF_TOPIC;
			$args['advanced_faq_topics'] = $faq_topics;
		} else {

			$baf_sort_prefix               = PREFIX_BAF_CAT;
			$args['advanced_faq_category'] = $faq_category;
		}

		$loop                 = new \WP_Query( $args );
		$baf_cat_all_posts_id = [];

		if ( $loop->have_posts() ) :

			while ( $loop->have_posts() ) :

				$loop->the_post();

				$baf_cat_all_posts_id[] = get_the_ID();

			endwhile;

		endif;

		wp_reset_query();

		$args = FaqOutputCb::getDynamicSortArguments(
            $baf_cat_all_posts_id,
            $baf_sort_prefix,
            $baf_sort_filter,
            $baf_term_id,
            $faq_category,
            $limit
		);

		$loop = new \WP_Query( $args );

		return FaqOutputCb::get_baf_output( $atts, $loop );
	}
}
