<?php

/**
 * @package BwlFaqManager
 */

// @Description: FAQ Search Box.
// @Since: 1.0.2

namespace BwlFaqManager\Callbacks\Shortcodes;

class FaqSearchBoxCb {

	public function __construct() {
	}


	private function getSuggestionString( $atts ) {

		extract( $atts );

		$baf_suggestion_string = '';

		if ( isset( $baf_suggestion_status ) && $baf_suggestion_status == 1 && $baf_suggestion != '' ) {

			$baf_suggestion = explode( ',', $baf_suggestion );

			$custom_baf_suggestion = '';

			if ( sizeof( $baf_suggestion ) > 0 ) {

				foreach ( $baf_suggestion as $key => $value ) {
					$custom_baf_suggestion .= '<a href="#">' . $value . '</a>, ';
				}

				$custom_baf_suggestion = substr( $custom_baf_suggestion, 0, strlen( $custom_baf_suggestion ) - 2 );
			}

			$baf_suggestion_string .= '<div class="baf_suggestion"><b class="baf_suggestion_prefix">' . $baf_suggestion_prefix . '</b> ' . $custom_baf_suggestion . '</div>';
		}

		return $baf_suggestion_string;
	}

	public function getFaqSearchBox( $atts ) {

		$atts = shortcode_atts([
			'sbox_id'               => wp_rand(),
			'unique_id'             => '',
			'paginate'              => 0,
			'search_only_title'     => 0,
			'taxonomy_info_search'  => 0,
			'sbox_class'            => '',
			'pag_limit'             => 0,
			'placeholder'           => esc_html__( 'Search...', 'bwl-adv-faq' ),
			'highlight_color'       => '#000000',
			'highlight_bg'          => '#FDE990',
			'baf_suggestion_status' => 0,
			'baf_suggestion_prefix' => esc_html__( 'Popular searches:', 'bwl-adv-faq' ),
			'baf_suggestion'        => '',
			'cont_ext_class'        => '',
		], $atts);

		extract( $atts );

		$unique_faq_container_id = $sbox_id;

		$baf_suggestion_string = $this->getSuggestionString( $atts );

		$bwla_search_form_class = ( isset( $cont_ext_class ) && $cont_ext_class != '' ) ? 'bwl-faq-search-panel ' . $cont_ext_class : 'bwl-faq-search-panel';

		$uniqueIdTag = $unique_id != '' ? "data-unique_id={$unique_id}" : '';

		$taxonomyInfoSearchTag = $taxonomy_info_search == 1 ? " data-taxonomy_info_search='{$taxonomy_info_search}'" : '';

		$formIdTag = $taxonomy_info_search == 0 ? 'data-form_id="' . $unique_faq_container_id . '"' : '';

		$baf_sbox_output = '<form id="live-search" action="#" class="' . $bwla_search_form_class . '" method="post" data-paginate="' . $paginate . '" data-search_only_title="' . $search_only_title . '" data-pag_limit="' . $pag_limit . '" ' . $uniqueIdTag . ' ' . $formIdTag . '>
                        <fieldset>
                            <input type="text" class="search_icon text-input ' . $sbox_class . '" id="bwl_filter_' . $unique_faq_container_id . '" value="" placeholder="' . $placeholder . '" data-highlight_color="' . $highlight_color . '" data-highlight_bg="' . $highlight_bg . '" ' . $taxonomyInfoSearchTag . '>
                                <span class="baf-btn-clear baf_dn"></span>
                                <span id="bwl-filter-message-' . $unique_faq_container_id . '" class="bwl-filter-message"></span>
                        </fieldset>
                        ' . $baf_suggestion_string . '
                    </form>';

		return $baf_sbox_output;
	}
}
