<?php

/**
 * @package BwlFaqManager
 */

namespace BwlFaqManager\Callbacks\Shortcodes;

class FaqExternalFormCb {

	public function __construct() {
	}

	function getFaqExternalForm( $atts ) {

		$atts = shortcode_atts([
			'status'           => 1,
			'form_heading'     => esc_html__( 'Add A New FAQ Question !', 'bwl-adv-faq' ),
			'title_min_length' => '3',
			'title_max_length' => '100',
			'sel_cat'          => '',
			'hide_cat_field'   => 0,
			'cont_ext_class'   => '',
		], $atts);

		extract( $atts );

		if ( $status == 0 ) {

			return null;
		}

		wp_enqueue_script( 'baf-custom-scripts' );

		$err_baf_ext_question = sprintf( esc_html__( ' Write your question. Min length %1$d characters & Max length %2$d characters !', 'bwl-adv-faq' ), $title_min_length, $title_max_length );

		$bwl_advanced_faq_options = get_option( 'bwl_advanced_faq_options' );

		$captcha_status = 1;

		if ( isset( $bwl_advanced_faq_options['bwl_advanced_faq_captcha_status'] ) ) {

			$captcha_status = $bwl_advanced_faq_options['bwl_advanced_faq_captcha_status'];
		}

		$login_required = true; // Default we required logged in to post a new faq.

		if ( is_user_logged_in() ) {

			$login_required = false;
		}

		if ( isset( $bwl_advanced_faq_options['bwl_advanced_faq_logged_in_status'] ) ) {

			if ( $bwl_advanced_faq_options['bwl_advanced_faq_logged_in_status'] == 1 ) {

				if ( is_user_logged_in() ) {

					$login_required = false;
				}
			} else {

				$login_required = false;
			}
		}

		if ( $login_required == false ) :

			$bwl_faq_categories_counter = get_categories( 'post_type=bwl_advanced_faq&taxonomy=advanced_faq_category&order=DESC' );

			if ( count( $bwl_faq_categories_counter ) == 0 ) {

				wp_insert_term(
                    'General', // the term
                    'advanced_faq_category', // the taxonomy
                    [
						'description' => 'First FAQ Category.',
						'slug'        => 'general',
						'parent'      => 0,
                    ]
				);
			}

			$data_string_sel_cat  = '';
			$hide_cat_field_class = ( isset( $hide_cat_field ) && $hide_cat_field == 1 ) ? 'baf_field baf_hidden' : 'baf_field';

			$bwl_faq_categories_html = '<div class="' . $hide_cat_field_class . '"><label for="cat">' . esc_html__( 'Category', 'bwl-adv-faq' ) . '</label>';

			$bwl_faq_categories_args = [
				'post_type'        => 'bwl_advanced_faq',
				'show_option_none' => esc_html__( 'Category', 'bwl-adv-faq' ),
				'taxonomy'         => 'advanced_faq_category',
				'echo'             => 0,
				'hide_empty'       => 0,
			];

			if ( isset( $sel_cat ) && $sel_cat != '' ) {

				$bwl_faq_categories_args['selected'] = $sel_cat;

				$data_string_sel_cat .= ' data-sel_cat="' . $sel_cat . '"';
			}

			$bwl_faq_categories_html .= wp_dropdown_categories( $bwl_faq_categories_args );

			$bwl_faq_categories_html .= '</div>';

			$bwl_advanced_faq_form_id = wp_rand();

			if ( $captcha_status == 1 ) :

				$bwl_captcha_generator = '<div class="baf_field">
                                                              <input id="num1" aria-label="captcha number 1" class="sum" type="text" name="num1" value="' . rand( 1, 4 ) . '" readonly="readonly"> +
                                                              <input id="num2" aria-label="captcha number 2" class="sum" type="text" name="num2" value="' . rand( 5, 9 ) . '" readonly="readonly"> =
                                                              <input id="captcha" aria-label="Write the sum value of the captcha numbers 1 and 2" class="captcha" type="text" name="captcha" maxlength="2">
                                                              <input id="captcha_status" type="hidden" name="captcha_status" value="' . $captcha_status . '">
                                                              <span id="spambot"> ' . esc_html__( 'Verify Human or Spambot ?', 'bwl-adv-faq' ) . '</span>
                                                      </div>';

			else :

				$bwl_captcha_generator = '<input id="captcha_status" type="hidden" name="captcha_status" value="' . $captcha_status . '">';

			endif;

			$bwla_form_class = ( isset( $cont_ext_class ) && $cont_ext_class != '' ) ? 'bwl-faq-form-container ' . $cont_ext_class : 'bwl-faq-form-container';

			$bwla_form_body = '<section class="' . $bwla_form_class . '" id="' . $bwl_advanced_faq_form_id . '">
                      
                                          <h2>' . $form_heading . ' </h2>
  
                                          <div class="bwl-faq-form-message-box"></div>
                                              
                                          <form id="bwl_advanced_faq_form" class="bwl_advanced_faq_form" name="bwl_advanced_faq_form" method="post" action="#" ' . $data_string_sel_cat . '> 
                                          
                                                  <div class="baf_field">
                                                      <label for="title">' . esc_html__( 'Question', 'bwl-adv-faq' ) . '</label>
                                                      <input type="text" id="title" value="" name="title" data-error_msg="' . $err_baf_ext_question . '"  data-min_length="' . $title_min_length . '" data-max_length="' . $title_max_length . '">
                                                  </div>    
                                                 '
			. $bwl_faq_categories_html .

			$bwl_captcha_generator . '
  
                                                  <div class="baf_field">
                                                      <input type="submit" value="' . esc_html__( 'Submit FAQ', 'bwl-adv-faq' ) . '" id="submit" name="submit" bwl_advanced_faq_form_id= "' . $bwl_advanced_faq_form_id . '">
                                                  </div>'

			. wp_nonce_field( 'baf-frontend-faq-submission-nonce', '_baf_frontend_faq_submission_nonce' ) .

			'</form>
  
                                          </section>';
		else :

			$bwl_admin_login_url = ' <a href="' . esc_url( get_home_url() ) . '/wp-admin" target="_blank">' . esc_html__( 'Click Here', 'bwl-adv-faq' ) . '</a>';
			$bwla_form_body      = '<p><i class="fa fa-info-circle"></i> ' . esc_html__( 'Log In is required for submitting new FAQ.', 'bwl-adv-faq' ) . $bwl_admin_login_url . '</p>';

		endif;

		return $bwla_form_body;
	}
}
