<?php

/**
 * @package BwlFaqManager
 */

namespace BwlFaqManager\Callbacks\ExternalFaqForm;

class FaqSubmissionHandlerCb {

	public function __construct() {
	}

	public function setEmailContentType() {
		return 'text/html';
	}

	public function savePostData() {

		check_ajax_referer( 'baf-frontend-faq-submission-nonce', '_baf_frontend_faq_submission_nonce' );

		if ( ! isset( $_REQUEST['_baf_frontend_faq_submission_nonce'] ) ) {

			$status = [
				'bwl_faq_add_status' => 0,
			];
		} else {

			$post = [
				'post_title'  => sanitize_text_field( $_REQUEST['title'] ),
				'post_status' => 'pending', // Choose: publish, preview, future, etc.
				'post_type'   => 'bwl_advanced_faq',  // Use a custom post type if you want to
			];

			$post_id = wp_insert_post( $post );

			// Fixed in version 1.6.6

			$faq_category = get_term_by( 'id', sanitize_text_field( $_REQUEST['cat'] ), 'advanced_faq_category' );
			wp_set_object_terms( $post_id, $faq_category->slug, 'advanced_faq_category', true );

			$status = [
				'bwl_faq_add_status' => 1,
			];

			// Send Email to administrator.

			$baf_options = get_option( 'bwl_advanced_faq_options' );

			$bwl_send_email_status = ( isset( $baf_options['bwl_advanced_email_notification_status'] ) && $baf_options['bwl_advanced_email_notification_status'] == 0 ) ? false : true;

			if ( $bwl_send_email_status == true ) {

				$baf_email_send_to = ( isset( $baf_options['bwl_advanced_notification_email_id'] ) && ! empty( $baf_options['bwl_advanced_notification_email_id'] ) ) ? sanitize_email( $baf_options['bwl_advanced_notification_email_id'] ) : get_bloginfo( 'admin_email' );

				$baf_email_header_title = BAF_A_FS_EMAIL_HEADER_TITLE;
				$baf_email_reply_to     = sanitize_email( BAF_A_FS_REPLY_EMAIL );
				$baf_email_subject      = BAF_A_FS_EMAIL_SUBJECT;

				$baf_faq_url = get_admin_url() . "post.php?post&#61;$post_id&#38;action&#61;edit";

				$baf_email_body  = '<p>' . esc_html__( 'Hello Administrator', 'bwl-adv-faq' ) . ',<br>' . esc_html__( 'A new faq has been submitted by a user.', 'bwl-adv-faq' ) . '</p>';
				$baf_email_body .= '<h3>' . esc_html__( 'Submitted FAQ Information', 'bwl-adv-faq' ) . '</h3><hr />';
				$baf_email_body .= '<p><strong>' . esc_html__( 'Title', 'bwl-adv-faq' ) . ':</strong><br />' . sanitize_text_field( $_REQUEST['title'] ) . '</p>';
				$baf_email_body .= '<p><strong>' . esc_html__( 'FAQ Status', 'bwl-adv-faq' ) . ':</strong> ' . esc_html__( 'Pending', 'bwl-adv-faq' ) . '</p>';
				$baf_email_body .= '<p><strong>' . esc_html__( 'Review FAQ', 'bwl-adv-faq' ) . ':</strong> ' . esc_url( $baf_faq_url ) . '</p>';
				$baf_email_body .= '<p>' . esc_html__( 'Thank You!', 'bwl-adv-faq' ) . '</p>';

				$baf_email_headers[] = "From: $baf_email_header_title <$baf_email_reply_to>";

				add_filter( 'wp_mail_content_type', [ $this, 'setEmailContentType' ] );

				wp_mail( $baf_email_send_to, $baf_email_subject, $baf_email_body, $baf_email_headers );

				remove_filter( 'wp_mail_content_type', [ $this, 'setEmailContentType' ] );
			}
		}

		echo wp_json_encode( $status );

		die();
	}
}
