<?php

/**
 * Class BafAdminHelpers
 *
 * @package BwlFaqManager
 */
namespace BwlFaqManager\Base;

/**
 * Class BafAdminHelpers
 *
 * Defined all the admin helper methods
 *
 * @package BwlFaqManager
 */
class BafAdminHelpers {

	/**
	 * Get the translation data for admin JavaScript
     *
	 * @return [array]
	 * @example BafAdminData.baf_text_loading
	 */
	public static function localize_data(): array {

		$data = [
			'ajaxurl'              => esc_url( admin_url( 'admin-ajax.php' ) ),
			'baf_text_loading'     => esc_attr__( 'Loading .....', 'bwl-adv-faq' ),
			'baf_pvc_required_msg' => esc_attr__( 'Purchase code is required!', 'bwl-adv-faq' ),
			'baf_pvc_success_msg'  => esc_attr__( 'Purchase code verified. Reloading window in 3 seconds.', 'bwl-adv-faq' ),
			'baf_pvc_failed_msg'   => esc_attr__( 'Unable to verify purchase code. Please try again or contact support team.', 'bwl-adv-faq' ),
			'baf_pvc_remove_msg'   => esc_attr__( 'Are you sure to remove the license info?', 'bwl-adv-faq' ),
			'baf_pvc_removed_msg'  => esc_attr__( 'Purchase code removed. Reloading window in 3 seconds.', 'bwl-adv-faq' ),
			'product_id'           => BWL_BAF_CC_ID,
			'installation'         => get_option( BWL_BAF_INSTALLATION_TAG ),
			'baf_dir'              => BWL_BAFM_PLUGIN_DIR, // for tinymce editor.
			'baf_text_saving'      => esc_attr__( 'Saving', 'bwl-adv-faq' ), // sort faq.
			'baf_text_saved'       => esc_attr__( 'Saved', 'bwl-adv-faq' ), // sort faq.
		];
		return $data;
	}

	/**
	 * Get the translation data for JavaScript
     *
	 * @return string
	 * @example BafAdminData.baf_text_loading
	 * @param string $link get the YouTube url.
	 * @param string $title set custom title for the YouTube video.
	 */
	public static function set_youtube_url( $link = '', $title = 'video tutorial' ): string {

		if ( empty( $link ) ) {
			return '';
		}

		$icon = "<span class='dashicons dashicons-youtube'></span>";
		$link = esc_url( $link );

		return "<a href={$link} title={$title} class='bwl_youtube_link' target='_blank'>{$icon}</a>";
	}
}
