<?php
/**
 * Class Activate
 *
 * @package BwlFaqManager
 */
namespace BwlFaqManager\Base;

/**
 * Class Active
 *
 * After plugin activation, it flush the rewrite rules.
 * Also, set the transient value for activation redirect page.
 *
 * @package BwlFaqManager
 */
class Activate {

	/**
	 * Callback function for the about plugin page.
	 *
	 * @since 2.0.6
	 */
	public static function activate() {
		flush_rewrite_rules();
		set_transient( 'baf_activation_redirect', true, 5 );
	}
}
