<?php

/**
 * @package BWL Advanced FAQ Manager
 */

namespace BwlFaqManager\Api\Shortcodes;

// ShortcodeApi interface class.

class ShortcodesApi {

	public $shortcodes = [];

	public function addShortcodes( array $shortcodes ) {
		$this->shortcodes = $shortcodes;
		return $this;
	}

	public function register() {
		if ( ! empty( $this->shortcodes ) ) {

			foreach ( $this->shortcodes as $shortcode ) {
				add_shortcode( $shortcode['tag'], $shortcode['callback'] );
			}
		}
	}
}
