# BWL Advanced FAQ Manager

Contributors: Md Mahbub Alam Khan

Plugin link: https://www.bluewindlab.net

Tags: faq manager, faq plugins, css3 faq plugins, advanced faq manager

Requires at least: 6.0+

Tested up to: 6.6.1

Stable tag: 2.0.9

License: GPLv2 or later

License URI: http://www.gnu.org/Licenses/gpl-2.0.html

BWL Advanced FAQ Manager is a cool FAQ Management plugin that offers custom post type for adding unlimited FAQ in your WordPress website.

## Description

BWL Advanced FAQ Manager Plugin makes it easy to create FAQ sections on your WordPress powered blog. Simply activate, add FAQ items, then display them on a post or page by using a shortcode.
Also you can show your faq items in sidebar as widget. Cool sorting features gives you sort FAQ items according to your need.

## Features

- Unlimited FAQ.
- FAQ Option Panel.
- 7 different FAQ Themes.
- Front End FAQ Ask Form.
- Shortcode Available.
- FAQ Widget.
- Sorting FAQ.
- Rating FAQ.
- FAQ Categories.
- FAQ Topics.
- Pure CSS3 Accordion.
- Responsive Layout.
- Only 21Kb In Size.
- Ready for localization.
- Support WP Latest Version.
- Well Documentation.

## Installation

### Using The WordPress Dashboard

1. Navigate to the 'Add New' Plugin Dashboard.
2. Select 'bwl-advanced-faq-manager.zip' from your computer.
3. Upload.
4. Activate the plugins on the WordPress Plugins dashboard.

### Using FTP

1. Extract `bwl-advanced-faq-manager.zip` to your computer.
2. Upload `bwl-advanced-faq-manager` directory to your `wp-content/plugins` folder.
3. Activate the plugins on the WordPress Plugins dashboard.

## Frequently Asked Questions

### Do I use this Plugins as widget?

Yes, you can. Go to widget dashboard and there you will found a widget called "BWL Advanced FAQ Manager Widget". Drag and drop
it right panel and add short codes inside text box and you are done.

### How to integrate short codes?

It's very simple. Follow the steps.

1. Go to `pages > Add new` and then in text editor write

```php
[bwla_faq]
```

2. You can also add parameters in shortcodes. For showing 5 faqs write the following shortcode.

```php
[bwla_faq limit=5]
```

3. Save the page, and check the output.

## Shortcodes:

Check the plugin documentation file for the [full shortcodes](https://xenioushk.github.io/docs-wp-plugins/baf/index.html#plugin_shortcodes_section) list.

### Show All FAQs:

```php
[bwla_faq]
```

### Show FAQs By Category:

```php
[bwla_faq faq_category='cat-slug-1,cat-slug-2']
```

### Show FAQs By Topics

```php
[bwla_faq faq_topics='topic-slug-1,topic-slug-2']
```

### Show 5 FAQs (SET LIMIT)

```php
[bwla_faq limit=5]
```

### Add FAQ Form

```php
[bwla_form]
```

### Display a search box with FAQs

```php
[bwla_faq sbox=1]
```

### Hide Search Form in FAQ

```php
[bwla_faq sbox=0]
```

### FAQ Author

```php
[bwla_author]
```

## Changelog

- [Documentation](https://projects.bluewindlab.net/wpplugin/baf/doc#change_log)
