<?php
/**
* Enqueues child theme stylesheet, loading first the parent theme stylesheet.
*/
function fthemes_custom_enqueue_child_theme_styles() {
	$required_stylesheets = array('bootstrap', 'maxhost-background', 'maxhost-stylesheet');
    wp_enqueue_style( 'style', get_stylesheet_uri(), $required_stylesheets );
}
add_action( 'wp_enqueue_scripts', 'fthemes_custom_enqueue_child_theme_styles' );

/**
  * Set up My Child Theme's textdomain.
  *
  * Declare textdomain for this child theme.
  * Translations can be added to the /languages/ directory.
  */
function fthemes_child_theme_setup() {
    load_child_theme_textdomain( 'maxhost', get_stylesheet_directory() . '/languages' );
}
add_action( 'after_setup_theme', 'fthemes_child_theme_setup' );

//Start writing your functions below