<?php
/**
 * The template for displaying the waitlist elements on a single product page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/waitlist-single.php.
 *
 * HOWEVER, on occasion WooCommerce Waitlist will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @version 2.2.3
 * 
 * @todo escape registration text echo, we might need to pull the string into this file to appease phpcs
 */
?>
<div class="wcwl_elements wcwl_nojs">
	<?php
	$users_email = $user ? $user->user_email : '';
	$disabled    = $users_email ? 'disabled' : '';
	if ( 'yes' == get_option( 'woocommerce_waitlist_registration_needed' ) && ! $users_email ) {
		?>
		<div class="wcwl_notice woocommerce-info">
			<?php
			echo wp_kses( $registration_required_text, 'post' );
			?>
		</div>
		<?php
	} else {
		$join_button_text = wcwl_get_button_text( 'join', $product_id );
		?>
		<div class="wcwl_intro">
			<p><?php esc_html_e( $intro ); ?></p>
		</div>
		<?php
		/**
		 * Filter to hide waitlist notices on the frontend
		 * 
		 * @since 2.4.11
		 */
		if ( apply_filters( 'wcwl_show_notice_on_frontend', true, $product_id, $notice, $context ) ) {
			?>
			<div class="wcwl_notice woocommerce-message">
				<div aria-live="polite">
					<p><?php esc_html_e( $notice ); ?></p>
				</div>
				<button type="button" class="wcwl_notice_dismiss">
					<span class="screen-reader-text"><?php esc_html_e( $dismiss_notification_text ); ?></span>
				</button>
			</div>
		<?php
		}
		
		if ( $opt_in && ! $on_waitlist ) {
			?>
			<div class="wcwl_optin">
				<input type="checkbox" name="wcwl_optin_<?php esc_attr_e( $product_id ); ?>" id="wcwl_optin_<?php esc_attr_e( $product_id ); ?>">
				<label for="wcwl_optin_<?php esc_attr_e( $product_id ); ?>"><?php esc_html_e( $opt_in_text ); ?></label>
			</div>
		<?php } ?>
		<div class="wcwl_email_elements <?php esc_attr_e( $email_class ); ?>">
			<label for="wcwl_email_<?php esc_attr_e( $product_id ); ?>" class="wcwl_email_label wcwl_visually_hidden"><?php esc_html_e( $email_address_label_text ); ?></label>
			<input type="email" value="<?php esc_attr_e( $users_email ); ?>" id="wcwl_email_<?php esc_attr_e( $product_id ); ?>" name="wcwl_email" class="wcwl_email" placeholder="<?php esc_attr_e( $email_address_placeholder_text ); ?>" <?php esc_attr_e( $disabled ); ?>/>
		</div>
		<?php
		if ( 'join' === $context && ( 'true' === $is_archive || is_shop() || is_product_category() ) ) {
			$context          = __( 'Confirm', 'woocommerce-waitlist' );
			$join_button_text = wcwl_get_button_text( 'confirm', $product_id );
		}
		?>
		<input type="hidden" name="wcwl_join_button_text" value="<?php esc_attr_e( $join_button_text ); ?>"/>
		<input type="hidden" name="wcwl_leave_button_text" value="<?php esc_attr_e( wcwl_get_button_text( 'leave', $product_id ) ); ?>"/>
		<?php
		/**
		 * Action to run before the form submit button, allowing hookup of recaptcha for example
		 * 
		 * @since 2.4.11
		 */
		do_action( 'wcwl_before_form_submit_button', $context, $product_id, $lang );
		?>
		<a rel="nofollow" class="wcwl_control" href="<?php echo esc_url( $url ); ?>" data-nonce="<?php esc_attr_e( wp_create_nonce( 'wcwl-ajax-process-user-request-nonce' ) ); ?>" data-product-id="<?php esc_attr_e( $product_id ); ?>" data-context="<?php esc_attr_e( $context ); ?>" data-wpml-lang="<?php esc_attr_e( $lang ); ?>">
			<button type="button" class="woocommerce_waitlist button">
				<?php esc_html_e( wcwl_get_button_text( $context, $product_id ) ); ?>
			</button>
			<div aria-live="polite" class="wcwl_visually_hidden"></div>
			<div class="spinner"></div>
		</a>
	<?php } ?>
</div><!-- wcwl_elements -->
