<?php
/*
 * Generates inline CSS from Customizer settings.
 */
if (!function_exists('huka_get_customizer_css')) {
    function huka_get_customizer_css()
    {
        ob_start();

        get_template_part('template-parts/header-variables');

        echo '#main-header, #site-footer {position: relative;}';
        echo '@media (min-width: 1200px) {#main-header + #site-content, #main-header + #site-content-wrap-grow, #main-header + #primary, #main-header + main {padding-top: 50px;}}';
        echo '@media (max-width: 1199px) {#main-header + #site-content, #main-header + #site-content-wrap-grow, #main-header + #primary, #main-header + main {padding-top: 32px;}}';
        echo '#header-wave {margin-bottom: -1px; width: 100%;}';
        echo '#magic-search .search-submit {display: none;}';
        echo '.onsale .onsale-svg {height: 100%;}';
        echo '#header-wave * {fill: transparent;} @media (max-width: 1199px){#header-wave {height: 20px;}} @media (min-width: 1200px){#header-wave {height: 45px;} :root #main-header{padding-top: 50px;}}';
        echo '.header-icons {display: none;} @media (max-width: 1199px) {.header-info {margin-top: 1rem;}}'; // Disable header search and cart icons

        if (get_theme_mod('meta_cat_switcher', false)) {
            echo '.entry-categories {display: none;}';
        }

        if (get_theme_mod('meta_author_switcher', false)) {
            echo '.post-author {display: none;}';
        }

        if (get_theme_mod('meta_date_switcher', false)) {
            echo '.blog-tile .post-date {display: none;}';
        }

        if (get_theme_mod('meta_comm_switcher', false)) {
            echo '.post-comment-link {display: none;}';
        }

        if (get_theme_mod('meta_pr_cat_switcher', false)) {
            echo '.product_meta .posted_in {display: none;}';
        }

        return ob_get_clean();
    }
}