<?php if(!defined('ABSPATH')) {
	die('Direct access forbidden.');
}
/**
 * hooks for wp blog part
 */

// if there is no excerpt, sets a defult placeholder
// ----------------------------------------------------------------------------------------
function buildbench_excerpt($words = 20, $more = 'BUTTON') {
	if($more == 'BUTTON') {
		$more = '<a class="btn btn-primary">' . esc_html__('read more', 'buildbench') . '</a>';
	}
	$excerpt = get_the_excerpt();
	$trimmed_content = wp_trim_words($excerpt, $words, $more);
	echo buildbench_kses($trimmed_content);
}


// change textarea position in comment form
// ----------------------------------------------------------------------------------------
function buildbench_move_comment_textarea_to_bottom($fields) {
	$comment_field = $fields['comment'];
	unset($fields['comment']);
	$fields['comment'] = $comment_field;

	return $fields;
}

add_filter('comment_form_fields', 'buildbench_move_comment_textarea_to_bottom');


// change textarea position in comment form
// ----------------------------------------------------------------------------------------
function buildbench_search_form($form) {
	$form = '
        <form  method="get" action="' . esc_url(home_url('/')) . '" class="buildbench-serach xs-search-group">
            <div class="input-group">
                <input type="search" class="form-control" name="s" placeholder="' . esc_attr__('Search', 'buildbench') . '" value="' . get_search_query() . '">
                <button class="input-group-btn search-button"><i class="icon icon-search1"></i></button>
            </div>
        </form>';

	return $form;
}

add_filter('get_search_form', 'buildbench_search_form');

function buildbench_body_classes($classes) {

	if(is_active_sidebar('sidebar-1')) {
		$classes[] = 'sidebar-active';
	} else {
		$classes[] = 'sidebar-inactive';
	}

	$box_class = buildbench_option('general_body_box_layout');
	$page_body_box_layout = buildbench_meta_option(get_the_ID(), "page_body_box_layout");
	if($box_class || $page_body_box_layout == true) {
		$classes[] = 'body-box-layout';
	}

	return $classes;
}

add_filter('body_class', 'buildbench_body_classes');

