(function($){
	frslib.provide('window.ffbuilder');

	window.ffbuilder.RankMath = Backbone.View.extend({
		_vent : null,

		/*----------------------------------------------------------*/
		/* BIND ACTIONS
		/*----------------------------------------------------------*/
		/**
		 * Capture changes in canvas
		 */
		_bindHooks: function() {
			wp.hooks.addFilter( 'rank_math_content', 'rank-math', this._updateContent, 12 );
		},
		_bindActions: function() {
			this.listenTo( this._vent, this._vent.a.canvasChanged, function(){
				rankMathEditor.refresh('content');
			});
		},

		/*----------------------------------------------------------*/
		/* INITIALIZE - constructor
		/*----------------------------------------------------------*/
		/**
		 * First initialization
		 */
		initialize: function( options ) {
			this._initClasses( options );
			this._init();
			this._bindHooks();
			this._bindActions();
		},

		_initClasses: function( options ) {
			this._vent = options.vent;
		},

		_init: function( options ) {
			this._updateContent = this.updateContent.bind( this );
		},

		updateContent: function() {
			// SHORTCODE FORMAT VERSION
			// var content = this._vent.f.getCanvasInShortcodes();
			// var cleanContent = content;
			// cleanContent = decodeURIComponent( cleanContent );
			// cleanContent = cleanContent.replace(/\\(.)/mg, "$1");
			// return cleanContent;

			// HTML FORMAT VERSION
			var content = this._vent.f.getCanvasInRawData();
			var cleanContent = content;
			cleanContent = cleanContent.replace(/&quot;/g, '\"');
			return cleanContent;
		},

	});

})(jQuery);