<?php

class ffPostCollection extends ffBasicObject implements Iterator, ArrayAccess, Countable {
	

	protected $_collectionItems = array();

	protected $_valid = false;

	public function count(): int {
		return $this->getNumberOfItems();
	}

	public function __construct(){

	}
	
	public function getNumberOfItems() {
		return count( $this->_collectionItems );
	}

	public function add( ffPostCollectionItem $item ){
		$this->_collectionItems[] = $item;
	}

	/* Methods */
	/**
	 * (non-PHPdoc)
	 * @see Iterator::current()
	 * @return ffPostCollectionItem
	 */
	public function current(): mixed {
		return current( $this->_collectionItems );
	}

	public function key(): mixed {
		return key( $this->_collectionItems );
	}

	public function next(): void {
		$isValid =  next( $this->_collectionItems );
		if( false == $isValid ) {
			$this->_valid = false;
		}
	}

	public function rewind(): void {
		$this->_valid = true;
		// noncompat with interface
		//return reset( $this->_collectionItems );
		reset( $this->_collectionItems );
	}

	public function valid(): bool {
		return $this->_valid;
	}
/**********************************************************************************************************************/
/* ARRAY ACCESS
/**********************************************************************************************************************/

    /**********************************************************************************************************************/
/* ARRAY ACCESS
/**********************************************************************************************************************/
    /* Methods */
    public function offsetExists ( mixed $offset ): bool {
        return isset( $this->_collectionItems[ $offset ] );
    }
    public function offsetGet ( mixed $offset ): mixed {
        return $this->_collectionItems[ $offset ];
    }
    public function offsetSet ( mixed $offset, mixed $value ): void {
        $this->_collectionItems[ $offset ] = $value;
    }
    public function offsetUnset ( mixed $offset ): void {
        unset( $this->_collectionItems[ $offset ] );
    }

}



