<?php

class ffCustomPostTypeCollection extends ffBasicObject implements Iterator, ArrayAccess {
	/**
	 * 
	 * @var 
	 */
	private $_postTypesFromWp = null;
	private $_valid = true;
	
	/**
	 * 
	 * @var ffCustomPostTypeCollectionItem_Factory
	 */
	private $_customPostTypeCollectionItemFactory;
	
	
	public function __construct( $postTypesFromWp, ffCustomPostTypeCollectionItem_Factory $customPostTypeCollectionItemFactory ) {
		$this->_setPostTypesFromWp($postTypesFromWp);
		$this->_setCustomPostTypeCollectionItemFactory($customPostTypeCollectionItemFactory);
	}
	
	private function _wpItemToOurItem( $wpItem ) {
		$ourItem = $this->_getCustomPostTypeCollectionItemFactory()->createCustomPostTypeCollectionItem();
		if( isset( $wpItem->labels) && isset( $wpItem->labels->name ) ) {
			$ourItem->label = $wpItem->labels->name;
		}
		 
		if( isset( $wpItem->labels ) && isset( $wpItem->labels->singular_name ) ) {
			$ourItem->labelSingular = $wpItem->labels->singular_name;
		}
		 
		$ourItem->id = key( $this->_postTypesFromWp );
		return $ourItem;
	}

	
	/* Methods */
	 public function current (): mixed {
	 	$currentItem = current( $this->_postTypesFromWp );
	 	$item = $this->_wpItemToOurItem( $currentItem );
	 	
	 	return $item;
	 }
	 public function key (): mixed {
	 	return key( $this->_postTypesFromWp );
	 }
	 public function next (): void {
	 	$isValid =  next( $this->_postTypesFromWp );
	 	if( false == $isValid ) {
	 		$this->_valid = false;
	 	}
	 }
	 public function rewind (): void {
	 	$this->_valid = true;
	 	//ark v66 hotfix, "rewind(): void" cannot return so just removing the return here.
		// return reset( $this->_postTypesFromWp );
	 	reset( $this->_postTypesFromWp );
	 }
	 public function valid (): bool {
	 	return $this->_valid;
	 }

/**********************************************************************************************************************/
/* ARRAY ACCESS
/**********************************************************************************************************************/
    /* Methods */
    public function offsetExists ( mixed $offset ): bool {
        return isset( $this->_postTypesFromWp[ $offset ] );
    }
    public function offsetGet ( mixed $offset ): mixed {
        return $this->_postTypesFromWp[ $offset ];
    }
    public function offsetSet ( mixed $offset , mixed $value ): void {
        $this->_postTypesFromWp[ $offset ] = $value;
    }
    public function offsetUnset ( mixed $offset ): void {
        unset( $this->_postTypesFromWp[ $offset ] );
    }



	/**
	 * @return unknown_type
	 */
	protected function _getPostTypesFromWp() {
		return $this->_postTypesFromWp;
	}
	
	/**
	 * @param unknown_type $postTypesFromWp
	 */
	protected function _setPostTypesFromWp($postTypesFromWp) {
		$this->_postTypesFromWp = $postTypesFromWp;
		return $this;
	}

	/**
	 * @return ffCustomPostTypeCollectionItem_Factory
	 */
	protected function _getCustomPostTypeCollectionItemFactory() {
		return $this->_customPostTypeCollectionItemFactory;
	}
	
	/**
	 * @param ffCustomPostTypeCollectionItem_Factory $customPostTypeCollectionItemFactory
	 */
	protected function _setCustomPostTypeCollectionItemFactory(ffCustomPostTypeCollectionItem_Factory $customPostTypeCollectionItemFactory) {
		$this->_customPostTypeCollectionItemFactory = $customPostTypeCollectionItemFactory;
		return $this;
	}
	
	
}