<?php
/*
Plugin Name: Ark Theme Core Plugin
Plugin URI: http://freshface.net
Description: Shortcodes & Custom Post Types for Ark Theme
Version: 1.70.0
Requires PHP: 8.0.0
Author: FRESHFACE
Author URI: http://arktheme.com/
Text Domain: ark-core
Dependency: fresh-framework
*/

if( !function_exists('ark_environment_check') ) {
	function ark_environment_check() {
		$requiredPhpVersion = '8.0.0';
		$currentPhpVersion = phpversion();

		if (isset($_GET['action']) && $_GET['action'] === 'deploy-theme') {
			return;
		}

		if( version_compare( $requiredPhpVersion, $currentPhpVersion, '<=') == false ) {
			echo '<div style="padding-top:80px; font-size:25px; max-width:980px; margin: 0 auto;">';
				echo '<p><strong style="font-size:35px;">PHP '.$requiredPhpVersion.' or greater is required.</strong></p>';
				echo '<p>Your version is: ' . phpversion() . '</p>';
				echo '<p>Currently, 99% of hosting providers offer PHP '.$requiredPhpVersion.' version or greater.</p>';
				echo '<p>You now have these options to solve it:</p>';
				echo '<p><strong>A) Contact your hosting and ask them to update PHP for you.</strong></p>';
				echo '<p><strong>B) Update PHP by yourself in your hosting admin area (cPanel, ..).</strong></p>';
				echo '<p>Officially recommended hosting provider is: <a href="https://www.cloudways.com/en/?id=863732" target="_blank">Cloudways</a>. <br><i>(use promo code FRESH20 to get 20% OFF for 2 months)</i></p>';
				echo '<p>And if you struggle with anything, please feel free to ask for help 🤗<p>';
				echo '<p>- <a href="https://themeforest.net/user/freshface">Send a Direct Message (log in to see the form)</a></p>';
				echo '<p>- <a href="http://arktheme.com/open-ticket/">Open a Support Ticket</a></p>';
			echo '</div>';
			die();
		}
	}
	ark_environment_check();
}

define('FF_ARK_CORE_PLUGIN_VERSION', '1.70.0');

if( !function_exists('ff_plugin_fresh_framework_notification') ) {
	function ff_plugin_fresh_framework_notification() {
		?>
	    <div class="error">
	    <p><strong><em>Fresh</strong></em> plugins require the <strong><em>'Fresh Framework'</em></strong> plugin to be activated first.</p>
	    </div>
	    <?php
	}
	add_action( 'admin_notices', 'ff_plugin_fresh_framework_notification' );
}
