<?php
/**
 * Top Bar / Right
 *
 * @package logistix
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Get top content
$welcome = logistix_get_mod( 'top_bar_content_welcome', 'Have Question? Contact Us' );
$email = logistix_get_mod( 'top_bar_content_email', '' );
$phone = logistix_get_mod( 'top_bar_content_phone', '01930 210310' );
$address = logistix_get_mod( 'top_bar_content_address', '' );
?>

<div class="top-bar-left">
    <div class="inner"></div>
</div>
<div class="top-bar-right">
    <?php
    // Top Languages
    if ( class_exists( 'SitePress' ) ) {
        echo '<div class="languages-switcher">';
        $languages = icl_get_languages('skip_missing=N&orderby=KEY&order=DIR&link_empty_to=str');

        foreach ( $languages as $l ) {
            $url =  $l['url'];
            $active = $l['active'];
            $name = $l['native_name'];
            $langs = array();

            if ( $active == 1 ) { ?>
                <a class="active" href="<?php echo esc_url( $url ); ?>">
                    <?php echo esc_html( $name ); ?>
                </a>
            <?php }
        }
        if ( 1 < count( $languages ) ) {
            echo '<div class="sub-lang">';
            foreach( $languages as $l ) {
                if ( !$l['active'] )
                    $langs[] = '<a href="'. esc_url( $l['url'] ) .'">'. esc_html( $l['translated_name'] ) .'</a>';
            }

            echo join(' ', $langs);
            echo '</div>';
        }
        echo '</div>';
    }
    ?>

    <div class="top-bar-information">
        <?php
        // Top content
        if ( $welcome ) : ?>
            <span class="welcome content">
                <?php echo do_shortcode( $welcome ); ?>
            </span>
        <?php endif;
        if ( $email ) : ?>
            <span class="email content">
                <?php echo do_shortcode( $email ); ?>
            </span>
        <?php endif;

        if ( $phone ) : ?>
            <span class="phone content">
                <?php echo do_shortcode( $phone ); ?>
            </span>
        <?php endif;

        if ( $address ) : ?>
            <span class="address content">
                <?php echo do_shortcode( $address ); ?>
            </span>
        <?php endif; ?>
    </div><!-- /.top-bar-information -->

    <div class="top-bar-menu-wrap">
        <div class="inner">
        <?php
        // Top menu
        wp_nav_menu( array(
            'theme_location' => 'top',
            'fallback_cb'    => false,
            'container'      => false,
            'menu_class'     => 'top-bar-menu',
        ) );
        ?>
        </div>
    </div><!-- /.top-bar-menu -->

    <div class="socials-network">
        <div class="inner">
            <span class="icons">
            <?php
            // Get social options array
            $profiles =  logistix_get_mod( 'social_network_profiles' );
            $social_options = logistix_social_network_options();

            foreach ( $social_options as $key => $val ) :
                // Get URL from the theme mods
                $url = isset( $profiles[$key] ) ? $profiles[$key] : '';

                if ( $url ) :
                    // Display link
                    echo '<a href="'. esc_url( $url ) .'" title="'. esc_attr( $val['label'] ) .'"><span class="'. esc_attr( $val['icon_class'] ) .'"></span></a>';
                endif;
            endforeach; ?>
            </span>
        </div>
    </div><!-- /.top-bar-socials -->
</div><!-- /.top-bar-right -->