<?php
/**
 * Entry Content / Media
 *
 * @package logistix
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( is_single() && ! logistix_get_mod( 'blog_single_media', true ) )
	return;

$html = $thumb = '';

switch ( get_post_format() ) {
	case 'gallery':
		$icon = 'post-gallery';
		$size = 'logistix-post-standard';

		if ( is_page_template( 'templates/page-blog-grid.php' ) )
			$size = 'logistix-post-grid';

		$images = logistix_metabox( 'gallery_images', "type=image&size=$size" );

		if ( empty( $images ) )
			break;

		wp_enqueue_script( 'logistix-slick' );
		$html = '<div class="blog-gallery">';

		foreach ( $images as $image ) {
			$html .= sprintf(
				'<div><img src="%s" alt="%s"></div>',
				esc_url( $image['url'] ),
				esc_attr__('gallery', 'logistix')
			);
		}
		$html .= '</div>';
		break;
	case 'video':
		$icon = 'post-video';
		$video = logistix_metabox( 'video_url' );
		if ( ! $video )
			break;

		if ( filter_var( $video, FILTER_VALIDATE_URL ) ) {
			// If URL: show oEmbed HTML
			if ( $oembed = @wp_oembed_get( $video ) )
				$html .= $oembed;
		} else {
			// If embed code: just display
			$html .= $video;
		}
		break;
	default:
		$icon = 'post-standard"';
		$size = 'logistix-post-standard';

		if ( is_page_template( 'templates/page-blog-grid.php' ) )
			$size = 'logistix-post-grid';

		if ( is_page_template( 'templates/page-blog-list.php' ) )
			$size = 'logistix-post-list';

		if ( is_single() )
			$size = 'logistix-post-single';

		$thumb = get_the_post_thumbnail( get_the_ID(), $size );
		if ( empty( $thumb ) )
			return;

		if ( is_single() ) {
			$html .= $thumb;
		} else {
			$html .= '<a href="' . esc_url( get_permalink() ) . '">';
			$html .= $thumb;
			$html .= '</a>';
		}
}

if ( logistix_get_mod( 'blog_custom_date', false ) )
	$html .= '<div class="post-date-custom"><span>'.get_the_date("d").'</span><span>'.get_the_date("M").'</span></div>';

if ( $html )
	printf( '<div class="post-media clearfix">%1$s</div>', $html );
