<?php
if ( function_exists('vc_add_param') ) {
    vc_add_param(
        'vc_row',
        array(
            "type" => "dropdown",
            "heading" => esc_html__('Content Position: Middle', 'logistix'),
            "param_name" => "row_content_position",
            'value' => array(
                'Default' => 'Default',
                'Top' => 'top',
                'Middle' => 'middle',
                'Bottom' => 'bottom'
            ),   
        ) 
    );
    vc_add_param(
        'vc_row',
        array(
            "type" => "dropdown",
            "heading" => esc_html__('Equal Height', 'logistix'),
            "param_name" => "row_equal_height",
            "value" => array(   
                esc_html__('No', 'logistix') => 'no',  
                esc_html__('Yes', 'logistix') => 'yes',                                                                                
            ),     
        ) 
    );
    vc_add_param(
        'vc_row',
        array(
            "type" => "dropdown",
            "heading" => esc_html__('Fullwidth', 'logistix'),
            "param_name" => "fullwidth",
            "value" => array(   
                esc_html__('No', 'logistix') => 'no',  
                esc_html__('Yes', 'logistix') => 'yes',                                                                                
            ),
            "description" => esc_html__("Select 'Yes' to stretch row and content", 'logistix' ),      
        ) 
    );
    vc_add_param(
        'vc_row',
        array(
            "type" => "dropdown",
            "heading" => esc_html__('Spacing Between Columns', 'logistix'),
            "param_name" => "column_spacing",
            'value' => array(
                esc_html__( 'Default', 'logistix' ) => '30',
                '0px' => '0px',
                '1px' => '1',
                '5px' => '5',
                '10px' => '10',
                '12px' => '12',
                '20px' => '20',
                '22px' => '22',
                '30px' => '30',
                '32px' => '32',
                '40px' => '40',
                '42px' => '42',
                '50px' => '50',
                '60px' => '60',
                '70px' => '70',
                '80px' => '80',
                '90px' => '90',
            ),     
        ) 
    );
    vc_add_param(
        'vc_row',
        array(
            'type' => 'checkbox',
            'heading' => esc_html__( 'Enable Aside Image for Row?', 'logistix' ),
            'param_name' => 'img_halfrow',
            'description' => esc_html__( 'Put a image left or right side of row', 'logistix' ),
            'value' => array( esc_html__( 'Yes', 'logistix' ) => 'yes' ),
        )
    );
    vc_add_param(
        'vc_row',
        array(
            'type' => 'attach_image',
            'heading' => esc_html__( 'Image', 'logistix' ),
            'param_name' => 'halfrow_image',
            'value' => '',
            'description' => esc_html__( 'Select image from media library.', 'logistix' ),
            'dependency' => array(
                'element' => 'img_halfrow',
                'not_empty' => true,
            ),
        )
    );
    vc_add_param(
        'vc_row',
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Columns image', 'logistix' ),
            'param_name' => 'img_columns',
            'value' => array(
                esc_html__( 'Default', 'logistix' ) => '',
                esc_html__( 'Image on 3 Columns', 'logistix' ) => '3columns',
                esc_html__( 'Image on 4 Columns', 'logistix' ) => '4columns',
                esc_html__( 'Image on 5 Columns', 'logistix' ) => '5columns',
                esc_html__( 'Image on 6 Columns', 'logistix' ) => '6columns',
                esc_html__( 'Image on 7 Columns', 'logistix' ) => '7columns',
            ),
            'description' => esc_html__( 'Select columns position within row.', 'logistix' ),
            'dependency' => array(
                'element' => 'img_halfrow',
                'not_empty' => true,
            ),
        )
    );
    vc_add_param(
        'vc_row',
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Image position', 'logistix' ),
            'param_name' => 'img_position',
            'value' => array(
                esc_html__( 'Default', 'logistix' ) => '',
                esc_html__( 'Image on Left Row', 'logistix' ) => 'imgleft',
                esc_html__( 'Image on Right Row', 'logistix' ) => 'imgright',                
            ),
            'description' => esc_html__( 'Select Image position within row.', 'logistix' ),
            'dependency' => array(
                'element' => 'img_halfrow',
                'not_empty' => true,
            ),
        )
    );
    // Add new Param in Row Inner  
    vc_add_param(
        'vc_row_inner',
        array(
            "type" => "dropdown",
            "heading" => esc_html__('Spacing Between Columns', 'logistix'),
            "param_name" => "column_inner_spacing",
            'value' => array(
                esc_html__( 'Default', 'logistix' ) => '30',
                '0px' => '0px',
                '1px' => '1',
                '5px' => '5',
                '10px' => '10',
                '12px' => '12',
                '20px' => '20',
                '22px' => '22',
                '30px' => '30',
                '32px' => '32',
                '40px' => '40',
                '42px' => '42',
                '50px' => '50',
                '60px' => '60',
                '70px' => '70',
                '80px' => '80',
                '90px' => '90',
            ),     
        ) 
    );
}

if ( function_exists('vc_remove_param') ) {
    vc_remove_param( "vc_row", "full_width" );
    vc_remove_param( "vc_row", "content_placement" );
    vc_remove_param( "vc_row", "equal_height" );
    vc_remove_param( "vc_row", "full_height" );
    vc_remove_param( "vc_row", "video_bg" );
    vc_remove_param( "vc_row", "video_bg_parallax" );
    vc_remove_param( "vc_row", "video_bg_url" );
    vc_remove_param( "vc_row", "parallax_speed_video" );
    vc_remove_param( "vc_row", "columns_placement" );
    vc_remove_param( "vc_row", "gap" );
    vc_remove_param( 'vc_row_inner', 'gap' );
    vc_remove_param( 'vc_row_inner', 'equal_height' );
    vc_remove_param( 'vc_row_inner', 'content_placement' );
    vc_remove_param( "vc_column", "css_animation" );
    vc_remove_param( "vc_column", "video_bg" );
    vc_remove_param( "vc_column", "video_bg_parallax" );
    vc_remove_param( "vc_column", "video_bg_url" );
}    