<?php
/**
 * Top Bar setting for Customizer
 *
 * @package logistix
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Top Bar 1 General
$this->sections['logistix_topbar_general_one'] = array(
	'title' => esc_html__( 'General', 'logistix' ),
	'panel' => 'logistix_topbar',
	'settings' => array(
		array(
			'id' => 'top_bar_one_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_one',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-1 #top-bar',
					'.header-style-1 .top-bar-left .inner:after',
				),
				'alter' => array(
					'background-color',
					'border-top-color',
				),
			),
		),
		array(
			'id' => 'top_bar_one_text',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Text Color', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_one',
			),
			'inline_css' => array(
				'target' => '.header-style-1 #top-bar',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'top_bar_one_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_one',
			),
			'inline_css' => array(
				'target' => '.header-style-1 #top-bar a',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'top_bar_one_social_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Socials: Color', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_one',
			),
			'inline_css' => array(
				'target' => '.header-style-1 #top-bar .socials-network .icons a',
				'alter' => 'color',
			),
		),
	),
);

// Top Bar 2 General
$this->sections['logistix_topbar_general_two'] = array(
	'title' => esc_html__( 'General', 'logistix' ),
	'panel' => 'logistix_topbar',
	'settings' => array(
		array(
			'id' => 'top_bar_two_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_two',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-2 #top-bar',
					'.header-style-2 .top-bar-left .inner:after',
				),
				'alter' => array(
					'background-color',
					'border-top-color',
				),
			),
		),
		array(
			'id' => 'top_bar_two_text',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Text Color', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_two',
			),
			'inline_css' => array(
				'target' => '.header-style-2 #top-bar',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'top_bar_two_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_two',
			),
			'inline_css' => array(
				'target' => '.header-style-2 #top-bar a',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'top_bar_two_social_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Socials: Color', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_two',
			),
			'inline_css' => array(
				'target' => '.header-style-2 #top-bar .socials-network .icons a',
				'alter' => 'color',
			),
		),
	),
);

// Top Bar 3  General
$this->sections['logistix_topbar_general_three'] = array(
	'title' => esc_html__( 'General', 'logistix' ),
	'panel' => 'logistix_topbar',
	'settings' => array(
		array(
			'id' => 'top_bar_three_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_three',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-3 #top-bar',
					'.header-style-3 .top-bar-left .inner:after',
				),
				'alter' => array(
					'background-color',
					'border-top-color',
				),
			),
		),
		array(
			'id' => 'top_bar_three_text',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Text Color', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_three',
			),
			'inline_css' => array(
				'target' => '.header-style-3 #top-bar',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'top_bar_three_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_three',
			),
			'inline_css' => array(
				'target' => '.header-style-3 #top-bar a',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'top_bar_three_social_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Socials: Color', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_three',
			),
			'inline_css' => array(
				'target' => '.header-style-3 #top-bar .socials-network .icons a',
				'alter' => 'color',
			),
		),
	),
);

// Top Bar Content
$this->sections['logistix_topbar_content'] = array(
	'title' => esc_html__( 'Content', 'logistix' ),
	'panel' => 'logistix_topbar',
	'settings' => array(
		array(
			'id' => 'top_bar_content_welcome',
			'default' => 'Have Question? Contact Us',
			'control' => array(
				'label' => esc_html__( 'Welcome Text', 'logistix' ),
				'type' => 'logistix_textarea',
				'rows' => 3,
				'active_callback' => 'logistix_cac_has_topbar',
			),
		),
		array(
			'id' => 'top_bar_content_email',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Email', 'logistix' ),
				'type' => 'logistix_textarea',
				'rows' => 3,
				'active_callback' => 'logistix_cac_has_topbar',
			),
		),
		array(
			'id' => 'top_bar_content_phone',
			'default' => '01930 210310',
			'control' => array(
				'label' => esc_html__( 'Phone', 'logistix' ),
				'type' => 'logistix_textarea',
				'rows' => 3,
				'active_callback' => 'logistix_cac_has_topbar',
			),
		),
		array(
			'id' => 'top_bar_content_address',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Address', 'logistix' ),
				'type' => 'logistix_textarea',
				'rows' => 3,
				'active_callback' => 'logistix_cac_has_topbar',
			),
		),
	),
);

// Bottom Socials
$this->sections['logistix_social_network'] = array(
	'title' => esc_html__( 'Social', 'logistix' ),
	'panel' => 'logistix_topbar',
	'settings' => array(
		array(
			'id' => 'social_network_space_between',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Space Between Items', 'logistix' ),
				'description' => esc_html__( 'Example: 10px.', 'logistix' ),
			),
			'inline_css' => array(
				'target' => '#bottom .top-bar-socials .icons a',
				'alter' => 'margin-left',
			),
		),
		array(
			'id' => 'social_network_font_size',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Icon Size', 'logistix' ),
				'description' => esc_html__( 'Example: 20px.', 'logistix' ),
			),
			'inline_css' => array(
				'target' => '#bottom .top-bar-socials .icons a',
				'alter' => 'font-size',
			),
		),
	),
);

// Social settings
$social_options = logistix_social_network_options();
foreach ( $social_options as $key => $val ) {
	$this->sections['logistix_social_network']['settings'][] = array(
		'id' => 'social_network_profiles[' . $key .']',
		'control' => array(
			'label' => $val['label'],
			'type' => 'text',
		),
	);
}

// Remove var from memory
unset( $social_options );