<?php
/**
 * Projects setting for Customizer
 *
 * @package logistix
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Project Related General
$this->sections['logistix_projects_general'] = array(
	'title' => esc_html__( 'General', 'logistix' ),
	'panel' => 'logistix_projects',
	'settings' => array(
		array(
			'id' => 'project_related',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Enable', 'logistix' ),
				'type' => 'checkbox',
				'active_callback' => 'logistix_cac_has_single_project',
			),
		),
		array(
			'id' => 'project_related_title',
			'default' => esc_html__( 'YOU MAY ALSO LIKE', 'logistix' ),
			'control' => array(
				'label' => esc_html__( 'Project Related Title', 'logistix' ),
				'type' => 'text',
				'active_callback' => 'logistix_cac_has_related_project',
			),
		),
		array(
			'id' => 'project_related_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Wrap Padding', 'logistix' ),
				'description' => esc_html__( 'Top Right Bottom Left. Example: 100px 0px 100px 0px', 'logistix' ),
				'active_callback' => 'logistix_cac_has_related_project',
			),
			'inline_css' => array(
				'target' => '.project-related-wrap',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'project_related_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Wrap Background', 'logistix' ),
				'active_callback' => 'logistix_cac_has_related_project',
			),
			'inline_css' => array(
				'target' => '.project-related-wrap',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'project_related_query',
			'default' => 9,
			'control' => array(
				'label' => esc_html__( 'Number of items', 'logistix' ),
				'type' => 'number',
				'active_callback' => 'logistix_cac_has_related_project',
			),
		),
		array(
			'id' => 'project_related_column',
			'default' => '3',
			'control' => array(
				'label' => esc_html__( 'Columns', 'logistix' ),
				'type' => 'select',
				'choices' => array(
					'4' => '4',
					'3' => '3',
					'2' => '2',
				),
				'active_callback' => 'logistix_cac_has_related_project',
			),
		),
		array(
			'id' => 'project_related_item_spacing',
			'default' => 17,
			'control' => array(
				'label' => esc_html__( 'Spacing between items', 'logistix' ),
				'type' => 'number',
				'active_callback' => 'logistix_cac_has_related_project',
			),
		),
		array(
			'id' => 'project_related_img_crop',
			'default' => 'square',
			'control' => array(
				'label' => esc_html__( 'Image Size', 'logistix' ),
				'type' => 'select',
				'choices' => array(
					'square' => '600 x 600',
					'rectangle' => '600 x 500',
					'rectangle2' => '600 x 390',
				),
				'active_callback' => 'logistix_cac_has_related_project',
			),
		),

	),
);