<?php
/**
 * Layout setting for Customizer
 *
 * @package logistix
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Layout Style
$this->sections['logistix_layout_style'] = array(
	'title' => esc_html__( 'Layout Site', 'logistix' ),
	'panel' => 'logistix_layout',
	'settings' => array(
		array(
			'id' => 'site_layout_style',
			'default' => 'full-width',
			'control' => array(
				'label' => esc_html__( 'Layout Style', 'logistix' ),
				'type' => 'select',
				'choices' => array(
					'full-width' => esc_html__( 'Full Width','logistix' ),
					'boxed' => esc_html__( 'Boxed','logistix' )
				),
			),
		),
		array(
			'id' => 'site_layout_boxed_shadow',
			'control' => array(
				'label' => esc_html__( 'Box Shadow', 'logistix' ),
				'type' => 'checkbox',
				'active_callback' => 'logistix_cac_has_boxed_layout',
			),
		),
		array(
			'id' => 'site_layout_wrapper_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Wrapper Margin', 'logistix' ),
				'desc' => esc_html__( 'Top Right Bottom Left. Default: 30px 0px 30px 0px.', 'logistix' ),
				'active_callback' => 'logistix_cac_has_boxed_layout',
			),
			'inline_css' => array(
				'target' => '.site-layout-boxed #wrapper',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'wrapper_background_color',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Outer Background Color', 'logistix' ),
				'type' => 'color',
				'active_callback' => 'logistix_cac_has_boxed_layout',
			),
			'inline_css' => array(
				'target' => '.site-layout-boxed #wrapper',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'wrapper_background_img',
			'control' => array(
				'label' => esc_html__( 'Outer Background Image', 'logistix' ),
				'type' => 'image',
				'active_callback' => 'logistix_cac_has_boxed_layout',
			),
		),
		array(
			'id' => 'wrapper_background_img_style',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Outer Background Image Style', 'logistix' ),
				'type'  => 'image',
				'type'  => 'select',
				'choices' => array(
					''             => esc_html__( 'Default', 'logistix' ),
					'cover'        => esc_html__( 'Cover', 'logistix' ),
					'center-top'        => esc_html__( 'Center Top', 'logistix' ),
					'fixed-top'    => esc_html__( 'Fixed Top', 'logistix' ),
					'fixed'        => esc_html__( 'Fixed Center', 'logistix' ),
					'fixed-bottom' => esc_html__( 'Fixed Bottom', 'logistix' ),
					'repeat'       => esc_html__( 'Repeat', 'logistix' ),
					'repeat-x'     => esc_html__( 'Repeat-x', 'logistix' ),
					'repeat-y'     => esc_html__( 'Repeat-y', 'logistix' ),
				),
				'active_callback' => 'logistix_cac_has_boxed_layout',
			),
		),
	),
);

// Layout Position
$this->sections['logistix_layout_position'] = array(
	'title' => esc_html__( 'Layout Position', 'logistix' ),
	'panel' => 'logistix_layout',
	'settings' => array(
		array(
			'id' => 'site_layout_position',
			'default' => 'sidebar-right',
			'control' => array(
				'label' => esc_html__( 'Site Layout Position', 'logistix' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'logistix' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'logistix' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'logistix' ),
				),
				'desc' => esc_html__( 'Specify layout for all pages on website. (e.g. pages, blog posts, single post, archives, etc ). Single page can override this setting in Page Settings metabox when edit.', 'logistix' )
			),
		),
		array(
			'id' => 'single_post_layout_position',
			'default' => 'sidebar-right',
			'control' => array(
				'label' => esc_html__( 'Single Post Layout Position', 'logistix' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'logistix' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'logistix' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'logistix' ),
				),
				'desc' => esc_html__( 'Specify layout for all single post pages.', 'logistix' )
			),
		),
	),
);

// Layout Widths
$this->sections['logistix_layout_widths'] = array(
	'title' => esc_html__( 'Layout Widths', 'logistix' ),
	'panel' => 'logistix_layout',
	'settings' => array(
		array(
			'id' => 'site_desktop_container_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Container', 'logistix' ),
				'type' => 'text',
				'desc' => esc_html__( 'Default: 1180px', 'logistix' ),
			),
			'inline_css' => array(
				'target' => array( 
					'.site-layout-full-width .logistix-container',
					'.site-layout-boxed #page'
				),
				'alter' => 'width',
			),
		),
		array(
			'id' => 'left_container_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Content', 'logistix' ),
				'type' => 'text',
				'desc' => esc_html__( 'Example: 66%', 'logistix' ),
			),
			'inline_css' => array(
				'target' => '#site-content',
				'alter' => 'width',
			),
		),
		array(
			'id' => 'sidebar_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Sidebar', 'logistix' ),
				'type' => 'text',
				'desc' => esc_html__( 'Example: 23%', 'logistix' ),
			),
			'inline_css' => array(
				'target' => '#sidebar',
				'alter' => 'width',
			),
		),
	),
);