<?php
/**
 * Header setting for Customizer
 *
 * @package logistix
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Header General
$this->sections['logistix_header_general'] = array(
	'title' => esc_html__( 'General', 'logistix' ),
	'panel' => 'logistix_header',
	'settings' => array(
		// Header 1 2 3 4
		array(
			'id' => 'header_background',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Background', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_white',
				'type' => 'color',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-1 #site-header',
					'.header-style-2 #site-header',
					'.header-style-3 #site-header',
					'.header-style-4 #site-header',
					'.top-bar-left .inner:before',
					'.top-bar-left .inner:after',
				),
				'alter' => array(
					'background-color',
					'border-left-color',
				),
			),
		),
		array(
			'id' => 'header_top_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Top Padding', 'logistix' ),
				'description' => esc_html__( 'Example: 50px.', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_white',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-1 #site-header-inner',
					'.header-style-2 #site-header-inner',
					'.header-style-3 #site-header-inner',
					'.header-style-4 #site-header-inner'
				),
				'alter' => 'padding-top',
			),
		),
		array(
			'id' => 'header_bottom_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Bottom Padding', 'logistix' ),
				'description' => esc_html__( 'Example: 50px.', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_white',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-1 #site-header-inner',
					'.header-style-2 #site-header-inner',
					'.header-style-3 #site-header-inner',
					'.header-style-4 #site-header-inner'
				),
				'alter' => 'padding-bottom',
			),
		),
		// Header 5
		array(
			'id' => 'header_five_background',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Background', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_five',
				'type' => 'color',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-5 #site-header'
				),
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'header_five_top_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Top Padding', 'logistix' ),
				'description' => esc_html__( 'Example: 50px.', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_five',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-5 #site-header-inner'
				),
				'alter' => 'padding-top',
			),
		),
		array(
			'id' => 'header_five_bottom_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Bottom Padding', 'logistix' ),
				'description' => esc_html__( 'Example: 50px.', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_five',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-5 #site-header-inner'
				),
				'alter' => 'padding-bottom',
			),
		),
	)
);

// Header Logo
$this->sections['logistix_header_logo'] = array(
	'title' => esc_html__( 'Logo', 'logistix' ),
	'panel' => 'logistix_header',
	'settings' => array(
		array(
			'id' => 'logo_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Logo Margin', 'logistix' ),
		 		'description' => esc_html__( 'Top Right Bottom Left. Example: 30px 0px 0px 0px.', 'logistix' ),
			),
			'inline_css' => array(
				'media_query' => '(min-width: 992px)',
				'target' => '#site-logo-inner',
				'alter' => 'margin',
			),
		),
		// Logo 1 2 3 4
		array(
			'id' => 'custom_logo',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Logo Image', 'logistix' ),
				'type' => 'image',
				'active_callback' => 'logistix_cac_has_header_white',
			),
		),
		array(
			'id' => 'logo_width',
			'control' => array(
				'label' => esc_html__( 'Logo Width', 'logistix' ),
				'description' => esc_html__( 'This should be exactly the same as the width of the logo.', 'logistix' ),
				'type' => 'text',
				'active_callback' => 'logistix_cac_has_header_white',
			),
		),
		array(
			'id' => 'logo_height',
			'control' => array(
				'label' => esc_html__( 'Logo Height', 'logistix' ),
				'type' => 'text',
				'description' => esc_html__( 'This should be exactly the same as the height of the logo.', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_white',
			),
		),
		array(
			'id' => 'retina_logo',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Retina Logo Image', 'logistix' ),
				'type' => 'image',
				'description' => esc_html__('2x times your logo dimension.', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_white',
			),
		),
		// Logo 5
		array(
			'id' => 'custom_logotwo',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Logo Image', 'logistix' ),
				'type' => 'image',
				'active_callback' => 'logistix_cac_has_header_five',
			),
		),
		array(
			'id' => 'logotwo_width',
			'control' => array(
				'label' => esc_html__( 'Logo Width', 'logistix' ),
				'description' => esc_html__( 'This should be exactly the same as the width of the logo.', 'logistix' ),
				'type' => 'text',
				'active_callback' => 'logistix_cac_has_header_five',
			),
		),
		array(
			'id' => 'logotwo_height',
			'control' => array(
				'label' => esc_html__( 'Logo Height', 'logistix' ),
				'type' => 'text',
				'description' => esc_html__( 'This should be exactly the same as the height of the logo.', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_five',
			),
		),
		array(
			'id' => 'retina_logotwo',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Retina Logo Image', 'logistix' ),
				'type' => 'image',
				'description' => esc_html__('2x times your logo dimension.', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_five',
			),
		),
	)
);

// Header Menu
$this->sections['logistix_header_menu'] = array(
	'title' => esc_html__( 'Menu', 'logistix' ),
	'panel' => 'logistix_header',
	'settings' => array(
		// General
		array(
			'id' => 'menu_link_spacing',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Link Spacing', 'logistix' ),
				'description' => esc_html__( 'Example: 20px.', 'logistix' ),
			),
			'inline_css' => array(
				'target' => array(
					'#site-header #main-nav > ul > li',
				),
				'alter' => array(
					'padding-left',
					'padding-right',
				),
			),
		),
		array(
			'id' => 'menu_height',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Menu Height', 'logistix' ),
				'description' => esc_html__( 'Default: 100px.', 'logistix' ),
			),
			'inline_css' => array(
				'target' => array(
					'#site-header #main-nav > ul > li > a',
				),
				'alter' => array(
					'height',
					'line-height',
				),
			),
		),
		// Header 1 2 3 4
		array(
			'id' => 'menu_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_white',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-1 #site-header #main-nav > ul > li > a',
					'.header-style-2 #site-header #main-nav > ul > li > a',
					'.header-style-3 #site-header #main-nav > ul > li > a',
					'.header-style-4 #site-header #main-nav > ul > li > a',
				),
				'alter' => 'color',
			),
		),
		array(
			'id' => 'menu_link_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color: Hover', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_white',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-1 #site-header #main-nav > ul > li > a:hover',
					'.header-style-2 #site-header #main-nav > ul > li > a:hover',
					'.header-style-3 #site-header #main-nav > ul > li > a:hover',
					'.header-style-4 #site-header #main-nav > ul > li > a:hover',
				),
				'alter' => 'color',
			),
		),
		array(
			'id' => 'menu_link_current',
			'default' => 'cur-menu-1',
			'control' => array(
				'label' => esc_html__( 'Current Link Style', 'logistix' ),
				'type' => 'select',
				'choices' => array(
					'cur-menu-1' => esc_html__( 'Style 1', 'logistix' ),
					'cur-menu-2'  => esc_html__( 'Style 2', 'logistix' ),
					'cur-menu-3'    => esc_html__( 'Style 3', 'logistix' ),
				),
				'active_callback' => 'logistix_cac_has_header_white',
			),
		),
		// Header 5
		array(
			'id' => 'menufive_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_five',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-5 #site-header #main-nav > ul > li > a',
				),
				'alter' => 'color',
			),
		),
		array(
			'id' => 'menufive_link_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color: Hover', 'logistix' ),
				'active_callback' => 'logistix_cac_has_header_five',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-5 #site-header #main-nav > ul > li > a:hover',
				),
				'alter' => 'color',
			),
		),
		array(
			'id' => 'menu_five_link_current',
			'default' => 'cur-menu-2',
			'control' => array(
				'label' => esc_html__( 'Current Link Style', 'logistix' ),
				'type' => 'select',
				'choices' => array(
					'cur-menu-1' => esc_html__( 'Style 1', 'logistix' ),
					'cur-menu-2'  => esc_html__( 'Style 2', 'logistix' ),
					'cur-menu-3'    => esc_html__( 'Style 3', 'logistix' ),
				),
				'active_callback' => 'logistix_cac_has_header_five',
			),
		),
	)
);

// Search & Cart
$this->sections['logistix_header_search_cart'] = array(
	'title' => esc_html__( 'Search & Cart Icon', 'logistix' ),
	'panel' => 'logistix_header',
	'settings' => array(
		// Search Icon
		array(
			'id' => 'header_search_icon',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Search Icon', 'logistix' ),
				'type' => 'checkbox',
			),
		),
		array(
			'id' => 'header_search_icon_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Search Icon: Margin', 'logistix' ),
				'description' => esc_html__( 'Default: 30px 0 30px 20px', 'logistix' ),
			),
			'inline_css' => array(
				'target' => '#site-header #header-search',
				'alter' => 'padding',
			),
		),
		// Cart Icon
		array(
			'id' => 'header_cart_icon',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Cart Icon', 'logistix' ),
				'type' => 'checkbox',
				'active_callback' => 'logistix_cac_has_woo',
			),
		),
		array(
			'id' => 'header_cart_icon_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Cart Icon: Margin', 'logistix' ),
				'description' => esc_html__( 'Default: 30px 0 30px 49px', 'logistix' ),
			),
			'inline_css' => array(
				'target' => '.nav-top-cart-wrapper',
				'alter' => 'padding',
			),
		),
	)
);