<?php
/**
 * Accent color
 *
 * @package logistix
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Start Class
if ( ! class_exists( 'LOGISTIX_Accent_Color' ) ) {
	class LOGISTIX_Accent_Color {
		// Main constructor
		public function __construct() {
			add_filter( 'logistix_footer_css', array( 'LOGISTIX_Accent_Color', 'generate' ), 1 );
		}

		// Generates arrays of elements to target
		private static function arrays( $return ) {
			// Color
			$texts = apply_filters( 'logistix_accent_texts', array(
				'.text-accent-color', '#site-logo .site-logo-text:hover',
				'.header-style-2 #top-bar .socials-network .icons a:hover',
				'.header-style-3 #top-bar .socials-network .icons a:hover',
				'.header-style-3 #top-bar .top-bar-right .content:before',
				'.cur-menu-3 #main-nav > ul > li.current-menu-item > a,.cur-menu-3 #main-nav > ul > li.current-menu-parent > a,.cur-menu-3 #main-nav > ul > li.current-menu-item > a:hover,.cur-menu-3 #main-nav > ul > li.current-menu-parent > a:hover',
				'#site-header .header-search-icon:hover',
				'.header-style-5 #site-header .header-search-icon:hover',
				'.header-style-5 #main-nav > ul > li > a:hover',
				'.nav-top-cart-wrapper .nav-shop-cart ul li a.remove',
				'.nav-top-cart-wrapper .nav-shop-cart ul li a:hover',
				'#featured-title #breadcrumbs a:hover',
				'#featured-title #breadcrumbs .breadcrumb-trail > a:before, #featured-title #breadcrumbs .breadcrumb-trail > span:before',
				'.hentry .post-title a:hover', '.hentry .post-meta a:hover',
				'#footer-widgets .widget.widget_search .search-form .search-submit:before',
				'.widget.widget_categories ul li a:hover',
				'.widget.widget_meta ul li a:hover',
				'.widget.widget_pages ul li a:hover',
				'.widget.widget_archive ul li a:hover',
				'.widget.widget_recent_entries ul li a:hover',
				'.widget.widget_recent_comments ul li a:hover',
				'#sidebar .widget.widget_calendar caption',
				'#footer-widgets .widget.widget_calendar caption',
				'#sidebar .widget.widget_links ul li a:hover',
				'#footer-widgets .widget.widget_links ul li a:hover',
				'#sidebar .widget.widget_recent_posts h3 a:hover',
				'#footer-widgets .widget.widget_recent_posts h3 a:hover',
				'#sidebar .widget.widget_calendar tbody #today a',
				'#footer-widgets .widget.widget_calendar tbody #today a',
				'#footer-widgets .widget.widget_categories ul li a:hover',
				'#footer-widgets .widget.widget_meta ul li a:hover',
				'#footer-widgets .widget.widget_pages ul li a:hover',
				'#footer-widgets .widget.widget_archive ul li a:hover',
				'#footer-widgets .widget.widget_recent_entries ul li a:hover',
				'#footer-widgets .widget.widget_recent_comments ul li a:hover',
				'.widget.widget_nav_menu .menu > li > a:hover',
				'.widget.widget_categories ul li a:before, .widget.widget_meta ul li a:before, .widget.widget_pages ul li a:before',
				'.widget.widget_archive ul li a:before',
				'#sidebar .widget.widget_twitter .tweet-text a',
				'.hentry .post-related .post-item h4 a:hover',
				'.hentry .post-navigation .nav-previous > a:after, .hentry .post-navigation .nav-next > a:after',
				'.bypostauthor > article .comment-author',
				'.logged-in-as a',
				'.hentry .post-related .slick-next:hover:before,.hentry .post-related .slick-prev:hover:before',
				'#bottom ul.bottom-nav > li.current-menu-item > a',
				'#bottom .bottom-socials .icons a:hover',
				// shortcodes
				'.logistix-action-box.has-icon .heading-wrap > .text-wrap > .icon',
				'.logistix-img-advanced .icon-wrap:after',
				'.logistix-divider.has-icon .icon-wrap > span.accent',
				'.logistix-list .icon.style-1.accent',
				'.logistix-list .icon.style-3',
				'.logistix-list .icon.style-6',
				'.button-wrap.has-icon .logistix-button.white > span > .icon',
				'.logistix-icon.background .icon.accent',
				 '.logistix-icon-box.accent-outline .icon-wrap',
				 '.logistix-icon-box.grey-outline .icon-wrap',
				 '.logistix-icon-box.simple .icon-wrap.accent',
				 '.logistix-icon-box.grey-bg .icon-wrap',
				 '.logistix-image-box .item .title a:hover',
				 '.logistix-news .news-item .text-wrap .title a:hover',
				 '.logistix-news-simple .text-wrap .title a:hover',
				 '.logistix-counter .icon-wrap .icon.accent',
				 '.logistix-counter .number-wrap .number.accent',
				 '.logistix-counter .prefix.accent',
				 '.logistix-counter .suffix.accent',
				'.logistix-accordions .accordion-item.active .accordion-heading:hover',
				'.logistix-accordions .accordion-item .accordion-heading:hover',
				'.logistix-accordions .accordion-item .accordion-heading:hover:after',
				'.project-box.style-2 h2:hover:before',
				'.project-box.style-3 h2:hover',
				'.project-box.style-1 .project-text h2:hover',
				 '.logistix-action-box.has-icon .heading-wrap > .text-wrap > .icon.accent',
				 '.logistix-price-table .price-table-price .figure.accent',
				 '.logistix-price-table .price-table-features ul.style-1 li > span:before',
				 '.logistix-countdown.accent .numb',
				 // Woocommerce
				 '.products li .price',
				 '.products li h2:hover',
				 '.woo-single-post-class .summary .price',
				 '.woocommerce-page .shop_table.cart .product-name a:hover',
				 '.woocommerce-page .woocommerce-message .button, .woocommerce-page .woocommerce-info .button, .woocommerce-page .woocommerce-error .button',
				 '.woocommerce-page .product_list_widget .product-title:hover, .woocommerce-page .widget_recent_reviews .product_list_widget a:hover, .woocommerce-page .product_list_widget .mini_cart_item a:hover',
				 '.woocommerce-page .widget_product_categories ul li a:hover',
				 // Default Link
				 'a',
			) );

			// Background color
			$backgrounds = apply_filters( 'logistix_accent_backgrounds', array(
				'.header-style-1 #top-bar',
				'.top-bar-menu li a:before',
				'.cur-menu-2 #main-nav > ul > li.current-menu-item > a > span,.cur-menu-2 #main-nav > ul > li.current-menu-parent > a > span',
				'#main-nav li.megamenu > ul.sub-menu > .menu-item-has-children > a:before',
				'.nav-top-cart-wrapper .shopping-cart-items-count',
				'#featured-title .featured-title-heading:before',
				'.post-media .slick-prev:hover, .post-media .slick-next:hover', '.post-media .slick-dots li.slick-active button',
				'.hentry .post-share a:hover:after',
				'.comments-area .comments-title:after',
				'.comments-area .comment-reply-title:after',
				'#scroll-top:hover:before',
				'#sidebar .widget.widget_recent_posts .recent-news .thumb.icon, #footer-widgets .widget.widget_recent_posts .recent-news .thumb.icon',
				'.widget.widget_nav_menu .menu > li.current-menu-item:before',
				'#sidebar .widget.widget_socials .socials a:hover, #footer-widgets .widget.widget_socials .socials a:hover',
				'.button-widget a:hover',
				'#sidebar .widget.widget_tag_cloud .tagcloud a:hover',
				'#footer-widgets .widget.widget_tag_cloud .tagcloud a:hover',
				'.widget_product_tag_cloud .tagcloud a:hover',
				'#footer-widgets .widget .widget-title > span:after',
				'#sidebar .widget .widget-title > span:after, #footer-widgets .widget .widget-title > span:after',
				'.widget.widget_nav_menu .menu > li.current_page_parent:before, .widget.widget_nav_menu .menu > li.current-menu-item:before',
				'.post-date-custom > span:first-child',
				'.widget.widget_mc4wp_form_widget .submit-wrap input',
				'#sidebar .widget.widget_recent_comments ul li:before',
				'#sidebar .widget.widget_search .search-form .search-submit:before, #footer-widgets .widget.widget_search .search-form .search-submit:before',
				'.hentry .post-link a:hover',
				'.hentry .post-related .post-thumb .post-cat-related a',
				'.hentry .post-tags a:hover',
				'.nav-top-cart-wrapper .nav-shop-cart .buttons > a:first-child',
				'#comments .comment-respond .form-submit input[type="submit"]',
				'.comment-reply a:hover',
				'.footer-promotion',
				'.logistix-pagination ul li a.page-numbers:hover, .logistix-pagination ul li .page-numbers.current',
				// shortcodes
				'.logistix-info-list .title > span',
				'.logistix-image-box .item .inner.accent, .logistix-image-box .item .inner.dark-accent, .logistix-image-box .item .item .inner.light-accent',
				'.logistix-button.accent',
				'.logistix-button.outline:hover',
				'.logistix-button.outline.ol-accent:hover',
				'.logistix-button.dark:hover',
				'.logistix-button.light:hover',
				'.logistix-button.very-light:hover',
				'.logistix-button.outline.dark:hover',
				'.logistix-button.outline.light:hover',
				'.logistix-button.outline.very-light:hover',
				'.logistix-list .icon.style-2',
				'.logistix-list .icon.style-5',
				'.logistix-headings .sep.accent',
				'.logistix-counter .sep.accent',
				'.logistix-icon.background .icon.bg-accent',
				'.logistix-icon-box .btn .simple-link:after',
				'.logistix-icon-box.accent-bg .icon-wrap', '.logistix-icon-box.grey-bg:hover .icon-wrap', '.logistix-icon-box.grey-bg .icon-wrap:after', '.logistix-icon-box.accent-outline:hover .icon-wrap', '.logistix-icon-box.accent-outline .icon-wrap:after', '.logistix-icon-box.grey-outline:hover .icon-wrap', '.logistix-icon-box.grey-outline .icon-wrap:after',
				'.logistix-image-box .item .simple-link:after',
				'.logistix-news .news-item .simple-link:after',
				'.logistix-news .post-date-custom > span:first-child',
				'#project-filter .cbp-filter-item.cbp-filter-item-active, #project-filter .cbp-filter-item:hover',
				'.project-box.style-2 h2',
				'.project-box.style-2 .project-wrap .icon >a:hover',
				'.project-box.style-3 .project-wrap .icon > a',
				'.project-box.style-1 .project-wrap .icon > a',
				'.owl-theme .owl-nav [class*="owl-"]:hover',
				'.has-arrows .cbp-nav-next',
				'.has-arrows .cbp-nav-prev',
				'.bullet-style-1 .cbp-nav-pagination-active', '.bullet-style-2 .cbp-nav-pagination-active ',
				'.logistix-lines .line-1',
				'.logistix-navbar .menu > li.current-nav-item > a',
				'.logistix-progress.style-2.pstyle-1 .perc > span',
				'.logistix-progress .progress-animate.accent',
				'.logistix-socials a:hover', '.logistix-socials.style-2 a:hover',
				'.logistix-team .team-item .socials li a:hover',
				'.logistix-price-table .price-table-name .title.accent', '.logistix-price-table .price-table-price.accent',
				'.logistix-menu-list .value',
				'.owl-theme .owl-dots .owl-dot.active span',
				'.logistix-subscribe.bg-accent',
				'.logistix-subscribe .form-wrap .submit-wrap button',
				'.logistix-tabs.style-2 .tab-title .item-title.active',
				'.logistix-tabs.style-3 .tab-title .item-title.active',
				'.logistix-action-box.accent',
				'.logistix-countdown.accent-bg .column',
				'.logistix-content-box .inner.accent, .logistix-content-box .inner.dark-accent, .logistix-content-box .inner.light-accent',
				'.wpcf7-form .button-accent .wrap-submit input',
				'.logistix-subscribe.bg-dark .mc4wp-form .submit-wrap input',
				'.logistix-subscribe.bg-light .mc4wp-form .submit-wrap input',
				'.logistix-images-grid .cbp-nav-pagination-active',
				// woocemmerce
				'.product .onsale',
				'.products li .product-info .add_to_cart_button, .products li .product-info .product_type_variable, .products li .product-info .added_to_cart',
				'.woocommerce-page .wc-proceed-to-checkout .button', '.woocommerce-page #payment #place_order',
				'.woocommerce-page .widget_shopping_cart .wc-forward:hover, .woocommerce-page .widget_shopping_cart .wc-forward.checkout:hover',
				'.products li .product-info .added_to_cart',
				'.woo-single-post-class .woocommerce-tabs .comment-respond .form-submit #submit',
			) );

			// Border color
			$borders = apply_filters( 'logistix_accent_borders', array(
				'.animsition-loading:after',
				'.woocommerce-pagination .page-numbers li .page-numbers:hover',
				'.woocommerce-pagination .page-numbers li .page-numbers.current',
				'.header-style-1 .top-bar-left .inner:after' => array( 'top' ),
				'.cur-menu-1 #main-nav > ul > li.current-menu-item > a > span, .cur-menu-1 #main-nav > ul > li.current-menu-parent > a > span',
				'#sidebar .widget.widget_tag_cloud .tagcloud a:hover',
				'#footer-widgets .widget.widget_tag_cloud .tagcloud a:hover',
				'.widget_product_tag_cloud .tagcloud a:hover',
				'.button-widget a:hover',
				'.hentry .post-tags a:hover',
				'.comment-reply a:hover',
				// shortcodes
				'.logistix-testimonials .inner:after' => array( 'top' ),
				'.logistix-testimonials .inner' => array( 'bottom' ),
				'.logistix-divider.divider-solid.accent',
				'.divider-icon-before.accent, .divider-icon-after.accent, .logistix-divider.has-icon .divider-double.accent',
				'.logistix-button.outline.ol-accent',
				'.logistix-button.outline.dark:hover',
				'.logistix-button.outline.light:hover',
				'.logistix-button.outline.very-light:hover',
				'.logistix-icon.outline .icon', 
				'.logistix-icon-box.grey-bg:hover .icon-wrap:after', '.logistix-icon-box.accent-outline .icon-wrap', '.logistix-icon-box.grey-outline:hover .icon-wrap',
				'.logistix-navbar .menu > li.current-nav-item > a',
				'.logistix-progress.style-2.pstyle-1 .perc > span:after',
				'.logistix-tabs.style-2 .tab-title .item-title.active > span',
				'.logistix-price-table.border-accent',
				// woocommerce
				'.woocommerce-page .widget_price_filter .ui-slider .ui-slider-handle',
				'.woocommerce-page .widget_shopping_cart .wc-forward',
				'.woocommerce-page .widget_shopping_cart .wc-forward:hover, .woocommerce-page .widget_shopping_cart .wc-forward.checkout:hover',
				'.woocommerce-page .widget_price_filter .price_slider_amount .button:hover'
			) );

			// Return array
			if ( 'texts' == $return ) {
				return $texts;
			} elseif ( 'backgrounds' == $return ) {
				return $backgrounds;
			} elseif ( 'borders' == $return ) {
				return $borders;
			}
		}

		// Generates the CSS output
		public static function generate( $output ) {

			// Get custom accent
			$default_accent = '#166de3';
			$custom_accent  = logistix_get_mod( 'accent_color' );

			// Return if accent color is empty or equal to default
			if ( ! $custom_accent || ( $default_accent == $custom_accent ) )
				return $output;

			// Define css var
			$css = '';

			// Get arrays
			$texts = self::arrays( 'texts' );
			$backgrounds = self::arrays( 'backgrounds' );
			$borders = self::arrays( 'borders' );

			// Texts
			if ( ! empty( $texts ) )
				$css .= implode( ',', $texts ) .'{color:'. $custom_accent .';}';

			// Backgrounds
			if ( ! empty( $backgrounds ) )
				$css .= implode( ',', $backgrounds ) .'{background-color:'. $custom_accent .';}';

			// Borders
			if ( ! empty( $borders ) ) {
				foreach ( $borders as $key => $val ) {
					if ( is_array( $val ) ) {
						$css .= $key .'{';
						foreach ( $val as $key => $val ) {
							$css .= 'border-'. $val .'-color:'. $custom_accent .';';
						}
						$css .= '}'; 
					} else {
						$css .= $val .'{border-color:'. $custom_accent .';}';
					}
				}
			}

			// Return CSS
			if ( ! empty( $css ) )
				$output .= '/*ACCENT COLOR*/'. $css;

			// Return output css
			return $output;
		}
	}
}

new LOGISTIX_Accent_Color();